#ifndef ddutil_h
#define ddutil_h

typedef struct
{
   BITMAPINFO bmpinfo;
   LPSTR lpBits;
   HBITMAP hbmp;
} DIB;

extern DIB dib;

extern LPDIRECTDRAW7 g_pDD;                // DirectDraw Object
extern LPDIRECTDRAWSURFACE7 g_pDDSPrimary; // DirectDraw Primary surface
extern LPDIRECTDRAWSURFACE7 g_pDDSBack;    // DirectDraw Back surface
extern RECT g_rcWindow;                    // Saves Window Dimensions
extern RECT g_rcViewport;                  // Pos. & Size to blit from
extern RECT g_rcScreen;                    // Screen pos. for blit
extern BOOL g_bActive;                     // Is App running/active
extern BOOL g_bReady;                      // Is App ready for updates
extern DWORD red_mask, green_mask, blue_mask; // color bit masks


BOOL LockDDSurface (LPDIRECTDRAWSURFACE7 dds);
void plot_pixel(int x, int y, int r, int g, int b);
void UnlockDDSurface (LPDIRECTDRAWSURFACE7 dds);
void CreateSurface(LPDIRECTDRAWSURFACE7 *lpSource, int xs, int ys);
HRESULT ChangeCoopLevel(HWND hWnd, int w, int h, unsigned char depth);
ReleaseAllObjects(HWND hWnd);
HRESULT InitFail(HWND hWnd, HRESULT hRet, LPCTSTR szError,...);
char *GetErrorDescription(HRESULT hRet);
HRESULT InitSurfaces(HWND hWnd, int w, int h, unsigned char depth);
void ClearSurface(LPDIRECTDRAWSURFACE7 dds);

#endif
