/*
 *     \tgEFACu
 *
 *     Copyright (c) 1994 SEGA
 *
 *  Library: bcʐMC^tF[XiCDCj
 *  Module : CDCCupwb_t@C
 *  File   : sega_cdc.h
 *  Date   : 1995-03-31
 *  Version: 1.20
 *  Author : M.M.
 *
 */

/* dCN[hւ̑Ή */
#ifndef SEGA_CDC_H
#define SEGA_CDC_H

/*******************************************************************
*       CN[ht@C
*******************************************************************/
#include    "sega_xpt.h"

/*******************************************************************
*       萔}N
*******************************************************************/

/* 荞ݗvWX^֌WiHIRQREQ, HIRQMSKj̃rbg */
#define CDC_HIRQ_CMOK   0x0001  /* bit0 FR}hs\ */
#define CDC_HIRQ_DRDY   0x0002  /* bit1 Ff[^] */
#define CDC_HIRQ_CSCT   0x0004  /* bit2 FPZN^ǂݍ݊ */
#define CDC_HIRQ_BFUL   0x0008  /* bit3 Fbcobt@t */
#define CDC_HIRQ_PEND   0x0010  /* bit4 FbcĐ̏I */
#define CDC_HIRQ_DCHG   0x0020  /* bit5 FfBXN̔ */
#define CDC_HIRQ_ESEL   0x0040  /* bit6 FZN^ݒ菈̏I */
#define CDC_HIRQ_EHST   0x0080  /* bit7 FzXgo͏̏I */
#define CDC_HIRQ_ECPY   0x0100  /* bit8 Fʁ^ړ̏I */
#define CDC_HIRQ_EFLS   0x0200  /* bit9 Ft@CVXȅI */
#define CDC_HIRQ_SCDQ   0x0400  /* bit10FTuR[hṕvXV */
#define CDC_HIRQ_MPED   0x0800  /* bit11FMPEG֘ȀI */
#define CDC_HIRQ_MPCM   0x1000  /* bit12FMPEGsԂ̏I */
#define CDC_HIRQ_MPST   0x2000  /* bit13FMPEG荞݃Xe[^X̒ʒm */
    
/* obt@̃ZN^͈́iZN^ʒuƃZN^j̓w */
/* i16rbgLŁAIɂ0xffffƓlj */
#define CDC_SPOS_END    -1  /* Ō̃ZN^ʒu */
#define CDC_SNUM_END    -1  /* w辸ʒuŌ܂ł̾ */

/* ̑̓w */
#define CDC_PARA_DFL    0       /* p[^̏ȗlw */
#define CDC_PARA_NOCHG  -1      /* p[^̖ύXw */
#define CDC_NUL_SEL     0xff    /* ZN^ԍ̓l */
#define CDC_NUL_FID     -1      /* t@Cʎq̓l (0xffffff) */

/* bctO */
#define CDC_CDFLG_ROM   0x80    /* CD-ROMfR[h */

/* n[hEFAtOin[hEFAj */
#define CDC_HFLAG_MPEG  0x02    /* MPEG */
#define CDC_HFLAG_HERR  0x80    /* n[hEFAG[ */

/* Đ[hibcĐp[^j */
#define CDC_PM_DFL          0x00    /* Đ[h̏ȗl */
#define CDC_PM_REP_NOCHG    0x7f    /* ő僊s[g񐔂ύXȂ */
#define CDC_PM_PIC_NOCHG    0x80    /* sbNAbvʒuύXȂ */
#define CDC_PM_NOCHG        -1      /* Đ[hύXȂ (0xff) */

/* Tu[h */
#define CDC_SM_EOR      0x01    /* R[hŌ̃ZN^ */
#define CDC_SM_VIDEO    0x02    /* rfIZN^ */
#define CDC_SM_AUDIO    0x04    /* I[fBIZN^ */
#define CDC_SM_DATA     0x08    /* f[^ZN^ */
#define CDC_SM_TRIG     0x10    /* gKnm */
#define CDC_SM_FORM     0x20    /* tH[rbgi1:Form2,  0:Form1j*/
#define CDC_SM_RT       0x40    /* A^CZN^ */
#define CDC_SM_EOF      0x80    /* t@CŌ̃ZN^ */

/* t@CAgr[git@Cj */
#define CDC_ATR_DIRFG   0x02    /* fBNgł */
#define CDC_ATR_FORM1   0x08    /* Form1ZN^܂ */
#define CDC_ATR_FORM2   0x10    /* Form2ZN^܂ */
#define CDC_ATR_INTLV   0x20    /* C^[uZN^܂ */
#define CDC_ATR_CDDA    0x40    /* CD-DAt@C */
#define CDC_ATR_DIRXA   0x80    /* fBNgt@C */

/* X^oC^C */
#define CDC_STNBY_MIN   60      /* ŏl */
#define CDC_STNBY_MAX   900     /* ől */

/* TuR[htO */
#define CDC_SCD_PACK    0x01    /* pbNf[^G[ */
#define CDC_SCD_OVER    0x02    /* I[o[G[ */

/* bcubN̓][h */
#define CDC_DEND_ERR    0xffffff    /* f[^]ŃG[ */

/* f[^TCY */
#define CDC_ACTSIZ_ERR  0xffffff    /* vZsłȂ */

/* t[AhXʁiZN^ʒuƃt[AhXj */
#define CDC_SPOS_ERR    0xffff      /* ŃG[ */
#define CDC_FAD_ERR     0xffffff    /* słȂ */

/* }XNrbgp^[ */
#define CDC_STC_MSK     0x0f    /* Xe[^XR[h */

/*******************************************************************
*       񋓒萔
*******************************************************************/

/* G[R[h */
enum CdcErrCode {
    CDC_ERR_OK = OK,    /* ֐I */

    CDC_ERR_CMDBUSY=-1, /* R}hItOPɂȂĂȂ */
    CDC_ERR_CMDNG  =-2, /* R}hsACMOKtOPɂȂĂȂ */
    CDC_ERR_TMOUT  =-3, /* ^CAEgiڽݽ҂Aް]҂j*/
    CDC_ERR_PUT    =-4, /* ݏŋ󂫃ZN^mۂłȂ */
    CDC_ERR_REJECT =-5, /* R}hɑ΂郌X|XREJECTƂȂ */
    CDC_ERR_WAIT   =-6, /* R}hɑ΂郌X|XWAITƂȂ */
    CDC_ERR_TRNS   =-7, /* f[^]TCYُł */
    CDC_ERR_PERI   =-8  /* X|X擾łȂ */
};

/* Xe[^X */
enum CdcStatus {
    /* Xe[^XR[hibchCuԁj */
    CDC_ST_BUSY     = 0x00,     /* ԑJڒ */
    CDC_ST_PAUSE    = 0x01,     /* |[Yiꎞ~j */
    CDC_ST_STANDBY  = 0x02,     /* X^oCihCu~ԁj */
    CDC_ST_PLAY     = 0x03,     /* bcĐ */
    CDC_ST_SEEK     = 0x04,     /* V[N */
    CDC_ST_SCAN     = 0x05,     /* XLĐ */
    CDC_ST_OPEN     = 0x06,     /* gCJĂ */
    CDC_ST_NODISC   = 0x07,     /* fBXNȂ */
    CDC_ST_RETRY    = 0x08,     /* [hgC */
    CDC_ST_ERROR    = 0x09,     /* [hf[^G[ */
    CDC_ST_FATAL    = 0x0a,     /* vIG[ */

    /* ̑ */
    CDC_ST_PERI     = 0x20,     /* X|X */
    CDC_ST_TRNS     = 0x40,     /* f[^]v */
    CDC_ST_WAIT     = 0x80,     /* WAIT */
    CDC_ST_REJECT   = 0xff      /* REJECT */
};

/* ʒu^CviĐAV[Nɂbcʒup[^Ŏwj */
enum CdcPosType {
    CDC_PTYPE_DFL,          /* ȗl̎w */
    CDC_PTYPE_FAD,          /* t[AhXw */
    CDC_PTYPE_TNO,          /* gbN^CfbNXw */
    CDC_PTYPE_NOCHG,        /* ύX̎wiݒlύXȂj */

    CDC_PTYPE_END
};

/* ]҂^Cvif[^]̏҂Ŏwj */
enum CdcDrdyType {
    CDC_DRDY_GET,           /* f[^oiCDۯνāj */
    CDC_DRDY_PUT,           /* f[^ށiνāCDۯj */

    CDC_DRDY_END
};

/* XL */
enum CdcScanDir {
    CDC_SCAN_FWD = 0x00,    /* Đ */
    CDC_SCAN_RVS = 0x01     /* ߂Đ */
};

/* ZN^ */
enum CdcSctLen {
    CDC_SLEN_2048  = 0,     /* 2048oCg2324oCgi[Uf[^j*/
    CDC_SLEN_2336  = 1,     /* 2336oCgiTuwb_܂Łj*/
    CDC_SLEN_2340  = 2,     /* 2340oCgiwb_܂Łj*/
    CDC_SLEN_2352  = 3,     /* 2352oCgiZN^Śj*/
    CDC_SLEN_NOCHG = -1     /* ݒύXȂ (0xff) */
};

/* ʁ^ړG[ */
enum CdcCopyErr {
    CDC_COPY_OK   = 0,      /* I */
    CDC_COPY_NG   = 1,      /* G[ */
    CDC_COPY_BUSY = 0xff    /* ʁ^ړ */
};

/*******************************************************************
*       \̃ANZX}N
*******************************************************************/

/* bcXe[^X */
#define CDC_STAT_STATUS(stat)       ((stat)->status)
#define CDC_STAT_FLGREP(stat)       ((stat)->report.flgrep)
#define CDC_STAT_CTLADR(stat)       ((stat)->report.ctladr)
#define CDC_STAT_TNO(stat)          ((stat)->report.tno)
#define CDC_STAT_IDX(stat)          ((stat)->report.idx)
#define CDC_STAT_FAD(stat)          ((stat)->report.fad)

/* n[hEFA */
#define CDC_HW_HFLAG(hw)            ((hw)->hflag)
#define CDC_HW_VER(hw)              ((hw)->ver)
#define CDC_HW_MPVER(hw)            ((hw)->mpver)
#define CDC_HW_DRV(hw)              ((hw)->drv)
#define CDC_HW_REV(hw)              ((hw)->rev)

/* bcʒup[^ */
#define CDC_POS_PTYPE(pos)          ((pos)->ptype)
#define CDC_POS_FAD(pos)            ((pos)->pbody.fad)
#define CDC_POS_TNO(pos)            ((pos)->pbody.trkidx.tno)
#define CDC_POS_IDX(pos)            ((pos)->pbody.trkidx.idx)

/* bcĐp[^ */
#define CDC_PLY_START(ply)          ((ply)->start)
#define CDC_PLY_END(ply)            ((ply)->end)
#define CDC_PLY_PMODE(ply)          ((ply)->pmode)

#define CDC_PLY_STYPE(ply)          CDC_POS_PTYPE(&CDC_PLY_START(ply))
#define CDC_PLY_SFAD(ply)           CDC_POS_FAD(&CDC_PLY_START(ply))
#define CDC_PLY_STNO(ply)           CDC_POS_TNO(&CDC_PLY_START(ply))
#define CDC_PLY_SIDX(ply)           CDC_POS_IDX(&CDC_PLY_START(ply))

#define CDC_PLY_ETYPE(ply)          CDC_POS_PTYPE(&CDC_PLY_END(ply))
#define CDC_PLY_EFAS(ply)           CDC_POS_FAD(&CDC_PLY_END(ply))
#define CDC_PLY_ETNO(ply)           CDC_POS_TNO(&CDC_PLY_END(ply))
#define CDC_PLY_EIDX(ply)           CDC_POS_IDX(&CDC_PLY_END(ply))

/* Tuwb_ */
#define CDC_SUBH_FN(subh)           ((subh)->fn)
#define CDC_SUBH_CN(subh)           ((subh)->cn)
#define CDC_SUBH_SMMSK(subh)        ((subh)->smmsk)
#define CDC_SUBH_SMVAL(subh)        ((subh)->smval)
#define CDC_SUBH_CIMSK(subh)        ((subh)->cimsk)
#define CDC_SUBH_CIVAL(subh)        ((subh)->cival)

/* ZN^ */
#define CDC_SCT_FAD(sct)            ((sct)->fad)
#define CDC_SCT_FN(sct)             ((sct)->fn)
#define CDC_SCT_CN(sct)             ((sct)->cn)
#define CDC_SCT_SM(sct)             ((sct)->sm)
#define CDC_SCT_CI(sct)             ((sct)->ci)

/* t@C */
#define CDC_FILE_FAD(file)          ((file)->fad)
#define CDC_FILE_SIZE(file)         ((file)->size)
#define CDC_FILE_UNIT(file)         ((file)->unit)
#define CDC_FILE_GAP(file)          ((file)->gap)
#define CDC_FILE_FN(file)           ((file)->fn)
#define CDC_FILE_ATR(file)          ((file)->atr)

/*******************************************************************
*       }N
*******************************************************************/

/* bcXe[^X񂩂Xe[^XR[h擾 */
#define CDC_GET_STC(stat)       (CDC_STAT_STATUS(stat) & CDC_STC_MSK)

/* bcXe[^X񂩂烊s[g񐔂擾 */
#define CDC_GET_REPEAT(stat)    (CDC_STAT_FLGREP(stat) & 0x0f)

/* MPEGgp\ׂiTRUEFgp\AFALSEFgpsj */
/* ӁF̃}N̓}jAɋLqȂ */
#define CDC_IS_MPEG_ENA(hw)     (CDC_HW_MPVER(hw) != 0)

/*******************************************************************
*       f[^^̐錾
*******************************************************************/

/* bcXe[^XiXe[^X{bc|[gj */
typedef struct {
    Uint8   status;         /* Xe[^X */
    struct {                /* bc|[g */
        Uint8   flgrep;     /* bctOƃs[g */
        Uint8   ctladr;     /* CONTROL/ADRoCg */
        Uint8   tno;        /* gbNԍ */
        Uint8   idx;        /* CfbNXԍ */
        Sint32  fad;        /* t[AhX */
    } report;
} CdcStat;

/* n[hEFA */
typedef struct {
    Uint8   hflag;          /* n[hEFAtO */
    Uint8   ver;            /* bcubÑo[W */
    Uint8   mpver;          /* MPEG̃o[W */
    Uint8   drv;            /* bchCu */
    Uint8   rev;            /* bcubÑrW */
} CdcHw;

/* bcʒup[^ */
typedef struct {
    Sint32 ptype;           /* ʒu^Cviʒup[^̎ނ̎wj*/
    union {
        Sint32 fad;         /* t[AhXAZN^ */
        struct {
            Uint8 tno;      /* gbNԍ */
            Uint8 idx;      /* CfbNXԍ */
        } trkidx;
    } pbody;
} CdcPos;

/* bcĐp[^ */
typedef struct {
    CdcPos  start;          /* Jnʒu */
    CdcPos  end;            /* Iʒu */
    Uint8   pmode;          /* Đ[hi߯߈ړAJԂ񐔁j*/
} CdcPly;

/* Tuwb_ */
typedef struct {
    Uint8   fn;             /* t@Cԍ */
    Uint8   cn;             /* `lԍ */
    Uint8   smmsk;          /* Tu[h̃}XNp^[ */
    Uint8   smval;          /* Tu[h̔rl */
    Uint8   cimsk;          /* R[fBÕ}XNp^[ */
    Uint8   cival;          /* R[fBO̔rl */
} CdcSubh;

/* ZN^ */
typedef struct {
    Sint32  fad;            /* t[AhX */
    Uint8   fn;             /* t@Cԍ */
    Uint8   cn;             /* `lԍ */
    Uint8   sm;             /* Tu[h */
    Uint8   ci;             /* R[fBO */
} CdcSct;

/* t@C */
typedef struct {
    Sint32  fad;            /* t@C擪t[AhX */
    Sint32  size;           /* t@CTCYioCgj */
    Uint8   unit;           /* t@CjbgTCY */
    Uint8   gap;            /* MbvTCY */
    Uint8   fn;             /* t@Cԍ */
    Uint8   atr;            /* t@CAgr[g */
} CdcFile;

/*******************************************************************
*       ϐ錾
*******************************************************************/

/*******************************************************************
*       ֐錾
*******************************************************************/

/* cdc_cmn.c */
Sint32  CDC_GetCurStat(CdcStat *stat);
Sint32  CDC_GetLastStat(CdcStat *stat);
Sint32  CDC_GetHwInfo(CdcHw *hw);
Sint32  CDC_TgetToc(Uint32 *toc);
Sint32  CDC_GetSes(Sint32 sesno, Uint32 *ses);
Sint32  CDC_CdInit(Sint32 iflag, Sint32 stnby, Sint32 ecc, Sint32 retry);
Sint32  CDC_CdOpen(void);
Sint32  CDC_DataReady(Sint32 dtype);
Sint32  CDC_DataEnd(Sint32 *cdwnum);
Sint32  CDC_GetPeriStat(CdcStat *stat);

/* cdc_drv.c */
Sint32  CDC_CdPlay(CdcPly *ply);
Sint32  CDC_CdSeek(CdcPos *pos);
Sint32  CDC_CdScan(Sint32 scandir);

/* cdc_scd.c */
Sint32  CDC_TgetScdQch(Uint16 *qcode);
Sint32  CDC_TgetScdRwch(Uint16 *rwcode, Sint32 *scdflag);

/* cdc_dev.c */
Sint32  CDC_CdSetCon(Sint32 filtno);
Sint32  CDC_CdGetCon(Sint32 *filtno);
Sint32  CDC_CdGetLastBuf(Sint32 *bufno);

/* cdc_sel.c */
Sint32  CDC_SetFiltRange(Sint32 filtno, Sint32 fad, Sint32 fasnum);
Sint32  CDC_GetFiltRange(Sint32 filtno, Sint32 *fad, Sint32 *fasnum);
Sint32  CDC_SetFiltSubh(Sint32 filtno, CdcSubh *subh);
Sint32  CDC_GetFiltSubh(Sint32 filtno, CdcSubh *subh);
Sint32  CDC_SetFiltMode(Sint32 filtno, Sint32 fmode);
Sint32  CDC_GetFiltMode(Sint32 filtno, Sint32 *fmode);
Sint32  CDC_SetFiltCon(Sint32 filtno, Sint32 cflag, Sint32 bufno,
                       Sint32 flnout);
Sint32  CDC_GetFiltCon(Sint32 filtno, Sint32 *bufno, Sint32 *flnout);
Sint32  CDC_ResetSelector(Sint32 rflag, Sint32 bufno);

/* cdc_bif.c */
Sint32  CDC_GetBufSiz(Sint32 *totalsiz, Sint32 *bufnum, Sint32 *freesiz);
Sint32  CDC_GetSctNum(Sint32 bufno, Sint32 *snum);
Sint32  CDC_CalActSiz(Sint32 bufno, Sint32 spos, Sint32 snum);
Sint32  CDC_GetActSiz(Sint32 *actwnum);
Sint32  CDC_GetSctInfo(Sint32 bufno, Sint32 spos, CdcSct *sct);
Sint32  CDC_ExeFadSearch(Sint32 bufno, Sint32 spos, Sint32 fad);
Sint32  CDC_GetFadSearch(Sint32 *bufno, Sint32 *spos, Sint32 *fad);

/* cdc_bio.c */
Sint32  CDC_SetSctLen(Sint32 getslen, Sint32 putslen);
Sint32  CDC_GetSctData(Sint32 bufno, Sint32 spos, Sint32 snum);
Sint32  CDC_DelSctData(Sint32 bufno, Sint32 spos, Sint32 snum);
Sint32  CDC_GetdelSctData(Sint32 bufno, Sint32 spos, Sint32 snum);
Sint32  CDC_PutSctData(Sint32 filtno, Sint32 snum);
Sint32  CDC_CopySctData(Sint32 srcbn, Sint32 spos, Sint32 snum,
                        Sint32 dstfln);
Sint32  CDC_MoveSctData(Sint32 srcbn, Sint32 spos, Sint32 snum,
                        Sint32 dstfln);
Sint32  CDC_GetCopyErr(Sint32 *cpyerr);

/* cdc_cfs.c */
Sint32  CDC_ChgDir(Sint32 filtno, Sint32 fid);
Sint32  CDC_ReadDir(Sint32 filtno, Sint32 fid);
Sint32  CDC_GetFileScope(Sint32 *fid, Sint32 *infnum, Bool *drend);
Sint32  CDC_TgetFileInfo(Sint32 fid, CdcFile *file);
Sint32  CDC_ReadFile(Sint32 filtno, Sint32 fid, Sint32 offset);
Sint32  CDC_AbortFile(void);

/* cdc_reg.c */
Uint32  *CDC_GetDataPtr(void);
Sint32  CDC_GetHirqReq(void);
void    CDC_ClrHirqReq(Sint32 bitpat);
Sint32  CDC_GetHirqMsk(void);
void    CDC_SetHirqMsk(Sint32 bitpat);
Uint32  *CDC_GetMpegPtr(void);



/********************************************************************/
/********************************************************************/
/********************************************************************/
/*------------------------------------------------------------------*/
/*------------------------- sMPEGp[gt -------------------------*/
/*------------------------------------------------------------------*/
/********************************************************************/
/********************************************************************/
/********************************************************************/



/*******************************************************************
*       萔}N
*******************************************************************/

/* EBhETCYƍW̍ől */
#define CDC_MPNT_NSX    352           /* NTSCʏwTCY(352) */
#define CDC_MPNT_NSY    240           /* NTSCʏxTCY(240) */
#define CDC_MPNT_NPX (CDC_MPNT_NSX-1) /* NTSCʏwW  (351) */
#define CDC_MPNT_NPY (CDC_MPNT_NSY-1) /* NTSCʏxW  (239) */

#define CDC_MPNT_HSX (2*CDC_MPNT_NSX) /* NTSCׂwTCY(704) */
#define CDC_MPNT_HSY (2*CDC_MPNT_NSY) /* NTSCׂxTCY(480) */
#define CDC_MPNT_HPX (CDC_MPNT_HSX-1) /* NTSCׂwW  (703) */
#define CDC_MPNT_HPY (CDC_MPNT_HSY-1) /* NTSCׂxW  (479) */

#define CDC_MPPL_NSX    352           /* PAL ʏwTCY(352) */
#define CDC_MPPL_NSY    288           /* PAL ʏxTCY(288) */
#define CDC_MPPL_NPX (CDC_MPPL_NSX-1) /* PAL ʏwW  (351) */
#define CDC_MPPL_NPY (CDC_MPPL_NSY-1) /* PAL ʏxW  (287) */

#define CDC_MPPL_HSX (2*CDC_MPPL_NSX) /* PAL ׂwTCY(704) */
#define CDC_MPPL_HSY (2*CDC_MPPL_NSY) /* PAL ׂxTCY(576) */
#define CDC_MPPL_HPX (CDC_MPPL_HSX-1) /* PAL ׂwW  (703) */
#define CDC_MPPL_HPY (CDC_MPPL_HSY-1) /* PAL ׂxW  (575) */

/* MPEG/VideoԁiMPEGXe[^Xbit0`2j */
#define CDC_MPASTV_STOP     0x01    /* ~ */
#define CDC_MPASTV_PRE1     0x02    /* P */
#define CDC_MPASTV_PRE2     0x03    /* Q */
#define CDC_MPASTV_TRNS     0x04    /* ]iĐj */
#define CDC_MPASTV_CHG      0x05    /* ؂ւ */
#define CDC_MPASTV_RCV      0x06    /*  */

/* MPEGfR[hԁiMPEGXe[^Xbit3j */
#define CDC_MPASTD_STOP     0x08    /* MPEGfR[h~ */

/* MPEG/AudioԁiMPEGXe[^Xbit4`6j */
#define CDC_MPASTA_STOP     0x10    /* ~ */
#define CDC_MPASTA_PRE1     0x20    /* P */
#define CDC_MPASTA_PRE2     0x30    /* Q */
#define CDC_MPASTA_TRNS     0x40    /* ]iĐj */
#define CDC_MPASTA_CHG      0x50    /* ؂ւ */
#define CDC_MPASTA_RCV      0x60    /*  */

/* MPEG/AudioXe[^X */
#define CDC_MPSTA_DEC       0x01    /* I[fBIfR[htO */
#define CDC_MPSTA_ILG       0x08    /* I[fBIC[KtO */
#define CDC_MPSTA_BEMPTY    0x10    /* I[fBIpobt@tO */
#define CDC_MPSTA_ERR       0x20    /* I[fBIG[tO */
#define CDC_MPSTA_OUTL      0x40    /* `lo̓tO */
#define CDC_MPSTA_OUTR      0x80    /* E`lo̓tO */

/* MPEG/VideoXe[^X */
#define CDC_MPSTV_DEC       0x0001  /* rfIfR[htO */
#define CDC_MPSTV_DISP      0x0002  /* \tO */
#define CDC_MPSTV_PAUSE     0x0004  /* |[YtO */
#define CDC_MPSTV_FREEZE    0x0008  /* t[YtO */
#define CDC_MPSTV_LSTPIC    0x0010  /* ŌsN`\tO */
#define CDC_MPSTV_FIELD     0x0020  /* tB[htO */
#define CDC_MPSTV_UPDPIC    0x0040  /* sN`XVtO */
#define CDC_MPSTV_ERR       0x0080  /* rfIG[tO */
#define CDC_MPSTV_RDY       0x0100  /* o͏tO */
#define CDC_MPSTV_1STPIC    0x0800  /* 擪sN`\tO */
#define CDC_MPSTV_BEMPTY    0x1000  /* rfIpobt@tO */

/* MPEG荞ݗv */
#define CDC_MPINT_VSRDY  0x00000001 /* rfIXg[ */
#define CDC_MPINT_VSCHG  0x00000002 /* rfIXg[؂ւ */
#define CDC_MPINT_VORDY  0x00000004 /* rfIo͏ */
#define CDC_MPINT_VOSTRT 0x00000008 /* rfIo͊Jn */
#define CDC_MPINT_VDERR  0x00000010 /* rfIfR[hG[ */
#define CDC_MPINT_VSERR  0x00000020 /* rfIXg[f[^G[ */
#define CDC_MPINT_VBERR  0x00000040 /* rfIobt@ڑG[ */
#define CDC_MPINT_VNERR  0x00000080 /* ޵ذт̃f[^G[ */
#define CDC_MPINT_PSTRT  0x00000100 /* sN`X^[go */
#define CDC_MPINT_GSTRT  0x00000200 /* GOPX^[go */
#define CDC_MPINT_SQEND  0x00000400 /* V[PXGho */
#define CDC_MPINT_SQSTRT 0x00000800 /* V[PXX^[go */
#define CDC_MPINT_VTRG   0x00001000 /* rfIZN^̃gKrbgo */
#define CDC_MPINT_VEOR   0x00002000 /* rfIZN^EORrbgo */
#define CDC_MPINT_ATRG   0x00004000 /* I[fBIZN^ضޯČo */
#define CDC_MPINT_AEOR   0x00008000 /* I[fBIZN^EORrbgo */
#define CDC_MPINT_ASRDY  0x00010000 /* I[fBIXg[ */
#define CDC_MPINT_ASCHG  0x00020000 /* I[fBIXg[؂ւ */
#define CDC_MPINT_AORDY  0x00040000 /* I[fBIo͏ */
#define CDC_MPINT_AOSTRT 0x00080000 /* I[fBIo͊Jn */
#define CDC_MPINT_ADERR  0x00100000 /* I[fBIfR[hG[ */
#define CDC_MPINT_ASERR  0x00200000 /* I[fBIXg[f[^G[ */
#define CDC_MPINT_ABERR  0x00400000 /* I[fBIobt@ڑG[ */
#define CDC_MPINT_ANERR  0x00800000 /* ިذт̃f[^G[ */

/* ڑ[hiMPEGfR[_ڑp[^j */
#define CDC_MPCMOD_EOR      0x01    /* EORrbgŐ؂ւ */
#define CDC_MPCMOD_SEC      0x02    /* VXeGh(SEC)Ő؂ւ */
#define CDC_MPCMOD_DEL      0x04    /* ZN^̏ */
#define CDC_MPCMOD_IGPTS    0x08    /* PTSʂȂ */
#define CDC_MPCMOD_VCLR     0x10    /* VBṼNA */
#define CDC_MPCMOD_VWCLR    0x20    /* VBV+WBC̃NA */
#define CDC_MPCMOD_BEF      0x40    /* ȋOŏI */

/* CwiMPEGfR[_ڑp[^j */
#define CDC_MPLAY_SYS       0x00    /* VXeC */
#define CDC_MPLAY_AUDIO     0x01    /* I[fBIC */
#define CDC_MPLAY_VIDEO     0x01    /* rfIC */

/* MPEG/VideõsN`T[`wiMPEGfR[_ڑp[^j */
#define CDC_MPSRCH_OFF      0x00    /* sN`T[`Ȃ */
#define CDC_MPSRCH_VIDEO    0x80    /* sN`T[` */
#define CDC_MPSRCH_AV       0xc0    /* ߸ɍ킹ިްj */

/* Xg[[hiMPEGXg[p[^j */
#define CDC_MPSMOD_SNSET    0x01    /* Xg[ԍ̐ݒs */
#define CDC_MPSMOD_SNIDF    0x02    /* Xg[ԍʂ */
#define CDC_MPSMOD_CNSET    0x10    /* `lԍ̐ݒs */
#define CDC_MPSMOD_CNIDF    0x20    /* `lԍʂ */

/* ԃ[hiʓʃp[^j */
#define CDC_MPITP_YH        0x01    /* x̐Ԃ */
#define CDC_MPITP_CH        0x02    /* b̐Ԃ */
#define CDC_MPITP_YV        0x04    /* x̐Ԃ */
#define CDC_MPITP_CV        0x08    /* b̐Ԃ */

/* rbg[hiʓʃp[^j */
#define CDC_MPTRP_DFL       0x00    /* ʏirbgȂj */
#define CDC_MPTRP_64        0x01    /* Px64 */
#define CDC_MPTRP_128       0x02    /* Px128 */
#define CDC_MPTRP_256       0x03    /* Px256 */
#define CDC_MPTRP_MAG       0x04    /* ̈̊g */

/* ڂ[hiʓʃp[^j */
#define CDC_MPSOFT_ON       0x01    /* ڂ */

/* MPEG/Audiõ~[g */
#define CDC_MPMUT_DFL       0x04    /* ȗli~[gȂj */
#define CDC_MPMUT_R         0x01    /* E`l̃~[g */
#define CDC_MPMUT_L         0x02    /* `l̃~[g */

/*******************************************************************
*       񋓒萔
*******************************************************************/

/* G[R[h */
enum CdcMpErrCode {
    CDC_ERR_MP_COMU = -20   /* MPCMtOPɂȂĂȂ */
};

/* Xg[tOiXg[ƎXg[̎wj */
enum CdcMpStf {
    CDC_MPSTF_CUR  = 0,     /* ݂̐ڑ^Xg[̎wi攭j */
    CDC_MPSTF_NEXT = 1      /* @̐ڑ^Xg[̎wij */
};

/* sN`^CviʂRrbgLj */
enum CdcMpPict {
    CDC_MPPICT_I = 0x01,    /* hsN` */
    CDC_MPPICT_P = 0x02,    /* osN` */
    CDC_MPPICT_B = 0x03,    /* asN` */
    CDC_MPPICT_D = 0x04     /* csN` */
};

/* MPEG샂[h */
enum CdcMpAct {
    CDC_MPACT_NMOV = 0,     /* Đ[h */
    CDC_MPACT_NSTL = 1,     /* Î~Đ[h */
    CDC_MPACT_HMOV = 2,     /* ׂ̓Đ[hiΉj */
    CDC_MPACT_HSTL = 3,     /* ׂ̐Î~Đ[h */
    CDC_MPACT_SBUF = 4      /* MPEGZN^obt@[h */
};

/* fR[h^C~O */
enum CdcMpDec {
    CDC_MPDEC_VSYNC = 0,    /* VSYNCɂfR[h */
    CDC_MPDEC_HOST  = 1     /* zXgɂfR[h */
};

/* 摜f[^̏o͐ */
enum CdcMpOut {
    CDC_MPOUT_VDP2 = 0,     /* VDP2֏o */
    CDC_MPOUT_HOST = 1      /* zXg֏o */
};

/* MPEGĐ[h */
enum CdcMpPly {
    CDC_MPPLY_SYNC = 0,     /* Đ[h */
    CDC_MPPLY_INDP = 1      /* ƗĐ[h */
};

/* MPEGfR[_̓][h */
enum CdcMpTrn {
    CDC_MPTRN_AUTO  = 0,    /* ][h */
    CDC_MPTRN_FORCE = 1     /* ][h */
};

/* MPEGfR[_̐ڑ؂ւtO */
enum CdcMpCof {
    CDC_MPCOF_ABT = 0,      /* ؂藣iIj */
    CDC_MPCOF_CHG = 1       /* ؂ւ */
};

/* MPEG/AudiõNA */
enum CdcMpCla {
    CDC_MPCLA_OFF = 0,      /* NAȂ */
    CDC_MPCLA_ON  = 1       /* ɂPZN^̃obt@NA */
};

/* MPEG/VideõNA */
enum CdcMpClv {
    CDC_MPCLV_FRM = 0,      /* VBVMPEGڰޯ̧NA */
    CDC_MPCLV_VBV = 2       /* I܂P߸ĂVBVNA */
};

/*******************************************************************
*       \̃ANZX}N
*******************************************************************/

/* MPEGXe[^X */
#define CDC_MPSTAT_STS(mpstat)      ((mpstat)->status)
#define CDC_MPSTAT_AST(mpstat)      ((mpstat)->report.actst)
#define CDC_MPSTAT_PICT(mpstat)     ((mpstat)->report.pict)
#define CDC_MPSTAT_STA(mpstat)      ((mpstat)->report.stat_a)
#define CDC_MPSTAT_STV(mpstat)      ((mpstat)->report.stat_v)
#define CDC_MPSTAT_VCNT(mpstat)     ((mpstat)->report.vcnt)

/* ^CR[h */
#define CDC_MPTC_HOUR(mptc)         ((mptc)->hour)
#define CDC_MPTC_MIN(mptc)          ((mptc)->min)
#define CDC_MPTC_SEC(mptc)          ((mptc)->sec)
#define CDC_MPTC_PIC(mptc)          ((mptc)->pic)

/* MPEGfR[_ڑp[^ */
#define CDC_MPCON_CMOD(mpcon)       ((mpcon)->cmod)
#define CDC_MPCON_LAY(mpcon)        ((mpcon)->lay)
#define CDC_MPCON_BN(mpcon)         ((mpcon)->bn)

/* MPEGXg[p[^ */
#define CDC_MPSTM_SMOD(mpstm)       ((mpstm)->smod)
#define CDC_MPSTM_ID(mpstm)         ((mpstm)->id)
#define CDC_MPSTM_CN(mpstm)         ((mpstm)->cn)

/* ʓʃp[^ */
#define CDC_MPVEF_ITP(mpvef)        ((mpvef)->itp)
#define CDC_MPVEF_TRP(mpvef)        ((mpvef)->trp)
#define CDC_MPVEF_MOZH(mpvef)       ((mpvef)->moz_h)
#define CDC_MPVEF_MOZV(mpvef)       ((mpvef)->moz_v)
#define CDC_MPVEF_SOFTH(mpvef)      ((mpvef)->soft_h)
#define CDC_MPVEF_SOFTV(mpvef)      ((mpvef)->soft_v)

/*******************************************************************
*       }N
*******************************************************************/

/* MPEGXe[^X񂩂Xe[^XR[h擾 */
#define CDC_MPGET_STC(mpstat)   (CDC_MPSTAT_STS(mpstat) & CDC_STC_MSK)

/* MPEGXe[^X񂩂MPEG/VideoԂ擾 */
#define CDC_MPGET_ASTV(mpstat)   (CDC_MPSTAT_AST(mpstat) & 0x07)

/* MPEGXe[^X񂩂MPEG/AudioԂ擾 */
#define CDC_MPGET_ASTA(mpstat)   (CDC_MPSTAT_AST(mpstat) & 0x70)

/*******************************************************************
*       f[^^̐錾
*******************************************************************/

/* MPEGXe[^XiXe[^X{MPEG|[gj */
typedef struct {
    Uint8   status;         /* Xe[^X */
    struct {                /* MPEG|[g */
        Uint8   actst;      /* MPEGXe[^X */
        Uint8   pict;       /* sN` */
        Uint8   stat_a;     /* MPEG/AudioXe[^X */
        Uint16  stat_v;     /* MPEG/VideoXe[^X */
        Uint16  vcnt;       /* ԁiVSYNCjJE^ */
    } report;
} CdcMpStat;

/* ^CR[h */
typedef struct {
    Uint8   hour;           /*  */
    Uint8   min;            /*  */
    Uint8   sec;            /* b */
    Uint8   pic;            /* sN` */
} CdcMpTc;

/* MPEGfR[_ڑp[^ */
typedef struct {
    Uint8   cmod;           /* ڑ[h */
    Uint8   lay;            /* CwƃsN`T[`w */
    Uint8   bn;             /* obt@ԍ */
} CdcMpCon;

/* MPEGXg[p[^ */
typedef struct {
    Uint8   smod;           /* Xg[[h */
    Uint8   id;             /* Xg[ԍ */
    Uint8   cn;             /* `lԍ */
} CdcMpStm;

/* ʓʃp[^ */
typedef struct {
    Uint8   itp;            /* ԃ[h */
    Uint8   trp;            /* rbg[h */
    Uint8   moz_h;          /* UCN[h */
    Uint8   moz_v;          /* UCN[h */
    Uint8   soft_h;         /* ڂ[h */
    Uint8   soft_v;         /* ڂ[h */
} CdcMpVef;

/*******************************************************************
*       ϐ錾
*******************************************************************/

/*******************************************************************
*       ֐錾
*******************************************************************/

/* cdc_mdc.c */
Sint32  CDC_MpGetCurStat(CdcMpStat *mpstat);
Sint32  CDC_MpGetLastStat(CdcMpStat *mpstat);
Sint32  CDC_MpGetInt(Sint32 *intreq);
Sint32  CDC_MpSetIntMsk(Sint32 intmsk);
Sint32  CDC_MpInit(Bool sw);
Sint32  CDC_MpSetMode(Sint32 actmod, Sint32 dectim, Sint32 out,
                      Sint32 scnmod);
Sint32  CDC_MpPlay(Sint32 plymod, Sint32 tmod_a, Sint32 tmod_v,
                   Sint32 dec_v);
Sint32  CDC_MpSetDec(Sint32 mute, Sint32 pautim, Sint32 frztim);
Sint32  CDC_MpOutDsync(Sint32 fbn);
Sint32  CDC_MpGetTc(Sint32 *bnk, Sint32 *pictyp, Sint32 *tr, CdcMpTc *mptc);
Sint32  CDC_MpGetPts(Sint32 *pts_a);

/* cdc_mst.c */
Sint32  CDC_MpSetCon(Sint32 next, CdcMpCon *mpcon_a, CdcMpCon *mpcon_v);
Sint32  CDC_MpGetCon(Sint32 next, CdcMpCon *mpcon_a, CdcMpCon *mpcon_v);
Sint32  CDC_MpChgCon(Sint32 chg_a, Sint32 chg_v,
                     Sint32 clr_a, Sint32 clr_v);
Sint32  CDC_MpSetStm(Sint32 next, CdcMpStm *mpstm_a, CdcMpStm *mpstm_v);
Sint32  CDC_MpGetStm(Sint32 next, CdcMpStm *mpstm_a, CdcMpStm *mpstm_v);
Sint32  CDC_MpGetPictSiz(Sint32 *siz_h, Sint32 *siz_v);

/* cdc_mwn.c */
Sint32  CDC_MpDisp(Bool dspsw, Sint32 fbn);
Sint32  CDC_MpSetWinFpos(Bool chgflg, Sint32 fpx, Sint32 fpy);
Sint32  CDC_MpSetWinFrat(Bool chgflg, Sint32 frx, Sint32 fry);
Sint32  CDC_MpSetWinDpos(Bool chgflg, Sint32 dpx, Sint32 dpy);
Sint32  CDC_MpSetWinDsiz(Bool chgflg, Sint32 dsx, Sint32 dsy);
Sint32  CDC_MpSetWinDofs(Bool chgflg, Sint32 dox, Sint32 doy);
Sint32  CDC_MpSetBcolor(Sint32 bcolor);
Sint32  CDC_MpSetFade(Sint32 gain_y, Sint32 gain_c);
Sint32  CDC_MpSetVeff(CdcMpVef *mpvef);

/* cdc_mfb.c */
Sint32  CDC_MpGetImg(Sint32 *dwnum);
Sint32  CDC_MpSetImgPos(Sint32 fbn, Sint32 ipx, Sint32 ipy);
Sint32  CDC_MpSetImgSiz(Sint32 fbn, Sint32 isx, Sint32 isy);
Sint32  CDC_MpReadImg(Sint32 srcfbn,
                      Sint32 fln_y, Sint32 fln_cr, Sint32 fln_cb);
Sint32  CDC_MpWriteImg(Sint32 bn_y, Sint32 bn_cr, Sint32 bn_cb,
                       Sint32 dstfbn, Sint32 clrmod);

/* cdc_mbu.c */
Sint32  CDC_MpReadSct(Sint32 srcmsp, Sint32 snum, Sint32 dstfln);
Sint32  CDC_MpWriteSct(Sint32 srcbn, Sint32 sp, Sint32 snum,
                       Sint32 dstmsp);

/* cdc_mls.c */
/* ӁFȉ̊֐͔JƂ */
Sint32  CDC_MpGetLsi(Sint32 r_sw, Sint32 reg_no, Sint32 *rdata);
Sint32  CDC_MpSetLsi(Sint32 rwsw, Sint32 reg_no, Sint32 wdata,
                     Sint32 *rdata);

/* cdc_unk.c */
/* Undocumented and aside from the bios, used functions */
Sint32 CDC_E0(unsigned char R4, unsigned char R5);
Sint32 CDC_E1(unsigned char R4, unsigned short *R5, unsigned short *R6);
Sint32 CDC_E2(unsigned char R4, unsigned long R5, unsigned short R6);

#endif  /* ifndef SEGA_CDC_H */
