#include	"sgl.h"
#include	"sgl_cd.h"
#include        "sega_cdc.h"
#include        "cd.h"

/****************************************************************************/
Sint32	dirwork[SLCD_WORK_SIZE(MAX_FILE)];
Sint8  readbuf[ READSECT * CDBUF_FORM1 / sizeof(Sint8)];
Sint8  readbuf2[ READSECT2 * CDBUF_FORM1 / sizeof(Sint8)];

/****************************************************************************/
void  LoadCDFile(Sint8 *filename, Sint8 *rbuf, Sint16 readsect)
{
    CDHN	cdhn;
    CDKEY	key[2];
    CDBUF	buf[2];
    Sint32	stat;
    Sint32	len[2];
    Sint32	ypos = 1;

//    slPrint("slCdInit:", slLocate(1,ypos));
//    slPrintFX(toFIXED(ndir), slLocate(11, ypos));
    ypos++;

    key[0].cn = key[0].sm = key[0].ci = CDKEY_NONE;
    key[1].cn = CDKEY_TERM;	
    cdhn = slCdOpen(filename, key);

    if (cdhn == NULL)
    {
       slPrint("slCdOpen: Error", slLocate(1, ypos));
    }
//    else
//    {
//       slPrint("slCdOpen:", slLocate(1, ypos));
//       slDispHex((Uint32)cdhn, slLocate(11, ypos));
//    }

    buf[0].type = CDBUF_COPY;	
    buf[0].trans.copy.addr = rbuf; 
    buf[0].trans.copy.unit = CDBUF_FORM1;
    buf[0].trans.copy.size = readsect; 
    buf[1].type = CDBUF_TERM;
    slCdLoadFile(cdhn, buf);		
    ypos++;

    while (1)
    {
	slSynch();     			
	stat = slCdGetStatus(cdhn, len);
//        slPrint("stat:", slLocate(1, ypos));
//        slPrint("loaded:", slLocate(16, ypos));
//        slDispHex((Uint32)len, slLocate(24, ypos));
//        slDispHex((Uint32)stat, slLocate(7, ypos));

        switch (stat)
        {
           case CDSTAT_PAUSE:
           {
//              slPrint("PAUSE    ", slLocate(7, ypos));
              break;
           }
           case CDSTAT_DOING:
           {
//              slPrint("DOING    ", slLocate(7, ypos));
              break;
           }
           case CDSTAT_WAIT:
           {
//              slPrint("WAIT     ", slLocate(7, ypos));
              break;
           }
           default: break;
        }

	if (stat == CDSTAT_COMPLETED)
        {
//           slPrint("stat:", slLocate(1, ypos));
//           slPrint("COMPLETED", slLocate(7, ypos));
           break;
        }
    }
}

/****************************************************************************/

#define SYS_CDINIT1(i) \
        ((**(void(**)(int))0x60002dc)(i))

#define SYS_CDINIT2() \
        ((**(void(**)(void))0x600029c)())

int CdUnlock (void)
{
	Sint32 ret;
	CdcStat stat;
	volatile int delay;

	SYS_CDINIT1(3);

	SYS_CDINIT2();

	do
	{
                for(delay = 100000; delay; delay--);

		ret = CDC_GetCurStat(&stat);

	} while ((ret != 0) || (CDC_STAT_STATUS(&stat) == 0xff));

	return (int) CDC_STAT_STATUS(&stat);
}

