/*							*/
/*  Langrisser III Music Player                         */
/*  -based off Sega's code                              */
/*  -Written by Cyber Warrior X                         */
/*							*/

#include    "sddrvs.dat"
#include    "sgl_cd.h"
#include    "cd.h"

/*------------------------------------------------------------------------*/

#define     sound_mem         0x25a0b000

extern char sound_map[];
extern Uint32 mapsize;
extern PDATA PD_Cube ;

/*------------------------------------------------------------------------*/

#define		_Play		0x01
#define		_Pause		0x02
#define		_Fade		0x04

typedef struct{
    struct{
	Sint8	stat ;
	Sint16	tmp ;
	Sint8	pan ;
    }seq[8] ;
    Uint8 vol ;
    Uint8 banknum ;
    Uint8 songnum ;
    Uint8 sequence ;
} SOUND_MAN ;

int curr_song=0;

/*------------------------------------------------------------------------*/

void init_sound()
{
    Sint32 delay;
    Uint32 offset=0;
    Uint32 seq_size=0;
    
    slInitSound(sddrvstsk , sizeof(sddrvstsk) , (Uint8 *)sound_map , mapsize) ;

    LoadCDFile("LANG\\MUSIC\\SND03.DAT", readbuf, READSECT);

    // Calculate the SEQ offset and size
    offset = (readbuf[(curr_song * 8) + 4] << 24) +
             (readbuf[(curr_song * 8) + 5] << 16) +
             (readbuf[(curr_song * 8) + 6] << 8) + 
             readbuf[(curr_song * 8) + 7];
    offset *= 0x800;

    seq_size = (readbuf[(curr_song * 8) + 8] << 24) +
               (readbuf[(curr_song * 8) + 9] << 16) +
               (readbuf[(curr_song * 8) + 10] << 8) + 
               readbuf[(curr_song * 8) + 11];

    // copy over SEQ data
    slDMACopy(readbuf + offset, (void *)(sound_mem), seq_size);
    slDMAWait();

    // copy over TONE data
    LoadCDFile("LANG\\MUSIC\\SND02.DAT", readbuf2, READSECT2);
    slDMACopy(readbuf2, (void *)(sound_mem) + 0x3554, 0x51472);
    slDMAWait();

}

void disp_vol(Uint16 vol)
{
    slSndVolume(vol);
    slPrint("Volume : " , slLocate(2,6)) ;
    slPrintHex(vol , slLocate(11,6)) ;
}

sound_test(EVENT *evptr)
{
    SOUND_MAN   *smptr;
    PerDigital  *pptr;
    Sint16      padd;
    Sint16      padp;
    Uint32 offset=0;
    Uint32 seq_size=0;

    Sint16 i;
    
    const Uint8 bank = 3 ;
    const Uint8 song[] = {1 , 7 , 0 , 1} ;
    
    smptr = (SOUND_MAN *)evptr->user ;
    pptr = Smpc_Peripheral;
    padd = ~pptr->data;
    padp = ~pptr->push;
    
    if(smptr->seq[0].stat && !(slSequenceStat(i)))
    {
       smptr->seq[0].stat = 0;
    }

    switch(smptr->seq[0].stat)
    {
       case 0 : slPrint(" Stopped", slLocate(17,26)) ; break ;
       case 1 : slPrint("  Play  ", slLocate(17,26)) ; break ;
       case 3 : slPrint("  Pause ", slLocate(17,26)) ; break ;
       case 5 : slPrint("Fade Out", slLocate(17,26)) ; break ;
       case 7 : slPrint("  Pause ", slLocate(17,26)) ; break ;
    }

    if(padp & PER_DGT_KU)
    {
       if(smptr->vol < 127)
       {
          disp_vol(++smptr->vol);
       }
    }
    else if(padp & PER_DGT_KD)
    {
       if(smptr->vol > 0)
       {
          disp_vol(--smptr->vol);
       }
    }
 
    slPrintHex(slHex2Dec(curr_song) , slLocate(6,10)) ;
    slPrint("Song: " , slLocate(2,10)) ;

    if(padp & PER_DGT_TA)
    {
	if(smptr->seq[0].stat & _Play)
        {
	    slBGMOff() ;
	    smptr->seq[0].stat = 0 ;

	    slBGMOn((smptr->banknum << 8) + smptr->songnum,0,127,0) ;
	    smptr->seq[0].stat |= _Play ;
	}
        else
        {
	    slBGMOn((smptr->banknum << 8) + smptr->songnum,0,127,0) ;
	    smptr->seq[0].stat |= _Play ;
	}
    }
    if(smptr->seq[0].stat & _Play)
    {
        if(padp & PER_DGT_TB)
        {
	    if(smptr->seq[0].stat & _Pause){
		slBGMCont() ;
		smptr->seq[0].stat &= ~(_Pause) ;
	    } else {
		slBGMPause() ;
		smptr->seq[0].stat |= _Pause ;
	    }
	}
        else if(padp & PER_DGT_TX)
        {
	    slBGMOff() ;
	    smptr->seq[0].stat = 0 ;
        }

	if(!(smptr->seq[0].stat & _Pause))
        {
            if(padp & PER_DGT_TC)
            {
		if(smptr->seq[0].stat & _Fade)
                {
		    smptr->seq[0].stat &= ~(_Fade) ;
		    slBGMFade(127 , 25) ; /* Fade In */
		}
                else
                {
		    smptr->seq[0].stat |= _Fade ;
		    slBGMFade(1 , 25) ;	/* Fade Out */
		}
	    }
	}
    }

    if(padp & PER_DGT_KR)
    {
       slBGMOff() ;
       smptr->seq[0].stat = 0 ;

       if (curr_song < 26)
       {
          curr_song++;
       }

       offset = (readbuf[(curr_song * 8) + 4] << 24) +
                (readbuf[(curr_song * 8) + 5] << 16) +
                (readbuf[(curr_song * 8) + 6] << 8) + 
                 readbuf[(curr_song * 8) + 7];
       offset *= 0x800;

       seq_size = (readbuf[(curr_song * 8) + 8] << 24) +
                  (readbuf[(curr_song * 8) + 9] << 16) +
                  (readbuf[(curr_song * 8) + 10] << 8) + 
                   readbuf[(curr_song * 8) + 11];

       // zero out memory area (where seq is copied to)

       for (i = 0; i < 0x3554; i++)
       {
          *((unsigned char *)(sound_mem + i)) = 0;
       }

       // SEQ data
       slDMACopy(readbuf + offset, (void *)(sound_mem), seq_size);
       slDMAWait();
    }
    else if(padp & PER_DGT_KL)
    {
       slBGMOff() ;
       smptr->seq[0].stat = 0 ;

       if (curr_song > 0)
       {
          curr_song--;
       }

       offset = (readbuf[(curr_song * 8) + 4] << 24) +
                (readbuf[(curr_song * 8) + 5] << 16) +
                (readbuf[(curr_song * 8) + 6] << 8) + 
                 readbuf[(curr_song * 8) + 7];
       offset *= 0x800;

       seq_size = (readbuf[(curr_song * 8) + 8] << 24) +
                  (readbuf[(curr_song * 8) + 9] << 16) +
                  (readbuf[(curr_song * 8) + 10] << 8) + 
                   readbuf[(curr_song * 8) + 11];

       // zero out memory area (where seq is copied to)

       for (i = 0; i < 0x3554; i++)
       {
          *((unsigned char *)(sound_mem + i)) = 0;
       }

       // SEQ data
       slDMACopy(readbuf + offset, (void *)(sound_mem), seq_size);
       slDMAWait();
    }

}

void init_sound_test(EVENT *evptr)
{
    SOUND_MAN	*smptr ;
    int i ;

    evptr->exad = (void *)sound_test ;
    smptr = (SOUND_MAN *)evptr->user ;
    smptr->vol = 127;
    smptr->sequence = 1 ;
    smptr->banknum = 0 ;
    smptr->songnum = 0 ;

    disp_vol(smptr->vol) ;
}

/*------------------------------------------------------------------------*/

typedef struct{
    ANGLE	angy ;
} CUBE_MAN ;

void disp_cube(EVENT *evptr)
{
    CUBE_MAN	*cbptr ;

    cbptr = (CUBE_MAN *)evptr->user ;
    slPushUnitMatrix() ;
    {
	slTranslate(toFIXED(0) , toFIXED(0) , toFIXED(500)) ;
	slRotY(cbptr->angy) ;
	cbptr->angy += 0x0100 ;
	slPutPolygon(&PD_Cube) ;
    }
    slPopMatrix() ;
}

/*------------------------------------------------------------------------*/

sample()
{
    init_sound() ;
    slInitEvent() ;
    slSetEvent((void *)init_sound_test) ;
    slSetEvent((void *)disp_cube) ;

    slScrAutoDisp(NBG0ON) ;
    slPrint("Langrisser III Music Player" , slLocate(8,1)) ;
    while(-1){
	slExecuteEvent() ;
	slSynch() ;
    }
}
/*-----------------------------------------------------------------------*/

void ss_main(void)
{
    Sint32	ndir;
    slInitSystem(TV_352x224,NULL,1) ;
    CdUnlock();
    ndir = slCdInit(MAX_FILE, dirwork);
    sample() ;
}

/*-----------------------------------------------------------------------*/
