/*							*/
/*  Sakura Taisen Music Player                          */
/*  -based off Sega's code                              */
/*  -Written by Cyber Warrior X                         */
/*							*/

#include    "sddrvs.bin"
#include    "sgl_cd.h"
#include    "cd.h"

/*------------------------------------------------------------------------*/

#define     SoundSeqBuf		0x25a0b000

extern char sound_map[];
extern Uint32 mapsize;
extern PDATA PD_Cube ;

/*------------------------------------------------------------------------*/

#define		_Play		0x01
#define		_Pause		0x02
#define		_Fade		0x04

typedef struct{
    struct{
	Sint8	stat ;
	Sint16	tmp ;
	Sint8	pan ;
    }seq[8] ;
    Uint8 vol ;
    Uint8 banknum ;
    Uint8 songnum ;
    Uint8 sequence ;
} SOUND_MAN ;

#define MAX_SONG        34

char filelist[MAX_SONG][21] =
{
"SAKURA2\\ADVBGM01.ALL",
"SAKURA2\\ADVBGM02.ALL",
"SAKURA2\\ADVBGM03.ALL",
"SAKURA2\\ADVBGM04.ALL",
"SAKURA2\\ADVBGM05.ALL",
"SAKURA2\\ADVBGM06.ALL",
"SAKURA2\\ADVBGM07.ALL",
"SAKURA2\\ADVBGM08.ALL",
"SAKURA2\\ADVBGM09.ALL",
"SAKURA2\\ADVBGM10.ALL",
"SAKURA2\\ADVBGM12.ALL",
"SAKURA2\\ADVBGM13.ALL",
"SAKURA2\\ADVBGM14.ALL",
"SAKURA2\\ADVBGM16.ALL",
"SAKURA2\\ADVBGM17.ALL",
"SAKURA2\\ADVBGM18.ALL",
"SAKURA2\\ADVBGM19.ALL",
"SAKURA2\\ADVBGM22.ALL",
"SAKURA2\\ADVBGM23.ALL",
"SAKURA2\\ADVBGM24.ALL",
"SAKURA2\\ADVBGM25.ALL",
"SAKURA2\\ADVBGM26.ALL",
"SAKURA2\\ADVBGM27.ALL",
"SAKURA2\\ADVBGM28.ALL",
"SAKURA2\\ADVBGM29.ALL",
"SAKURA2\\ADVBGM30.ALL",
"SAKURA2\\MAIGBGM.ALL",
//"SAKURA2\\SLGBGM15.ALL",
"SAKURA1\\COOKBGM",
"SAKURA1\\HANABGM",
"SAKURA1\\SHOTBGM",
"SAKURA1\\SLOTBGM",
"SAKURA1\\SOJIBGM",
"SAKURA1\\SWIMBGM"
};

char curr_file=0;

/*------------------------------------------------------------------------*/

void init_sound()
{
    slInitSound(sddrvstsk , sizeof(sddrvstsk) , (Uint8 *)sound_map , mapsize) ;

    // Copy over the DSP program
    slDMACopy(readbuf, (void *)(SoundSeqBuf + 0x2900), 0x700);
    // Copy over TONE data
    slDMACopy(readbuf + 0x8740, (void *)(SoundSeqBuf + 0xB040), 0x38000);
    // last copy over SEQ data
    slDMACopy(readbuf + 0x40740, (void *)(SoundSeqBuf + 0x43040), 0x52FE);
}

void disp_vol(Uint16 vol)
{
    slSndVolume(vol << 3) ;
    slPrint("Volume : " , slLocate(2,6)) ;
    slPrintHex(vol , slLocate(11,6)) ;
}

sound_test(EVENT *evptr)
{
    SOUND_MAN	*smptr ;
    PerDigital	*pptr ;
    Sint16	padd ;
    Sint16	padp ;

    int i ;
    
    const Uint8 bank = 3;
    const Uint8 song[] = {1 , 7 , 0 , 1} ;
    
    smptr = (SOUND_MAN *)evptr->user ;
    pptr = Smpc_Peripheral;
    padd = ~pptr->data;
    padp = ~pptr->push;

    if(smptr->seq[0].stat && !(slSequenceStat(i)))
    {
       smptr->seq[0].stat = 0;
    }

    switch(smptr->seq[0].stat)
    {
       case 0 : slPrint(" Stopped", slLocate(17,26)) ; break ;
       case 1 : slPrint("  Play  ", slLocate(17,26)) ; break ;
       case 3 : slPrint("  Pause ", slLocate(17,26)) ; break ;
       case 5 : slPrint("Fade Out", slLocate(17,26)) ; break ;
       case 7 : slPrint("  Pause ", slLocate(17,26)) ; break ;
    }

    if(padp & PER_DGT_KU)
    {
       if(smptr->vol < 15)
       {
          disp_vol(++smptr->vol);
       }
    }
    else if(padp & PER_DGT_KD)
    {
       if(smptr->vol > 0)
       {
          disp_vol(--smptr->vol) ;
       }
    }

    if(padp & PER_DGT_KL)
    {
       if (curr_file > 0)
       {
          slBGMOff() ;
          smptr->seq[0].stat = 0 ;

          curr_file--;

          LoadCDFile(filelist[curr_file]);

          // Copy over the DSP program
          slDMACopy(readbuf, (void *)(SoundSeqBuf + 0x2900), 0x700);
          slDMAWait();
          // Copy over TONE data
          slDMACopy(readbuf + 0x8740, (void *)(SoundSeqBuf + 0xB040), 0x38000);
          slDMAWait();
          // last copy over SEQ data
          slDMACopy(readbuf + 0x40740, (void *)(SoundSeqBuf + 0x43040), 0x52FE);
          slDMAWait();

          slBGMOn((smptr->banknum << 8) + smptr->songnum,0,127,0) ;
          smptr->seq[0].stat |= _Play ;
       }
    }
    else if(padp & PER_DGT_KR)
    {
       if (curr_file < (MAXSONG - 1))
       {
          slBGMOff() ;
          smptr->seq[0].stat = 0 ;

          curr_file++;

          LoadCDFile(filelist[curr_file]);

          // Copy over the DSP program
          slDMACopy(readbuf, (void *)(SoundSeqBuf + 0x2900), 0x700);
          slDMAWait();
          // Copy over TONE data
          slDMACopy(readbuf + 0x8740, (void *)(SoundSeqBuf + 0xB040), 0x38000);
          slDMAWait();
          // last copy over SEQ data
          slDMACopy(readbuf + 0x40740, (void *)(SoundSeqBuf + 0x43040), 0x52FE);
          slDMAWait();
   
          slBGMOn((smptr->banknum << 8) + smptr->songnum,0,127,0) ;
          smptr->seq[0].stat |= _Play ;
       }
    }

    slPrint(filelist[curr_file], slLocate(2,11)) ;
    slPrint("File: " , slLocate(2,10)) ;

    if(padp & PER_DGT_TA)
    {
	if(smptr->seq[0].stat & _Play)
        {
	    slBGMOff() ;
	    smptr->seq[0].stat = 0 ;

	    slBGMOn((smptr->banknum << 8) + smptr->songnum,0,127,0) ;
	    smptr->seq[0].stat |= _Play ;
	}
        else
        {
	    slBGMOn((smptr->banknum << 8) + smptr->songnum,0,127,0) ;
	    smptr->seq[0].stat |= _Play ;
	}
    }
    if(smptr->seq[0].stat & _Play)
    {
        if(padp & PER_DGT_TB)
        {
	    if(smptr->seq[0].stat & _Pause){
		slBGMCont() ;
		smptr->seq[0].stat &= ~(_Pause) ;
	    } else {
		slBGMPause() ;
		smptr->seq[0].stat |= _Pause ;
	    }
	}
        else if(padp & PER_DGT_TX)
        {
	    slBGMOff() ;
	    smptr->seq[0].stat = 0 ;
        }

	if(!(smptr->seq[0].stat & _Pause))
        {
            if(padp & PER_DGT_TC)
            {
		if(smptr->seq[0].stat & _Fade)
                {
		    smptr->seq[0].stat &= ~(_Fade) ;
		    slBGMFade(127 , 25) ; /* Fade In */
		}
                else
                {
		    smptr->seq[0].stat |= _Fade ;
		    slBGMFade(1 , 25) ;	/* Fade Out */
		}
	    }
	}
    }


}

void init_sound_test(EVENT *evptr)
{
    SOUND_MAN	*smptr ;
    int i ;

    evptr->exad = (void *)sound_test ;
    smptr = (SOUND_MAN *)evptr->user ;
    smptr->vol = 15 ;
    smptr->sequence = 1;
    smptr->banknum = 1;
    smptr->songnum = 0;

    disp_vol(smptr->vol) ;
}

/*------------------------------------------------------------------------*/

typedef struct{
    ANGLE	angy ;
} CUBE_MAN ;

void disp_cube(EVENT *evptr)
{
    CUBE_MAN	*cbptr ;

    cbptr = (CUBE_MAN *)evptr->user ;
    slPushUnitMatrix() ;
    {
	slTranslate(toFIXED(0) , toFIXED(0) , toFIXED(500)) ;
	slRotY(cbptr->angy) ;
	cbptr->angy += 0x0100 ;
	slPutPolygon(&PD_Cube) ;
    }
    slPopMatrix() ;
}

/*------------------------------------------------------------------------*/

sample()
{
    init_sound();
    slInitEvent();
    slSetEvent((void *)init_sound_test);
    slSetEvent((void *)disp_cube);

    slScrAutoDisp(NBG0ON) ;
    slPrint("Sakura Taisen Music Player" , slLocate(8,1)) ;
    while(-1){
	slExecuteEvent() ;
	slSynch() ;
    }
}
/*-----------------------------------------------------------------------*/

void ss_main(void)
{
    Sint32	ndir;
    slInitSystem(TV_352x224,NULL,1);

    CdUnlock ();
    ndir = slCdInit(MAX_FILE, dirwork);
    LoadCDFile(filelist[curr_file]);
    sample() ;
}

/*-----------------------------------------------------------------------*/
