/*----------------------------------------------------------------------*/
/*      Bitmap display(15BPP)                                           */
/*----------------------------------------------------------------------*/
#include	"sgl.h"

#define         BACK_COL_ADR            ( VDP2_VRAM_A1 + 0x1fffe )

unsigned short *video_buffer = (unsigned short *) 0x5e00000;

void PlotPixel(unsigned short x, unsigned short y, unsigned char r, unsigned char g, unsigned char b);

//////////////////////////////////////////////////////////////////////////////

void ss_main(void)
{
   int i, i2, j, x, y;

   slInitSystem(TV_320x224,NULL,1);
   slTVOff();

   slBack1ColSet((void *)BACK_COL_ADR , 0);
   slBitMapNbg0(COL_TYPE_32768, BM_512x256, video_buffer);

   slScrPosNbg0((FIXED)0, (FIXED)0);
   slScrAutoDisp(NBG0ON);
   slTVOn();

   // clear bitmap area

   for (i = 0; i < 512*256; i++)
      video_buffer[i] = 0;

   for (i2 = 0 ; i2 < 224; i2++)
   {
      for (i = 0; i < 320; i++)
      {                               
         PlotPixel(i, i2, i2 + 34, i2 + 34, i2 + 34);
      }
   }

   while(1)
   {
      slSynch();
   } 
}

//////////////////////////////////////////////////////////////////////////////

void PlotPixel(unsigned short x, unsigned short y, unsigned char r, unsigned char g, unsigned char b)
{
   video_buffer[(y * 512) + x] = 0x8000 +           // transparent bit
                                 ((b >> 3) << 10) + // b
                                 ((g >> 3) << 5) +  // g
                                 ((r >> 3));        // r
}

