/*----------------------------------------------------------------------*/
/*      Bitmap display(24BPP) Line scroll                               */
/*                                                                      */
/*      This tests features described in Technical Bulletin #14         */
/*                                                                      */
/*----------------------------------------------------------------------*/

#include        "sgl.h"

#define         BACK_COL_ADR            ( VDP2_VRAM_A1 + 0x1fffe )

unsigned long *video_buffer = (unsigned long *) 0x5e00000;
unsigned long *linescrtbl_buffer = (unsigned long *) 0x5e60000;
unsigned long *vertcellscrtbl_buffer = (unsigned long *) 0x5e60700;
extern unsigned char gfx[0x60000];
extern unsigned long linescrtbl[448];
extern unsigned long vertcellscrtbl[64];

void PlotPixel(unsigned short x, unsigned short y, unsigned char r, unsigned char g, unsigned char b);

//////////////////////////////////////////////////////////////////////////////

void ss_main(void)
{
   int i, i2, j, x, y;

   slInitSystem(TV_320x224,NULL,1);
   slTVOff();

   slBack1ColSet((void *)BACK_COL_ADR , 0);
   slBitMapNbg0(COL_TYPE_1M, BM_512x256, video_buffer);
   slScrPosNbg0((FIXED)0, (FIXED)0);
   memcpy(video_buffer, gfx, sizeof(gfx));
   memcpy(linescrtbl_buffer, linescrtbl, sizeof(linescrtbl));
   memcpy(vertcellscrtbl_buffer, vertcellscrtbl, sizeof(vertcellscrtbl));
   slLineScrollTable0(linescrtbl_buffer);
   slVCellTable(vertcellscrtbl_buffer);
   slLineScrollModeNbg0(lineVScroll|lineHScroll|VCellScroll);
   slScrAutoDisp(NBG0ON);
   slTVOn();

   while(1)
   {
      slSynch();
   } 
}

//////////////////////////////////////////////////////////////////////////////

