#include <stdio.h>

typedef struct RGB_color_typ
{
        unsigned char r;    // red   component of color 0-63
        unsigned char g;  // green component of color 0-63
        unsigned char b;   // blue  component of color 0-63
} RGB_color, *RGB_color_ptr;

typedef struct
{
   unsigned long FileSize;
   unsigned long Reserved;
   unsigned long DataOffset;
} bmp_header;

typedef struct
{
unsigned long size;
unsigned long width;
unsigned long height;
unsigned short planes;
unsigned short bpp;
unsigned long compression;
unsigned long ImageSize;
unsigned long XppM;
unsigned long YppM;
unsigned long colorsused;
unsigned long colorsimportant;
RGB_color ColorTable[256];
} info_header;

bmp_header header;

info_header header2;

unsigned char *BMP_Load(char *filename, bmp_header *head, info_header *head2)
{
   FILE *fp;
   unsigned short temp_short=0;
   int i;
   unsigned char *buffer;

   // open the file

   fp = fopen(filename,"rb");

   if (fp == NULL)
   {
      printf("Error opening file\n");
      return NULL;
   }

   fread ((void *)&temp_short, 2, 1, fp);

   if (temp_short != 0x4D42)
   {
      printf("Not a BMP file\n");
      fclose(fp);

      return NULL;
   }

   fread((void *)&head->FileSize, 1, 4, fp);
   fread((void *)&head->Reserved, 1, 4, fp);
   fread((void *)&head->DataOffset, 1, 4, fp);

   fread((void *)&head2->size, 1, 4, fp);
   fread((void *)&head2->width, 1, 4, fp);
   fread((void *)&head2->height, 1, 4, fp);

   buffer = (unsigned char *)malloc(head2->width * head2->height);

   if (buffer == NULL)
   {
      printf("Not enough memory\n");
      fclose(fp);

      return NULL;
   }

   fread((void *)&head2->planes, 1, 2, fp);
   fread((void *)&head2->bpp, 1, 2, fp);

   if (head2->bpp != 8)
   {
      printf("Bitmap must be 8BPP!\n");
      free(buffer);
      fclose(fp);

      return NULL;
   }

   fread((void *)&head2->compression, 1, 4, fp);
   fread((void *)&head2->ImageSize, 1, 4, fp);
   fread((void *)&head2->XppM, 1, 4, fp);
   fread((void *)&head2->YppM, 1, 4, fp);
   fread((void *)&head2->colorsused, 1, 4, fp);
   fread((void *)&head2->colorsimportant, 1, 4, fp);

   for (i = 0; i < 256; i++)
   {
      unsigned char temp_byte;

      fread((void *)&head2->ColorTable[i].r, 1, 1, fp);
      fread((void *)&head2->ColorTable[i].g, 1, 1, fp);
      fread((void *)&head2->ColorTable[i].b, 1, 1, fp);
      fread((void *)&temp_byte, 1, 1, fp);
   }

   fseek(fp, head->DataOffset, SEEK_SET);

   fread((void *)buffer, 1, head2->width * head2->height, fp);

   fclose(fp);

   return buffer;
}

int main(int argc, char *argv[])
{
   FILE *fp;
   int i, i2;
   unsigned char *temp_buffer;

   // load pcx
   temp_buffer = BMP_Load(argv[1], (bmp_header *)&header, (info_header *)&header2);

   if (temp_buffer == NULL)
   {
      printf("temp buffer not allocated\n");
      exit(1);
   }

   fp = fopen(argv[2], "wb");

   if (fp == NULL)
   {
      printf("Error writing file\n");
      free (temp_buffer);
      exit (1);
   }

   // convert image to 16-bit raw bitmap

   for (i2=0; i2 < header2.height; i2++)
   {
      for (i=0; i < header2.width; i++)
      {
         unsigned char r, g, b;
         unsigned short pal=0;

//         r = header2.ColorTable[temp_buffer[((header2.height - i2) * header2.width) + i]].r;
//         g = header2.ColorTable[temp_buffer[((header2.height - i2) * header2.width) + i]].g;
//         b = header2.ColorTable[temp_buffer[((header2.height - i2) * header2.width) + i]].b;

         r = header2.ColorTable[temp_buffer[(i2 * header2.width) + i]].r;
         g = header2.ColorTable[temp_buffer[(i2 * header2.width) + i]].g;
         b = header2.ColorTable[temp_buffer[(i2 * header2.width) + i]].b;

         r = (r >> 3) & 0x1f;
         g = (g >> 3) & 0x1f;
         b = (b >> 3) & 0x1f;
   
         pal = (b << 10) + (g << 5) + r;
//         pal = (pal << 8) + (pal >> 8);



         fwrite((void *)&pal, 1, 2, fp);
      }
   }
   
   free(temp_buffer);
   fclose (fp);
}
