#include <stdio.h>

typedef struct RGB_color_typ
{
        unsigned char red;    // red   component of color 0-63
        unsigned char green;  // green component of color 0-63
        unsigned char blue;   // blue  component of color 0-63
} RGB_color, *RGB_color_ptr;


typedef struct pcx_header_typ
{
        char manufacturer;
        char version;
        char encoding;
        char bits_per_pixel;
        int x,y;
        int width,height;
        int horz_res;
        int vert_res;
        char ega_palette[48];
        char reserved;
        char num_color_planes;
        int bytes_per_line;
        int palette_type;
        char padding[58];

} pcx_header, *pcx_header_ptr;


typedef struct pcx_picture_typ
{
        pcx_header header;
        RGB_color palette[256];
        char *buffer;
} pcx_picture, *pcx_picture_ptr;

pcx_picture conv_pic;

void PCX_Load(char *filename, pcx_picture_ptr image,int enable_palette)
{
   FILE *fp;
   int num_bytes,index;
   long count;
   unsigned char data;
   char *temp_buffer;

   // open the file

   fp = fopen(filename,"rb");

   // load the header

   temp_buffer = (char *)image;

   for (index=0; index<128; index++)
   {
      temp_buffer[index] = (char)getc(fp);
   } 

   // load the data and decompress into buffer

   count=0;

   image->buffer = (char *)malloc (256);//image->header->width * image->header->height);

   if (image->buffer == NULL)
   {
      printf("error allocating memory\n");
      return;
   }

   while(count<= 16 * 16)
   {
      // get the first piece of data

      data = (unsigned char)getc(fp);

      // is this a rle?

      if (data>=192 && data<=255)
      {
         // how many bytes in run?

         num_bytes = data-192;

         // get the actual data for the run

         data  = (unsigned char)getc(fp);

         // replicate data in buffer num_bytes times

         while(num_bytes-->0)
         {
            image->buffer[count++] = data;
         } // end while

      } // end if rle
      else
      {
         // actual data, just copy it into buffer at next location

         image->buffer[count++] = data;

      } // end else not rle

   } // end while

   // move to end of file then back up 768 bytes i.e. to begining of palette

   fseek(fp,-768L,SEEK_END);

   // load the pallete into the palette

   for (index=0; index<256; index++)
   {
      // get the red component

      image->palette[index].red   = (unsigned char)(getc(fp) >> 2);

      // get the green component

      image->palette[index].green = (unsigned char)(getc(fp) >> 2);

      // get the blue component

      image->palette[index].blue  = (unsigned char)(getc(fp) >> 2);

   } // end for index


   fclose(fp);
}

int main(int argc, char *argv[])
{
   FILE *fp;
   int i;

   // load pcx
   PCX_Load(argv[1], (pcx_picture_ptr)&conv_pic, 1);

   fp = fopen(argv[2], "wb");

   if (fp == NULL)
   {
      printf("Error writing file\n");
      free (conv_pic.buffer);
      exit (1);
   }

   // convert image to 16-bit raw bitmap

   for (i=0; i < 16 * 16; i++)
   {
      unsigned char r, g, b;
      unsigned short pal=0;

      r = conv_pic.palette[conv_pic.buffer[i]].red * 2;
      g = conv_pic.palette[conv_pic.buffer[i]].green * 2;
      b = conv_pic.palette[conv_pic.buffer[i]].blue * 2;

      r >>= 3;
      g >>= 3;
      b >>= 3;
   
      pal = (r << 10) + (g << 5) + b;
      pal = (pal << 8) + (pal >> 8);

      fwrite((void *)&pal, 1, 2, fp);
   }
   
   free(conv_pic.buffer);
   fclose (fp);
}
