#include <stdio.h>
#include <conio.h>

#include "comm.h"

unsigned short par_base_port=0x330;
unsigned long sat68kdb_bytes_transferred;

void SetupSH2Connect ();

//////////////////////////////////////////////////////////////////////////////

unsigned char PARTransferByte(unsigned char data)
{
   unsigned char ret;

   while (inportb(par_base_port + 2) & 1);
   sat68kdb_bytes_transferred++;
   ret = inportb(par_base_port);

   outportb(par_base_port, data);
   sat68kdb_bytes_transferred++;

   return ret;
}

//////////////////////////////////////////////////////////////////////////////

void PARSendWord(unsigned short data)
{
   PARTransferByte(data >> 8);
   PARTransferByte(data & 0xff);
}

//////////////////////////////////////////////////////////////////////////////

void PARSendLong(unsigned long data)
{
   PARTransferByte(data >> 24);
   PARTransferByte((data >> 16) & 0xff);
   PARTransferByte((data >> 8) & 0xff);
   PARTransferByte(data & 0xff);
}

//////////////////////////////////////////////////////////////////////////////

unsigned long PARReceiveLong()
{
   unsigned long  data;

   data = PARTransferByte(0) << 24;
   data |= PARTransferByte(0) << 16;
   data |= PARTransferByte(0) << 8;
   data |= PARTransferByte(0);

   return data;
}

//////////////////////////////////////////////////////////////////////////////

void SetupSH2Connect()
{
   while(1)
   {
      if(PARTransferByte('O') != 'C')
         continue;
      if(PARTransferByte('M') == 'M')
         break;
   }
}

//////////////////////////////////////////////////////////////////////////////

int file_load()
{
   long f_size;
   long i;
   char *filename;
   unsigned char filename_length;
   FILE *fp;

   // first receive the string length
   filename_length = PARTransferByte(0);

   printf("string length received\n");

   filename = (char *)malloc(filename_length);

   if (filename == NULL)
   {
      // error

      printf("unable to allocate memory for filename\n");
      return -1;
   }

   // Get the filename
   for (i = 0; i < strlen(filename); i++)
   {
      filename[i] = PARTransferByte(0);
   }

   printf("filename received: %s\n", filename);

   fp = fopen(filename, "rb");

   if (fp == NULL)
   {
      // error

      printf("unable to file: %s\n", filename);

      free(filename);

      PARSendLong(0); // send the file size

      return -1;
   }

   fseek(fp, 0, SEEK_END);
   f_size = ftell(fp);
   fseek(fp, 0, SEEK_SET);

   PARSendLong(f_size); // send the file size

   printf("file size sent: %d\n", f_size);

   for (i = 0; i < f_size; i++)
   {
      PARTransferByte(fgetc(fp));
   }

   printf("file sent.\n", f_size);

   fclose (fp);
   free(filename);

   return 0;
}

//////////////////////////////////////////////////////////////////////////////

int dump_memory()
{
   long f_size;
   long i;
   char *filename;
   unsigned char filename_length;
   FILE *fp;

   // first receive the string length
   filename_length = PARTransferByte(0);

   filename = (char *)malloc(filename_length);

   if (filename == NULL)
   {
      // error

      printf("unable to allocate memory for filename\n");
      return -1;
   }

   // Get the filename
   for (i = 0; i < strlen(filename); i++)
   {
      filename[i] = PARTransferByte(0);
   }

   f_size = PARReceiveLong(0); // receive the file size

   fp = fopen(filename, "wb");

   if (fp == NULL)
   {
      printf("unable to file: %s\n", filename);
      free (filename);

      return -1;
   }

   for (i = 0; i < f_size; i++)
   {
      fputc(PARTransferByte(0), fp);
   }

   fclose (fp);
   free(filename);

   return 0;
}

//////////////////////////////////////////////////////////////////////////////

int main ()
{
   unsigned char cmd;
   int done=0;

   printf("Game COMM program v1.0\n");

   printf("\nConnecting to Game...\n");

   SetupSH2Connect();

   printf("\nDone.\n");

   while (!done)
   {
      cmd = PARTransferByte(0);

      switch (cmd)
      {
         case CMND_GETFILE:
         {
            if (file_load() != 0)
            {
               printf("\nfile load error\n");
            }
            else
            {
               printf("\nfile uploaded\n");
            }
            break;
         }
         case CMND_DUMPMEM:
         {
            if (dump_memory() != 0)
            {
               printf("\ndump memory error\n");
            }
            else
            {
               printf("\nmemory dumped\n");
            }
            break;
         }
         default: break;
      }      
   }
}

