extern unsigned char mech1_spr[4][256];
extern unsigned char mech2_spr[4][256];
extern unsigned char mech3_spr[4][256];
extern unsigned char player_spr[6][256];
extern unsigned char exp_spr[6][256];
extern unsigned char mother_spr[256];
extern unsigned char test_spr[256];
extern unsigned short star_spr[3][64];
extern unsigned short missile_spr[2][64];

#define SCREEN_WIDTH      (unsigned int)320 // mode 13h screen dimensions
#define SCREEN_HEIGHT     (unsigned int)200

typedef struct RGB_color_typ
{
   unsigned char red;    // red   component of color 0-63
   unsigned char green;  // green component of color 0-63
   unsigned char blue;   // blue  component of color 0-63

} RGB_color, *RGB_color_ptr;


// GRAPH4.H

// D E F I N E S  ////////////////////////////////////////////////////////////

#define SPRITE_WIDTH      16
#define SPRITE_HEIGHT     16

#define MAX_SPRITE_FRAMES 24
#define SPRITE_DEAD       0
#define SPRITE_ALIVE      1
#define SPRITE_DYING      2

// S T R U C T U R E S ///////////////////////////////////////////////////////

typedef struct pcx_header_typ
{
        char manufacturer;
        char version;
        char encoding;
        char bits_per_pixel;
        int x,y;
        int width,height;
        int horz_res;
        int vert_res;
        char ega_palette[48];
        char reserved;
        char num_color_planes;
        int bytes_per_line;
        int palette_type;
        char padding[58];

} pcx_header, *pcx_header_ptr;


typedef struct pcx_picture_typ
{
        pcx_header header;
        RGB_color palette[256];
        char *buffer;

} pcx_picture, *pcx_picture_ptr;


typedef struct sprite_typ
{
   int x,y;            // position of sprite
   int x_old,y_old;    // old position of sprite
   int width,height;   // dimensions of sprite in pixels
   int anim_clock;     // the animation clock
   int anim_speed;     // the animation speed
   int motion_speed;   // the motion speed
   int motion_clock;   // the motion clock

   char *frames[MAX_SPRITE_FRAMES]; // array of pointers to the images
   int curr_frame;                      // current frame being displayed
   int num_frames;                      // total number of frames
   int state;                           // state of sprite, alive, dead...
   char *background;                // whats under the sprite
   void *extra_data;                // an auxialliary pointer to more
                                             // data if needed
} sprite, *sprite_ptr;


// E X T E R N A L S /////////////////////////////////////////////////////////

// G L O B A L S  ////////////////////////////////////////////////////////////

extern unsigned int sprite_width;
extern unsigned int sprite_height;

// P R O T O T Y P E S ///////////////////////////////////////////////////////

/*
void PCX_Init(pcx_picture_ptr image);

void PCX_Load(char *filename, pcx_picture_ptr image,int enable_palette);

void PCX_Delete(pcx_picture_ptr image);

void PCX_Show_Buffer(pcx_picture_ptr image);

void Sprite_Init(sprite_ptr sprite,int x,int y,int ac,int as,int mc,int ms);

void Sprite_Delete(sprite_ptr sprite);

void PCX_Grab_Bitmap(pcx_picture_ptr image,
                     sprite_ptr sprite,
                     int sprite_frame,
                     int grab_x, int grab_y);

void Behind_Sprite(sprite_ptr sprite);

void Erase_Sprite(sprite_ptr sprite);

void Draw_Sprite(sprite_ptr sprite);

unsigned char Get_Pixel(int x,int y);

int Sprite_Collide(sprite_ptr sprite_1, sprite_ptr sprite_2);

*/

unsigned short mechs_pal[] = {
        0x0000,0x7fff,0x02a0,0x56a0,0x0015,0x5415,0x0175,0x56b5,
	0x2d6b,0x7d6b,0x2feb,0x7feb,0x2d7f,0x7d7f,0x2fff,0x7fff,
	0x7bde,0x7bde,0x7bde,0x6318,0x5ef7,0x56b5,0x4e73,0x4a52,
	0x4210,0x39ce,0x35ad,0x2d6b,0x2529,0x1ce7,0x18c6,0x1084,
	0x001f,0x001e,0x001c,0x001b,0x0019,0x0018,0x0016,0x0015,
	0x0013,0x0011,0x0010,0x000e,0x000d,0x000b,0x000a,0x0008,
	0x6f7f,0x5eff,0x529f,0x421f,0x319f,0x211f,0x109f,0x001f,
	0x32bf,0x227f,0x123f,0x01ff,0x01dd,0x019a,0x0177,0x0154,
	0x6fff,0x5fff,0x53ff,0x43ff,0x33ff,0x23ff,0x13ff,0x03ff,
	0x037d,0x033a,0x02d7,0x0294,0x0231,0x01ce,0x016b,0x0108,
	0x33fa,0x23f9,0x13f7,0x03f4,0x03b2,0x0350,0x02ef,0x028c,
	0x6ffb,0x5ff8,0x53f4,0x43f0,0x33ec,0x23e8,0x13e4,0x03e0,
	0x03e0,0x03c0,0x0380,0x0360,0x0321,0x0301,0x02c1,0x02a1,
	0x0261,0x0221,0x0201,0x01c1,0x01a1,0x0161,0x0141,0x0101,
	0x7ffb,0x7ff7,0x7ff4,0x7ff0,0x7fec,0x7fe8,0x7fe4,0x7fe0,
	0x77a0,0x6b40,0x5ee0,0x5280,0x4620,0x39c0,0x2d60,0x2100,
	0x7f0c,0x7ec8,0x7ea4,0x7e80,0x7640,0x6a00,0x5dc0,0x5180,
	0x7f7b,0x7f17,0x7e94,0x7e10,0x7d8c,0x7d08,0x7ca4,0x7c20,
	0x7c00,0x7800,0x7000,0x6c00,0x6400,0x6000,0x5800,0x5400,
	0x4c00,0x4400,0x4000,0x3800,0x3400,0x2c00,0x2800,0x2000,
	0x7f7e,0x7efd,0x7e9b,0x7e1a,0x7d99,0x7d18,0x7c97,0x7c15,
	0x7413,0x6810,0x5c0f,0x500c,0x440a,0x3809,0x2c07,0x2005,
	0x7bde,0x7bde,0x7bde,0x6318,0x5ef7,0x56b5,0x4e73,0x4a52,
	0x4210,0x39ce,0x35ad,0x2d6b,0x2529,0x1ce7,0x18c6,0x7d18,
	0x73bf,0x6b9f,0x677f,0x637f,0x5b5f,0x573f,0x531f,0x4aff,
	0x42df,0x3abf,0x329f,0x327e,0x2e5d,0x2e3c,0x2a1a,0x2a19,
	0x25f8,0x25d7,0x21b5,0x21b4,0x1d94,0x1d92,0x1971,0x1950,
	0x154f,0x152e,0x110c,0x110b,0x0ce9,0x0cc8,0x0cc7,0x0885,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x14b9,0x1559,0x15f9,0x1699,0x1739,0x1734,0x172f,0x172a,
	0x1b25,0x3325,0x4725,0x5f25,0x66a5,0x6605,0x6545,0x64a6,
	0x64ab,0x64b1,0x64b6,0x58b9,0x40b9,0x2cb9,0x14b9,0x7fff
};

unsigned char dot_spr[64] = {
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};


// Sound related

#define     SoundMem         0x25a0b000

extern char mechs_map[];
extern char mechs_ton[];
extern char mechs_seq[];
extern Uint32 mapsize;
extern Uint32 tonsize;
extern Uint32 seqsize;


