// Some code borrowed from Bart's M68K debugger

#include    "sl_def.h"
//#include    "defs_sh2.h"
#include    "comm.h"
//#include    "main.h"

//////////////////////////////////////////////////////////////////////////////

/*
 * void Delay(LONG delay_value);
 *
 * A simple delay function.
 */

void Delay(LONG delay_value)
{
   while (delay_value--)   ;
}

//////////////////////////////////////////////////////////////////////////////

/*
 * BYTE PARTransferByte(BYTE data);
 *
 * Reads data from the PC, and then writes data to the PC.
 */

BYTE PARTransferByte(BYTE data)
{
   volatile BYTE   *flag = (BYTE *) PAR_ADDR_FLAG;
   BYTE            in;

   /*
    * Write
    */

   *((BYTE *) PAR_ADDR_WRITE) = data;

   /*
    * Wait for data flag to become 1
    */

   while (!(*flag & 1));

   /*
    * Read
    */

   in = *((BYTE *) PAR_ADDR_READ);

   return in;
}

//////////////////////////////////////////////////////////////////////////////

/*
 * WORD PARReceiveWord();
 *
 * Calls PARTransferByte 2 times, thus receiving data in big endian format.
 */

WORD PARReceiveWord()
{
   return (PARTransferByte(0) << 8) | PARTransferByte(0);
}

/*
 * void PARSendLong(LONG data);
 *
 * Calls PARTransferByte() 4 times, thus sending data in big endian form.
 */

void PARSendLong(LONG data)
{
    PARTransferByte(data >> 24);
    PARTransferByte((data >> 16) & 0xff);
    PARTransferByte((data >> 8) & 0xff);
    PARTransferByte(data & 0xff);
}

//////////////////////////////////////////////////////////////////////////////

/*
 * LONG PARReceiveLong();
 *
 * Calls PARTransferByte() 4 times, thus receiving data in big endian format.
 */

LONG PARReceiveLong()
{
    LONG    data;

    data = PARTransferByte(0) << 24;
    data |= PARTransferByte(0) << 16;
    data |= PARTransferByte(0) << 8;
    data |= PARTransferByte(0);

    return data;
}

//////////////////////////////////////////////////////////////////////////////

void init_comm()
{
    /*
     * Initiate communication with the PC:
     *
     *      - PC sends 'G'
     *      - Saturn sends 'F'
     *      - PC sends 'D'
     *      - Saturn sends 'G'
     */

    LONG i;

    while (1)
    {
        if (PARTransferByte('C') != 'O')
            continue;
        if (PARTransferByte('M') != 'M')
            continue;
        break;
    }
}

//////////////////////////////////////////////////////////////////////////////

int load_file(char *filename, char *addr)
{
   long f_size;
   long i;

   // Let the PC program know we want a file

   if (PARTransferByte(CMND_GETFILE) != 0)
   {
     // error
     return -1;
   }

   // first send the string length
   PARTransferByte(strlen(filename));

   // Send down the Filename
   for (i = 0; i < strlen(filename); i++)
   {
      PARTransferByte(filename[i]);
      slDispHex(i, slLocate(0, 10));
   }

   f_size = PARReceiveLong(); // grab the file size


   if (f_size == 0)
   {
     // error
     return -1;
   }

   for (i = 0; i < f_size; i++)
   {
      addr[i] = PARTransferByte(0);
   }
}

//////////////////////////////////////////////////////////////////////////////

int dump_mem(char *filename, char *addr, long size)
{
   long f_size;
   long i;

   // Let the PC program know we want to dump a file

   if (PARTransferByte(CMND_DUMPMEM) != 0)
   {
     // error
     return -1;
   }

   slPrint("Command success", slLocate(0, 2));

   // first send the string length
   PARTransferByte(strlen(filename));

   slPrint("String Length success", slLocate(0, 2));

   // Send down the Filename
   for (i = 0; i < strlen(filename); i++)
   {
      PARTransferByte(filename[i]);
   }

   slPrint("filename success", slLocate(0, 2));

   PARSendLong(f_size); // send the file size

   slPrint("file size success", slLocate(0, 2));

   for (i = 0; i < f_size; i++)
   {
      PARTransferByte(addr[i]);
   }

   slPrint("file transfer success", slLocate(0, 2));
}

//////////////////////////////////////////////////////////////////////////////
