/*----------------------------------------------------------------------*/
/*      Bitmap display(24BPP)                                           */
/*      -Mosaic test                                                    */
/*----------------------------------------------------------------------*/

#include	"sgl.h"

#define         BACK_COL_ADR            ( VDP2_VRAM_A1 + 0x1fffe )

unsigned long *video_buffer = (unsigned long *) 0x5e00000;

void PlotPixel(unsigned short x, unsigned short y, unsigned char r, unsigned char g, unsigned char b);

extern unsigned char tst_image[];
extern unsigned long tst_image_size;

//////////////////////////////////////////////////////////////////////////////

void ss_main(void)
{
   int i, i2, j, x, y;
   unsigned char inc_bool=1;
   unsigned char mos_cnt=1;

   slInitSystem(TV_320x224,NULL,1);
   slTVOff();

   slBack1ColSet((void *)BACK_COL_ADR , 0);
   slBitMapNbg0(COL_TYPE_1M, BM_512x256, video_buffer);

   slScrPosNbg0((FIXED)0, (FIXED)0);
   slScrAutoDisp(NBG0ON);
   slTVOn();

   // clear bitmap area
   for (i = 0; i < 512*256; i++)
      video_buffer[i] = 0;

   for (i2 = 0; i2 < 224; i2++)
   {
      for (i = 0; i < 320; i++)
      {
         PlotPixel(i, i2, tst_image[((i2 * 320) + i) * 3], tst_image[(((i2 * 320) + i) * 3) + 1], tst_image[(((i2 * 320) + i) * 3) + 2]);
      }
   }

   slScrMosSize(1, 1);
   slScrMosaicOn(NBG0ON);

   while(1)
   {


      if (inc_bool && mos_cnt != 16)
      {
         mos_cnt++;
      }
      else if (inc_bool && mos_cnt == 16)
      {
         inc_bool = 0;
         mos_cnt--;
      }
      else if (!inc_bool && mos_cnt != 1)
      {
         mos_cnt--;
      }
      else if (!inc_bool && mos_cnt == 1)
      {
         inc_bool = 1;
         mos_cnt++;
      }

      slScrMosSize(mos_cnt, mos_cnt);


      slSynch();

      // delay a bit
      for (i = 0; i < 500000; i++)
      {
      }
   } 
}

//////////////////////////////////////////////////////////////////////////////

void PlotPixel(unsigned short x, unsigned short y, unsigned char r, unsigned char g, unsigned char b)
{
   video_buffer[(y * 512) + x] = 0x80000000 + // transparent bit
                                 (b << 16) +  // b
                                 (g << 8) +   // g
                                 (r);         // r


}
