//                                                      
//  Control Test
//                                                      

//#include    "per_def.h"
#include    "sgl.h"
#include    "main.h"

//////////////////////////////////////////////////////////////////////////////
void disp_per_name(Uint8 per_id, Uint8 x, Uint8 y);
void disp_per_status(Uint8 per_num, Uint8 per_id, Uint8 x, Uint8 y);
//////////////////////////////////////////////////////////////////////////////

void ss_main(void)
{
    slInitSystem(TV_320x224,NULL,1);

    // Re-initialize contact with PC here

    slPrint("Peripheral Test 0.1", slLocate(2,2));
        
    while (-1)
    {
       unsigned char per_id;
       
       slPrint("Port 1:", slLocate(2,4));
       
       per_id = Smpc_Peripheral[0].id;
       disp_per_name(per_id, 10, 4);       
       disp_per_status(0, per_id, 2, 6);

       slPrint("Port 2:", slLocate(2,13));
       per_id = Smpc_Peripheral[15].id;
       disp_per_name(per_id, 10, 13);
       disp_per_status(15, per_id, 2, 15);
       
       //slDispHex(Smpc_Peripheral[0].data, slLocate(2,7));
       //slDispHex(Per_Connect2, slLocate(2,8));
    }
   
}

void disp_per_name(Uint8 per_id, Uint8 x, Uint8 y)
{
   switch (per_id)
   {
      case PER_ID_StnPad:
      {
         slPrint("Standard Pad     ", slLocate(x,y));
         break;
      }
      case PER_ID_StnMouse:
      {
         slPrint("Standard Mouse   ", slLocate(x,y));
         break;
      }
      case PER_ID_StnKeyBoard:
      {
         slPrint("Standard Keyboard", slLocate(x,y));
         break;
      }
      case PER_ID_ShuttleMouse:
      {
         slPrint("Shuttle Mouse    ", slLocate(x,y));
         break;
      }
      case PER_ID_NotConnect:
      {
         slPrint("Not Connected    ", slLocate(x,y));
         break;
      }
      default:
      {
         slPrint("Unknown          ", slLocate(x,y));
         break;
      }
   }
}

void disp_per_status(Uint8 per_num, Uint8 per_id, Uint8 x, Uint8 y)
{
   switch(per_id)
   {
      case PER_ID_StnPad:
      {
         break;
      }
      case PER_ID_ShuttleMouse:
      {
         Uint16 mouse_x;
         Uint16 mouse_y;

         if (!(Smpc_Peripheral[per_num].data & PER_DGT_ST))
         {
            slPrint("Start Button: Pressed    ", slLocate(x, y));
         }
         else
         {
            slPrint("Start Button: Not Pressed", slLocate(x, y));
         }

         if (!(Smpc_Peripheral[per_num].data & PER_DGT_TA))
         {
            slPrint("Left Button: Pressed    ", slLocate(x, y + 1));
         }
         else
         {
            slPrint("Left Button: Not Pressed", slLocate(x, y + 1));
         }

         if (!(Smpc_Peripheral[per_num].data & PER_DGT_TB))
         {
            slPrint("Middle Button: Pressed    ", slLocate(x, y + 2));
         }
         else
         {
            slPrint("Middle Button: Not Pressed", slLocate(x, y + 2));
         }

         if (!(Smpc_Peripheral[per_num].data & PER_DGT_TC))
         {
            slPrint("Right Button: Pressed    ", slLocate(x, y + 3));
         }
         else
         {
            slPrint("Right Button: Not Pressed", slLocate(x, y + 3));
         }

         slPrint("x:", slLocate(x, y + 4));
         slPrint("y:", slLocate(x, y + 5));

         mouse_x = Smpc_Peripheral[0].dummy2[per_num] >> 16;
         mouse_y = (Smpc_Peripheral[0].dummy2[per_num] << 16) >> 16;
         
         slDispHex(mouse_x, slLocate(x + 3, y + 4));
         slDispHex(mouse_y, slLocate(x + 3, y + 5));
         
         break;
      }
      default:
      {
         break;
      }
   }
}

