#include <allegro.h>
#include <winalleg.h>
#include <commctrl.h>
#include <stdio.h>
#include <stdlib.h>
#include "main.h"
#include "resource.h"
#include "plugin.h"

static char szAppName[] = "Sakuralation v1.0";
static char szClassName[] = "SAKURALA";
HINSTANCE g_hInstance;

#undef DEBUG

#define TIMER_ID 1

//////////////////////////////////////////////////////////////////////////////

#define MAX_FILEPATH    256

static char strPath[512] = "";
static char strPluginPath[512] = "";
OPENFILENAME text_file;
OPENFILENAME font_file;
OPENFILENAME plugin_file;
OPENFILENAME palette_file;
char gszTextOpenName[MAX_FILEPATH];
char gszFontOpenName[MAX_FILEPATH];
char gszPluginOpenName[MAX_FILEPATH];
char gszPaletteOpenName[MAX_FILEPATH];

int font_loaded=FALSE;
int text_loaded=FALSE;
int plugin_loaded=FALSE;
int plugin_inited=FALSE;

//////////////////////////////////////////////////////////////////////////////

FILE *fp;
FILE *fontfp;
FILE *textfp;
unsigned long font_size;
unsigned long text_size;
unsigned long text_startoffset=0;
unsigned long text_prevoffset=0;
unsigned long text_offset=0;
unsigned long text_nextoffset=0;
unsigned long font_offset=0;
unsigned char tile_width, tile_height;
unsigned char *font_buffer;
unsigned char *text_buffer;
unsigned char tile_work[256 * 256];
unsigned char usenl=0;

bool used_cancel=FALSE;

BITMAP *double_buffer;

//////////////////////////////////////////////////////////////////////////////

void BufferToBitmap(unsigned char *buffer, BITMAP *bitmap, unsigned short x, unsigned short y);
void DrawPage (HWND hWnd);
void GotoNextLine();
void GotoPrevLine();

//////////////////////////////////////////////////////////////////////////////

InitPluginType InitPlugin=NULL;
DecodeTextType DecodeText=NULL;
RenderTileType RenderTile=NULL;

static HINSTANCE dllhandle=NULL;

//////////////////////////////////////////////////////////////////////////////

#ifdef DEBUG
FILE *dbgfp;
#endif

//////////////////////////////////////////////////////////////////////////////

LRESULT CALLBACK WindowProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
//   MINMAXINFO *pMinMax;
   HRESULT hRet;
   HMENU hMenu;

   switch (uMsg)
   {
      case WM_COMMAND:
      {
         switch (LOWORD(wParam))
         {
            case IDM_LOADTEXT:
            {
               if (GetOpenFileName(&text_file))
               {
                   //first make sure text_buffer is empty

                   if (text_buffer) free (text_buffer);

                   //Load file here

                   fp = fopen(gszTextOpenName,"rb");

                   if (fp == NULL)
                   {
                      MessageBox (hWnd, "Error loading file", "Error",
                                  MB_OK | MB_ICONINFORMATION);
                      text_loaded = FALSE;
                   }
                   else
                   {
                      // reset the offset or face the consequences!
                      text_offset = 0;

                      text_size = filelength(fileno(fp));

                      text_buffer = (unsigned char *)malloc(text_size);

                      if (text_buffer == NULL)
                      {
                         MessageBox (hWnd, "Error loading file - not enough memory", "Error",
                         MB_OK | MB_ICONINFORMATION);

                         text_loaded = FALSE;
                      }
                      else
                      {
                         fread(text_buffer, 1, filelength(fileno(fp)), fp);

                         text_loaded = TRUE;
                      }

                      fclose (fp);
                   }

                   // If loading succesful, check to see if other files
                   // have already been loaded. If so, start showing output

                   if (text_loaded == TRUE && font_loaded == TRUE &&
                       plugin_loaded == TRUE)
                   {
                      // reset the offsets
                      text_offset = text_startoffset = text_prevoffset =
                                    text_nextoffset = font_offset = 0;


                      if(InitPlugin (text_buffer, (unsigned long *)&text_startoffset,
                         (unsigned char *)&tile_width, (unsigned char *)&tile_height) != 0)
                      {
                         MessageBox (hWnd, "Error initializing plugin", "Error",
                         MB_OK | MB_ICONINFORMATION);

                         plugin_inited = FALSE;
                      }
                      else
                      {
                         text_offset = text_prevoffset = text_startoffset;

                         DrawPage (hWnd);
        
                         acquire_bitmap(screen);
                         stretch_blit(double_buffer, screen, 0, 0, 320, 240, 0, 0, 640, 480);
                         release_bitmap(screen);   

                         plugin_inited = TRUE;
                      }
                   }

                   text_file.lpstrTitle = gszTextOpenName;
               }
               break;
            }
            case IDM_LOADFONT:
            {
               if (GetOpenFileName(&font_file))
               {
                   //first make sure font_buffer is empty

                   if (font_buffer) free (font_buffer);

                   //Load file here

                   fp = fopen(gszFontOpenName,"rb");

                   if (fp == NULL)
                   {
                      MessageBox (hWnd, "Error loading file", "Error",
                                  MB_OK | MB_ICONINFORMATION);
                      font_loaded = FALSE;
                   }
                   else
                   {
                      // reset the offset or face the consequences!
                      font_offset = 0;

                      font_size = filelength(fileno(fp));

                      font_buffer = (unsigned char *)malloc(font_size);

                      if (font_buffer == NULL)
                      {
                         MessageBox (hWnd, "Error loading file - not enough memory", "Error",
                         MB_OK | MB_ICONINFORMATION);

                         font_loaded = FALSE;
                      }
                      else
                      {
                         fread(font_buffer, 1, filelength(fileno(fp)), fp);

                         font_loaded = TRUE;
                      }

                      fclose (fp);
                   }

                   // If loading succesful, check to see if other files
                   // have already been loaded. If so, start showing output

                   if (text_loaded == TRUE && font_loaded == TRUE &&
                       plugin_loaded == TRUE)
                   {
                      // reset the offsets
                      text_offset = text_startoffset = text_prevoffset =
                                    text_nextoffset = font_offset = 0;


                      if(InitPlugin (text_buffer, (unsigned long *)&text_startoffset,
                         (unsigned char *)&tile_width, (unsigned char *)&tile_height) != 0)
                      {
                         MessageBox (hWnd, "Error initializing plugin", "Error",
                         MB_OK | MB_ICONINFORMATION);

                         plugin_inited = FALSE;
                      }
                      else
                      {
                         text_offset = text_prevoffset = text_startoffset;

                         DrawPage (hWnd);
        
                         acquire_bitmap(screen);
                         stretch_blit(double_buffer, screen, 0, 0, 320, 240, 0, 0, 640, 480);
                         release_bitmap(screen);   

                         plugin_inited = TRUE;
                      }
                   }


                   font_file.lpstrTitle = gszFontOpenName;
               }
               break;
            }
            case IDM_LOADPLUGIN:
            {
               if (GetOpenFileName(&plugin_file))
               {
                   //first make sure dllhandle is empty

                   if (dllhandle)
                   {
                      FreeLibrary(dllhandle);

                      InitPlugin = NULL;
                      DecodeText = NULL;
                      RenderTile = NULL;
                   }

                   //Load file here

                   dllhandle = LoadLibrary(gszPluginOpenName);

                   if (dllhandle == NULL)
                   {
                      MessageBox (hWnd, "Error loading plugin", "Error",
                      MB_OK | MB_ICONINFORMATION);

                      plugin_loaded = FALSE;
                   }
                   else
                   {
                      // dll loaded successfully

                      InitPlugin = (InitPluginType) GetProcAddress(dllhandle,
                                                                "InitPlugin");
                      DecodeText = (DecodeTextType) GetProcAddress(dllhandle,
                                                                "DecodeText");
                      RenderTile = (RenderTileType) GetProcAddress(dllhandle,
                                                                "RenderTile");

                      if (InitPlugin == NULL || DecodeText == NULL ||
                          RenderTile == NULL)
                      {
                         MessageBox (hWnd, "Error loading plugin", "Error",
                                     MB_OK | MB_ICONINFORMATION);

                         FreeLibrary(dllhandle);
                      }
                      else
                      {
                         plugin_loaded = TRUE;
                      }
                   }

                   // If loading succesful, check to see if other files
                   // have already been loaded. If so, start showing output

                   if (text_loaded == TRUE && font_loaded == TRUE &&
                       plugin_loaded == TRUE)
                   {
                      // reset the offsets
                      text_offset = text_startoffset = text_prevoffset =
                                    text_nextoffset = font_offset = 0;


                      if(InitPlugin (text_buffer, (unsigned long *)&text_startoffset,
                         (unsigned char *)&tile_width, (unsigned char *)&tile_height) != 0)
                      {
                         MessageBox (hWnd, "Error initializing plugin", "Error",
                         MB_OK | MB_ICONINFORMATION);

                         plugin_inited = FALSE;
                      }
                      else
                      {
                         text_offset = text_prevoffset = text_startoffset;

                         DrawPage (hWnd);
        
                         acquire_bitmap(screen);
                         stretch_blit(double_buffer, screen, 0, 0, 320, 240, 0, 0, 640, 480);
                         release_bitmap(screen);

                         plugin_inited = TRUE;
                      }
                   }

                   plugin_file.lpstrTitle = gszPluginOpenName;
               }
               break;
            }
            case IDM_LOADPALETTE:
            {
               if (GetOpenFileName(&palette_file))
               {
                   //Load file here

                   fp = fopen(gszPaletteOpenName,"rb");

                   if (fp == NULL)
                   {
                      MessageBox (hWnd, "Error loading file", "Error",
                                  MB_OK | MB_ICONINFORMATION);
                   }
                   else
                   {
                      PALETTE temp_palette;

                      if (filelength(fileno(fp)) != 768)
                      {
                         MessageBox (hWnd, "Not a palette file", "Error",
                                     MB_OK | MB_ICONINFORMATION);
                      }
                      else
                      {
                         int i;

                         for (i = 0; i < 256; i++)
                         {
                            fread((void *)&temp_palette[i].r, 1, 1, fp);
                            fread((void *)&temp_palette[i].g, 1, 1, fp);
                            fread((void *)&temp_palette[i].b, 1, 1, fp);

                            temp_palette[i].r >>= 2;
                            temp_palette[i].g >>= 2;
                            temp_palette[i].b >>= 2;
                         }

                         set_palette(temp_palette);
                      }

                      fclose (fp);
                   }

                   // If loading succesful, check to see if other files
                   // have already been loaded. If so, start showing output

                   palette_file.lpstrTitle = gszPaletteOpenName;
               }
               break;
            }
            case IDM_SETTINGS:
            {
               break;
            }
            case IDM_ABOUT:
            {
               DialogBox(g_hInstance, "AboutDlg", hWnd, (DLGPROC)AboutDlgProc);
               break;
            }
            case IDM_EXIT:
               PostMessage(hWnd, WM_CLOSE, 0, 0);
               break;
         }
         return 0L;
      }
      case WM_GETMINMAXINFO:
      {
         return 0L;
      }
      case WM_MOVE:
      {
         return 0L;
      }
      case WM_PAINT:
      {
         PAINTSTRUCT ps;

         BeginPaint(hWnd, &ps);
         EndPaint(hWnd, &ps);
         return 0L;
      }
      case WM_SIZE:
      {
         return 0L;
      }
      case WM_KEYDOWN:
      {
         switch (wParam)
         {
            case VK_UP:
            {
               GotoPrevLine();

               DrawPage (hWnd);

               acquire_bitmap(screen);
               stretch_blit(double_buffer, screen, 0, 0, 320, 240, 0, 0, 640, 480);
               release_bitmap(screen);   
               break;
            }
            case VK_DOWN:
            {
               GotoNextLine();

               DrawPage (hWnd);

               acquire_bitmap(screen);
               stretch_blit(double_buffer, screen, 0, 0, 320, 240, 0, 0, 640, 480);
               release_bitmap(screen);   
               break;
            }
            case VK_PRIOR: // PAGE UP
            {
               // Previous Page

               if (text_prevoffset >= text_startoffset)
               {
                  text_offset = text_prevoffset;
               }

               DrawPage (hWnd);

               acquire_bitmap(screen);
               stretch_blit(double_buffer, screen, 0, 0, 320, 240, 0, 0, 640, 480);
               release_bitmap(screen);   

               break;
            }
            case VK_NEXT: // PAGE DOWN
            {
               // Next Page

               text_prevoffset = text_offset;
               text_offset = text_nextoffset;

               DrawPage (hWnd);

               acquire_bitmap(screen);
               stretch_blit(double_buffer, screen, 0, 0, 320, 240, 0, 0, 640, 480);
               release_bitmap(screen);

               break;
            }
            case VK_HOME:
            {
               // Start

               text_offset = text_prevoffset = text_startoffset;

               DrawPage (hWnd);

               acquire_bitmap(screen);
               stretch_blit(double_buffer, screen, 0, 0, 320, 240, 0, 0, 640, 480);
               release_bitmap(screen);   
               break;
            }
            case VK_END:
            {
               break;
            }

            default: break;
         }
         return 0L;
      }
      case WM_DESTROY:
      {
         PostQuitMessage(0);

         free(text_buffer);
         free(font_buffer);

         destroy_bitmap(double_buffer);
         FreeLibrary(dllhandle);

         return 0L;
      }

    }

    return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

//////////////////////////////////////////////////////////////////////////////

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine, int nCmdShow)
{
   WNDCLASS                    MyWndClass;
   HRESULT                     hRet;
   HWND                        hWnd;
   int                         cx, cy;
   MSG                         msg;

   // Set up and register window class
   MyWndClass.style = CS_HREDRAW | CS_VREDRAW;
   MyWndClass.lpfnWndProc = (WNDPROC) WindowProc;
   MyWndClass.cbClsExtra = 0;
   MyWndClass.cbWndExtra = sizeof(DWORD);
   MyWndClass.hInstance = hInstance;
    MyWndClass.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON));
   MyWndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
   MyWndClass.hbrBackground = (HBRUSH)COLOR_WINDOW;//(HBRUSH) GetStockObject(GRAY_BRUSH);
   MyWndClass.lpszMenuName = MAKEINTRESOURCE(IDR_MENU);
   MyWndClass.lpszClassName = szClassName;

   if (!RegisterClass(&MyWndClass))
       return FALSE;

//    switch (GetSystemMetrics(SM_CXSCREEN))
//    {
//       case 640:
//       {
//          window_w = 320;
//          window_h = 240;
//          scale=1;
//          break;
//       }
//       case 800:
//       case 848:
//       {
//          window_w = 640;
//          window_h = 480;
//          scale=2;
//          break;
//       }
//       case 1024:
//       case 1152:
//       case 1280:
//       {
//          window_w = 960;
//          window_h = 720;
//          scale=3;
//          break;
//       }
//       case 1600:
//       {
//          window_w = 1280;
//          window_h = 960;
//          scale=4;
//          break;
//       }
//       case 1800:
//       case 1856:
//       {
//          window_w = 1600;
//          window_h = 1200;
//          scale=5;
//          break;
//       }
//       default:
//       {
//          window_w = 640;
//          window_h = 480;
//          scale=1;
//          break;
//       }
//    }

   cx = 640 + GetSystemMetrics(SM_CXSIZEFRAME) * 2;
   cy = 480 + (GetSystemMetrics(SM_CYSIZEFRAME) * 2) + GetSystemMetrics(SM_CYMENU) + GetSystemMetrics(SM_CYCAPTION);

   // Create a window
   hWnd = CreateWindow(szClassName,        // class
                       szAppName,          // caption
                       WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU |
                       WS_THICKFRAME | WS_MINIMIZEBOX |  // style
                       WS_CLIPCHILDREN,  
                       CW_USEDEFAULT,      // x pos
                       CW_USEDEFAULT,      // y pos
                       cx,        // width
                       cy,       // height
                       HWND_DESKTOP,       // parent window
                       NULL,               // menu 
                       hInstance,          // instance
                       NULL);              // parms

   if (!hWnd)
       return FALSE;

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   set_color_depth(8);
   win_set_window(hWnd);
   allegro_init();

   if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0)
   {
      MessageBox (hWnd, "Error Setting up graphics", "Error",
                  MB_OK | MB_ICONINFORMATION);
      return FALSE;
   }

   if (set_display_switch_mode(SWITCH_BACKGROUND) == -1)
   {
      MessageBox (hWnd, "Error setting up display switch mode", "Error",
                  MB_OK | MB_ICONINFORMATION);
      return FALSE;
   }

   double_buffer = create_bitmap (320, 240);

   if (double_buffer == NULL)
   {
      MessageBox (hWnd, "Error creating work bitmap", "Error",
                  MB_OK | MB_ICONINFORMATION);

      return FALSE;
   }

   memset(&text_file, 0, sizeof(OPENFILENAME));
   text_file.lStructSize = sizeof(OPENFILENAME);
   text_file.hwndOwner = hWnd;
   text_file.lpstrFilter = "All Files (*.*)\0*.*\0";
   text_file.lpstrFile = gszTextOpenName;
   text_file.nMaxFile = sizeof(gszTextOpenName);
   text_file.Flags = OFN_HIDEREADONLY;

   memset(&font_file, 0, sizeof(OPENFILENAME));
   font_file.lStructSize = sizeof(OPENFILENAME);
   font_file.hwndOwner = hWnd;
   font_file.lpstrFilter = "All Files (*.*)\0*.*\0";
   font_file.lpstrFile = gszFontOpenName;
   font_file.nMaxFile = sizeof(gszFontOpenName);
   font_file.Flags = OFN_HIDEREADONLY;

   memset(&plugin_file, 0, sizeof(OPENFILENAME));
   plugin_file.lStructSize = sizeof(OPENFILENAME);
   plugin_file.hwndOwner = hWnd;
   plugin_file.lpstrFilter = "Plugins (*.dll)\0*.dll\0All Files (*.*)\0*.*\0";
   plugin_file.lpstrFile = gszPluginOpenName;
   plugin_file.nMaxFile = sizeof(gszPluginOpenName);
   plugin_file.Flags = OFN_HIDEREADONLY;

   memset(&palette_file, 0, sizeof(OPENFILENAME));
   palette_file.lStructSize = sizeof(OPENFILENAME);
   palette_file.hwndOwner = hWnd;
   palette_file.lpstrFilter = "Palette Files (*.act)\0*.act\0All Files (*.*)\0*.*\0";
   palette_file.lpstrFile = gszPaletteOpenName;
   palette_file.nMaxFile = sizeof(gszPaletteOpenName);
   palette_file.Flags = OFN_HIDEREADONLY;

   gszTextOpenName[0] = 0;
   gszFontOpenName[0] = 0;
   gszPluginOpenName[0] = 0;
   gszPaletteOpenName[0] = 0;

   g_hInstance = hInstance;

   while (GetMessage(&msg, NULL, NULL, NULL))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }

   return (msg.wParam);
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CALLBACK AboutDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam,
                              LPARAM lParam)
{
   switch (uMsg)
   {
      case WM_INITDIALOG:
      {
         return TRUE;
      }
      case WM_COMMAND:
      {
         switch (wParam)
         {
            case IDOK:
            {
               EndDialog(hDlg, TRUE);
               return TRUE;
            }
            default: break;
         }
         break;
      }
   }

   return FALSE;
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CALLBACK SettingsDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam,
                                 LPARAM lParam)
{
   switch (uMsg)
   {
      case WM_INITDIALOG:
      {
         return TRUE;
      }
      case WM_COMMAND:
      {
         switch (wParam)
         {
            case IDOK:
            {
               EndDialog(hDlg, TRUE);
               return TRUE;
            }
            case IDCANCEL:
            {
               EndDialog(hDlg, TRUE);
               return TRUE;
            }
            default: break;
         }
         break;
      }
   }

   return FALSE;
}

//////////////////////////////////////////////////////////////////////////////

unsigned long ConvertAtoH(char *buffer)
{
   unsigned long output=0;
   int i;

   for (i = 0; i < 8; i++)
   {
      if(buffer[i] <= 'F' && buffer[i] >= 'A')
      {
         output += (buffer[i] - 'A' + 10) << (28 - (i * 4))  ;
      }
      else if(buffer[i] <= 'f' && buffer[i] >= 'a')
      {
         output += (buffer[i] - 'a' + 10) << (28 - (i * 4));
      }
      else if(buffer[i] >= '0' && buffer[i] <= '9')
      {
         output += (buffer[i] - '0') << (28 - (i * 4));
      }
      else
      {
         output=0;
         break;
      }
   }

   return output;
}

//////////////////////////////////////////////////////////////////////////////

void BufferToBitmap(unsigned char *buffer, BITMAP *bitmap, unsigned short x, unsigned short y)
{
   int i, i2;

   acquire_bitmap(bitmap);

   for (i2 = 0; i2 < tile_height; i2++)
   {
      for (i = 0; i < tile_width; i++)
      {
         putpixel(bitmap, x + i, y + i2, buffer[(tile_width * i2) + i]);
      }
   }

   release_bitmap(bitmap);
}

//////////////////////////////////////////////////////////////////////////////

void DrawPage (HWND hWnd)
{
   unsigned long temp_long;
   unsigned short x=0,y=0;
   int i;
   int done=0;
   char temp_string[45];

   clear_bitmap(double_buffer);

   text_nextoffset = text_offset;

   sprintf(temp_string, "%s - Text Offset: 0x%08x", szAppName, text_offset);
   SetWindowText(hWnd, temp_string);

   while (!done)
   {
      usenl = 0;
      temp_long = DecodeText(text_buffer + text_nextoffset,
                             (unsigned long *)&font_offset,
                             (unsigned char *)&usenl);

      text_nextoffset += temp_long;


      if (usenl == 0)
      {
         RenderTile(font_buffer + font_offset, tile_work);

         BufferToBitmap(tile_work, double_buffer, x * tile_width, y * tile_height);

         x += 1;

         if (x * tile_width > (320 - tile_width))
         {
            x = 0;
            y += 1;
         }
      }
      else if (usenl == 1)
      {
         y += 1;
         x = 0;

         if (y * tile_height > (240 - tile_height))
         {
            done = 1;
         }
      }
   }
}

//////////////////////////////////////////////////////////////////////////////

void GotoNextLine()
{
   unsigned long temp_long;

#ifdef DEBUG
   dbgfp = fopen("test.out", "wb");

   fprintf(dbgfp, "text_offset = %d\n", text_offset);

#endif

   usenl = 0;

   while (usenl < 1)
   {
      temp_long = DecodeText(text_buffer + text_offset,
                             (unsigned long *)&font_offset,
                             (unsigned char *)&usenl);
      text_offset += temp_long;
   }

#ifdef DEBUG
   fprintf(dbgfp, "text_offset = %d\n", text_offset);

   fclose (dbgfp);
#endif

}

//////////////////////////////////////////////////////////////////////////////

void GotoPrevLine()
{
   char counter=0;
   unsigned long temp_long=0;
/*
   temp_long = text_prevoffset;

   while (counter < 19)
   {
      usenl = 0;

      temp_long += DecodeText(text_buffer + temp_long,
                             (unsigned long *)&font_offset,
                             (unsigned char *)&usenl);

      if (usenl > 0 && counter == 0) text_prevoffset = temp_long;

      counter += usenl;
   }

   text_offset = temp_long;
*/
}

