#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif

#ifndef WINVER
#define WINVER 0x500
#endif

#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x500
#endif

#include <stdio.h>
#include <io.h>
#include <windows.h>
#include <ddraw.h>

#include <commdlg.h>
#include <commctrl.h>

#include "resource.h"
#include "plugins\sdk.h"
#include "main.h"
#include "ddutil.h"
#include "tileedit.h"

#undef DEBUG
//#define DEBUG 1

#define TIMER_ID 1
#define WIDTHBYTES(i)   ((i+31)/32*4)

static char szAppName[] = "TranslationNext Editor";
static char szClassName[] = "TNEDIT";
static HACCEL hAccel;

#define MAX_FILEPATH    256

static char strPath[512] = "";
static char strPluginPath[512] = "";
OPENFILENAME rom_file;
OPENFILENAME plugin_file;
OPENFILENAME palette_file;
char gszOpenName[MAX_FILEPATH];
char gszPluginOpenName[MAX_FILEPATH];
char gszPalOpenName[MAX_FILEPATH];
BOOL pluginloaded = FALSE;
BOOL romloaded = FALSE;
BOOL editmode = FALSE;

FILE *fp;
unsigned char *rom_buffer = NULL;
unsigned char *temp_buffer = NULL;
long rom_offset=0;
char offset_text[8];
long rom_length=0;
char scale=1;

static HINSTANCE dllhandle = NULL;

PluginStartupType PluginStartup = NULL;
PluginShutdownType PluginShutdown = NULL;
PluginTilePackType PluginTilePack = NULL;
PluginTileUnpackType PluginTileUnpack = NULL;
PluginUpdateType PluginUpdate = NULL;
PluginSaveType PluginSave = NULL;

tilemode *supp_modes = NULL;
unsigned char *num_modes = NULL;

int window_w=640;
int window_h=480;
unsigned char curr_mode=0;

HINSTANCE g_hInstance;

imp_func imp_fnc;

//////////////////////////////////////////////////////////////////////////////

LRESULT CALLBACK WindowProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
   MINMAXINFO *pMinMax;
   HRESULT hRet;

   switch (uMsg)
   {
      case WM_ACTIVATE:
      {
         g_bActive = !((BOOL)HIWORD(wParam));
         return 0L;
      }
      case WM_COMMAND:
      {
         switch (LOWORD(wParam))
         {
            case IDM_SAVE:
            {
               break;
            }
            case IDM_LOAD:
            {
               if (GetOpenFileName(&rom_file))
               {
                   //first make sure rom_buffer is empty

                   if (rom_buffer) free (rom_buffer);

                   //Load file here

                   fp = fopen(gszOpenName,"rb");

                   if (fp == NULL)
                   {
                      MessageBox (hWnd, "Error loading file", "Error",
                                  MB_OK | MB_ICONINFORMATION);
                      romloaded = FALSE;
                   }
                   else
                   {
                      // reset the offset or face the consequences!
                      rom_offset = 0;

                      rom_length = filelength(fileno(fp));

                      rom_buffer = (unsigned char *)malloc(rom_length);

                      temp_buffer = (unsigned char *)malloc(rom_length);

                      if (rom_buffer == NULL || temp_buffer == NULL)
                      {
                         MessageBox (hWnd, "Error loading file - not enough memory", "Error",
                         MB_OK | MB_ICONINFORMATION);
                         romloaded = FALSE;

                         if (rom_buffer) free (rom_buffer);
                         else if (temp_buffer) free (temp_buffer);
                         memset (rom_buffer, 0, sizeof(rom_buffer));
                      }
                      else
                      {
                         fread(rom_buffer, 1, filelength(fileno(fp)), fp);
                         romloaded = TRUE;
                      }

                      fclose (fp);
                   }

                   //If loading succesful, enable buttons, etc.

//                   SendMessage(hWnd, ACTIVE, IDM_SAVE, FALSE);

                   rom_file.lpstrTitle = gszOpenName;
               }

               break;
            }
            case IDM_LOADPALETTE:
            {
               if (GetOpenFileName(&palette_file))
               {
                   if (LoadPalette(gszPalOpenName) == FALSE)
                   {
                      MessageBox (hWnd, "Error loading Palette", "Error",
                                  MB_OK | MB_ICONINFORMATION);
                   }

                   palette_file.lpstrTitle = gszPalOpenName;
               }
               break;
            }
            case IDM_LOADPLUGIN:
            {
               if (GetOpenFileName(&plugin_file))
               {
                   //Load Plugin file here

//"In run-time dynamic linking, a module uses the LoadLibrary or LoadLibraryEx
//function to load the DLL at run time. After the DLL is loaded, the module
//calls the GetProcAddress function to get the addresses of the exported DLL
//functions. The module calls the exported DLL functions using the function
//pointers returned by GetProcAddress. This eliminates the need for an import
//library."

                   // If another library is in use, free it first
                   if (dllhandle)
                   {
                      FreeLibrary(dllhandle);
                      PluginStartup = NULL;
                      PluginShutdown = NULL;
                      PluginTilePack = NULL;
                      PluginTileUnpack = NULL;
                      PluginUpdate = NULL;
                      PluginSave = NULL;
                      supp_modes = NULL;
                      num_modes = NULL;

                      // reset the offset or face the consequences!
                      rom_offset = 0;
                   }

                   dllhandle = LoadLibrary(gszPluginOpenName);

                   if (dllhandle != NULL)
                   {
                      // dll loaded successfully

                        PluginStartup = (PluginStartupType)
                                        GetProcAddress(dllhandle,
                                                       "PluginStartup");
                        PluginShutdown = (PluginShutdownType)
                                        GetProcAddress(dllhandle,
                                                       "PluginShutdown");
                        PluginTilePack = (PluginTilePackType)
                                        GetProcAddress(dllhandle,
                                                       "PluginTilePack");
                        PluginTileUnpack = (PluginTileUnpackType)
                                        GetProcAddress(dllhandle,
                                                       "PluginTileUnpack");
                        PluginUpdate = (PluginUpdateType)
                                        GetProcAddress(dllhandle,
                                                       "PluginUpdate");
                        PluginSave = (PluginSaveType)
                                        GetProcAddress(dllhandle,
                                                       "PluginSave");

                        supp_modes = (tilemode *)GetProcAddress(dllhandle,
                                                              "supp_modes");
                        num_modes = (unsigned char *)GetProcAddress(dllhandle,
                                                                 "num_modes");

                        if (PluginStartup == NULL || PluginShutdown == NULL ||
                            PluginTilePack == NULL||PluginTileUnpack == NULL||
                            PluginUpdate == NULL || PluginSave == NULL ||
                            supp_modes == NULL || num_modes == NULL)
                        {
                           MessageBox (hWnd, "Error loading Plugin", "Error", MB_OK | MB_ICONINFORMATION);
                           FreeLibrary(dllhandle);
                           pluginloaded = FALSE;
                        }
                        else
                        {
                           pluginloaded = TRUE;
                           TileRows = 320 / supp_modes[curr_mode].w;
                           TileColumns = 160 / supp_modes[curr_mode].h;

                           imp_fnc.WriteString = NULL;
                           imp_fnc.WriteStringF = NULL;
                           imp_fnc.curr_mode = &curr_mode;

                           PluginStartup((imp_func *)&imp_fnc);
                        }
                   }
                   else
                   {
                      // error loading dll
                      MessageBox (hWnd, "Error loading Plugin", "Error", MB_OK | MB_ICONINFORMATION);
                   }

                   plugin_file.lpstrTitle = gszPluginOpenName;
               }
               break;
            }
            case IDM_ABOUT:
            {
               DialogBox(g_hInstance, "AboutDlg", hWnd, (DLGPROC)AboutDlgProc);
               break;
            }
            case IDM_EXIT:
               PostMessage(hWnd, WM_CLOSE, 0, 0);
               break;
         }
         return 0L;
      }
      case WM_GETMINMAXINFO:
      {
         // Fix the size of the window to client size
         pMinMax = (MINMAXINFO *)lParam;
         pMinMax->ptMinTrackSize.x = window_w+GetSystemMetrics(SM_CXSIZEFRAME)*2;
         pMinMax->ptMinTrackSize.y = window_h+GetSystemMetrics(SM_CYSIZEFRAME)*2
                                     +GetSystemMetrics(SM_CYMENU) + GetSystemMetrics(SM_CYCAPTION);
         pMinMax->ptMaxTrackSize.x = pMinMax->ptMinTrackSize.x;
         pMinMax->ptMaxTrackSize.y = pMinMax->ptMinTrackSize.y;
         return 0L;
      }
      case WM_MOVE:
      {
         // Retrieve the window position after a move
         if (g_bActive && g_bReady)
         {
            GetWindowRect(hWnd, &g_rcWindow);
            GetClientRect(hWnd, &g_rcScreen);
            ClientToScreen(hWnd, (POINT *)&g_rcScreen.left);
            ClientToScreen(hWnd, (POINT *)&g_rcScreen.right);
         }

         return 0L;
      }
      case WM_PAINT:
      {
         PAINTSTRUCT ps;

         BeginPaint(hWnd, &ps);
         EndPaint(hWnd, &ps);
         return 0L;
      }
      case WM_TIMER:
      {
         if (TIMER_ID == wParam)
         {
            //now update display

            SIZE size;
            HDC hdc;

            if (g_bReady && pluginloaded == TRUE && romloaded == TRUE )
            {
               int i, i2;

               LockDDSurface (g_pDDSBack);

               if (editmode == FALSE)
               {
                  DrawTiles (rom_offset, 0, 0, TileRows, TileColumns, 
                             rom_buffer, temp_buffer);
               }
               else
               {
                  
               }

               UnlockDDSurface (g_pDDSBack);

               if (g_pDDSBack->GetDC(&hdc) == DD_OK)
               {
                  SetBkColor(hdc, RGB(0, 0, 0));
                  SetTextColor(hdc, RGB(255, 255, 255));

                  sprintf(offset_text, "%8x", rom_offset);
                  GetTextExtentPoint(hdc, offset_text, lstrlen(offset_text), &size);
                  SetTextAlign (hdc, TA_LEFT | TA_TOP);
                  TextOut(hdc, 64 - size.cx,
                          (supp_modes[curr_mode].h * TileColumns),
                          offset_text, 8);
                  g_pDDSBack->ReleaseDC(hdc);
               }

               while (TRUE)
               {

                  hRet = g_pDDSPrimary->Blt(&g_rcScreen, g_pDDSBack,
                                            &g_rcViewport, DDBLT_WAIT,
                                            NULL);

                  if (hRet == DD_OK)
                      break;
                  if (hRet == DDERR_SURFACELOST)
                  {
                     hRet = g_pDDSPrimary->Restore();
                     if (hRet != DD_OK)
                     break;
                  }
                  if (hRet != DDERR_WASSTILLDRAWING)
                  break;
               }
            }
         }
         return 0L;
      }
      case WM_KEYDOWN:
      {
         switch (wParam)
         {
            case 0x51: // Q
            {
               TileRows -= 1;
               break;
            }
            case 0x57: // W
            {
               TileRows += 1;
               break;
            }
            case 0x41: // A
            {
               TileColumns -= 1;
               break;
            }
            case 0x53: // S
            {
               TileColumns += 1;
               break;
            }
            case VK_UP:
            {
               rom_offset -= ((supp_modes[curr_mode].w *
                             supp_modes[curr_mode].h) * TileRows) /
                             (8 / supp_modes[curr_mode].bpp);

               if (rom_offset < 0) rom_offset = 0;
               break;
            }
            case VK_DOWN:
            {
               rom_offset += ((supp_modes[curr_mode].w *
                             supp_modes[curr_mode].h) * TileRows) /
                             (8 / supp_modes[curr_mode].bpp);
                             
               if (rom_offset > (rom_length - ((supp_modes[curr_mode].w *
                   supp_modes[curr_mode].h * TileRows) / (8 /
                   supp_modes[curr_mode].bpp) * TileColumns)))
                   rom_offset = rom_length - ((supp_modes[curr_mode].w *
                                supp_modes[curr_mode].h * TileRows) / (8 /
                                supp_modes[curr_mode].bpp) * TileColumns);
               break;
            }
            case VK_LEFT:
            {
               rom_offset -= (supp_modes[curr_mode].w *
                             supp_modes[curr_mode].h) /
                             (8 / supp_modes[curr_mode].bpp);

               if (rom_offset < 0) rom_offset = 0;
               break;
            }
            case VK_RIGHT:
            {
               rom_offset += (supp_modes[curr_mode].w *
                             supp_modes[curr_mode].h) /
                             (8 / supp_modes[curr_mode].bpp);
                             
               if (rom_offset > (rom_length - ((supp_modes[curr_mode].w *
                   supp_modes[curr_mode].h * TileRows) / (8 /
                   supp_modes[curr_mode].bpp) * TileColumns)))
                   rom_offset = rom_length - ((supp_modes[curr_mode].w *
                                supp_modes[curr_mode].h * TileRows) / (8 /
                                supp_modes[curr_mode].bpp) * TileColumns);
               break;
            }

            case VK_PRIOR: // PAGE UP
            {
               rom_offset -= ((supp_modes[curr_mode].w *
                             supp_modes[curr_mode].h) * TileRows) /
                             (8 / supp_modes[curr_mode].bpp) * TileColumns;
               if (rom_offset < 0) rom_offset = 0;
               break;
            }
            case VK_NEXT: // PAGE DOWN
            {
               rom_offset += ((supp_modes[curr_mode].w *
                             supp_modes[curr_mode].h) * TileRows) /
                             (8 / supp_modes[curr_mode].bpp) * TileColumns;
               if (rom_offset > (rom_length - ((supp_modes[curr_mode].w *
                   supp_modes[curr_mode].h * TileRows) / (8 /
                   supp_modes[curr_mode].bpp) * TileColumns)))
                   rom_offset = rom_length - ((supp_modes[curr_mode].w *
                                supp_modes[curr_mode].h * TileRows) / (8 /
                                supp_modes[curr_mode].bpp) * TileColumns);
               break;
            }
            case VK_HOME:
            {
               rom_offset = 0;
               break;
            }
            case VK_END:
            {
               rom_offset = rom_length - ((supp_modes[curr_mode].w *
                            supp_modes[curr_mode].h * TileRows) / (8 /
                            supp_modes[curr_mode].bpp) * TileColumns);
               break;
            }
            case VK_SUBTRACT:
            {
               rom_offset -= 1;
               if (rom_offset < 0) rom_offset = 0;
               break;
            }
            case VK_ADD:
            {
               rom_offset += 1;
               if (rom_offset > (rom_length - ((supp_modes[curr_mode].w *
                   supp_modes[curr_mode].h * TileRows) / (8 /
                   supp_modes[curr_mode].bpp) * TileColumns)))
                   rom_offset = rom_length - ((supp_modes[curr_mode].w *
                                supp_modes[curr_mode].h * TileRows) / (8 /
                                supp_modes[curr_mode].bpp) * TileColumns);
               break;
            }
            case 0x30: // 0 key
            {
               curr_mode = 0;
               ClearSurface(g_pDDSBack);
               TileRows = 320 / supp_modes[curr_mode].w;
               TileColumns = 160 / supp_modes[curr_mode].h;
               break;
            }
            case 0x31: // 1 key
            {
               if (num_modes[0] > 1)
               curr_mode = 1;
               ClearSurface(g_pDDSBack);
               TileRows = 320 / supp_modes[curr_mode].w;
               TileColumns = 160 / supp_modes[curr_mode].h;
               break;
            }
            case 0x32: // 2 key
            {
               if (num_modes[0] > 2)
               curr_mode = 2;
               ClearSurface(g_pDDSBack);
               TileRows = 320 / supp_modes[curr_mode].w;
               TileColumns = 160 / supp_modes[curr_mode].h;
               break;
            }
            case 0x33: // 3 key
            {
               if (num_modes[0] > 3)
               curr_mode = 3;
               ClearSurface(g_pDDSBack);
               TileRows = 320 / supp_modes[curr_mode].w;
               TileColumns = 160 / supp_modes[curr_mode].h;
               break;
            }
            case 0x34: // 4 key
            {
               if (num_modes[0] > 4)
               curr_mode = 4;
               ClearSurface(g_pDDSBack);
               TileRows = 320 / supp_modes[curr_mode].w;
               TileColumns = 160 / supp_modes[curr_mode].h;
               break;
            }
            case 0x35: // 5 key
            {
               if (num_modes[0] > 5)
               curr_mode = 5;
               ClearSurface(g_pDDSBack);
               TileRows = 320 / supp_modes[curr_mode].w;
               TileColumns = 160 / supp_modes[curr_mode].h;
               break;
            }
            case 0x36: // 6 key
            {
               if (num_modes[0] > 6)
               curr_mode = 6;
               TileRows = 320 / supp_modes[curr_mode].w;
               TileColumns = 160 / supp_modes[curr_mode].h;
               break;
            }
            case 0x37: // 7 key
            {
               if (num_modes[0] > 7)
               curr_mode = 7;
               ClearSurface(g_pDDSBack);
               TileRows = 320 / supp_modes[curr_mode].w;
               TileColumns = 160 / supp_modes[curr_mode].h;
               break;
            }
            case 0x38: // 8 key
            {
               if (num_modes[0] > 8)
               curr_mode = 8;
               ClearSurface(g_pDDSBack);
               TileRows = 320 / supp_modes[curr_mode].w;
               TileColumns = 160 / supp_modes[curr_mode].h;
               break;
            }
            case 0x39: // 9 key
            {
               if (num_modes[0] > 9)
               curr_mode = 9;
               ClearSurface(g_pDDSBack);
               TileRows = 320 / supp_modes[curr_mode].w;
               TileColumns = 160 / supp_modes[curr_mode].h;
               break;
            }

            default: break;
         }
         return 0L;
      }
      case WM_MOUSEMOVE:
      {
         int xPos=0, yPos=0;
//         xPos = GET_X_LPARAM(lParam);
//         yPos = GET_Y_LPARAM(lParam);
         return 0L;
      }
      case WM_MOUSEWHEEL:
      {
         int xPos=0, yPos=0;
         int zDelta=0;

         // Check to make sure the x and y Position of the mouse is over the
         // editing area.

         xPos = (int)LOWORD(lParam);
         yPos = (int)HIWORD(lParam);

         if (xPos >= g_rcScreen.left && xPos < (supp_modes[curr_mode].w * TileRows *
             (window_w / 320)) + g_rcScreen.left &&
             yPos >= g_rcScreen.top && yPos < (supp_modes[curr_mode].h * TileColumns *
             (window_h / 240)) + g_rcScreen.top)
         {
            zDelta = (char)HIWORD(wParam);

            if (zDelta > 0)
            {
               rom_offset -= ((supp_modes[curr_mode].w *
                             supp_modes[curr_mode].h) * TileRows) / 
                             (8 / supp_modes[curr_mode].bpp);

               if (rom_offset < 0) rom_offset = 0;
               break;
            }
            else if (zDelta < 0)
            {
               rom_offset += ((supp_modes[curr_mode].w *
                             supp_modes[curr_mode].h) * TileRows) /
                             (8 / supp_modes[curr_mode].bpp);

               if (rom_offset > (rom_length - ((supp_modes[curr_mode].w *
                   supp_modes[curr_mode].h * TileRows) / (8 /
                   supp_modes[curr_mode].bpp) * TileColumns)))
                   rom_offset = rom_length - ((supp_modes[curr_mode].w *
                                supp_modes[curr_mode].h * TileRows) / (8 /
                                supp_modes[curr_mode].bpp) * TileColumns);
            }
         }
         return 0L;
      }
      case WM_LBUTTONDBLCLK:
      {
         if (editmode == FALSE)
         {
            int xPos=0, yPos=0;

            xPos = (int)LOWORD(lParam);
            yPos = (int)HIWORD(lParam);

//            if (xPos >= g_rcScreen.left && xPos < (supp_modes[curr_mode].w * TileRows) +
//                g_rcScreen.left &&
//                yPos >= g_rcScreen.top && yPos < (supp_modes[curr_mode].h * TileColumns) +
//                g_rcScreen.top)
//             {
               editmode = TRUE;
//            }
         }
         editmode = TRUE;
         return 0L;
      }
      case WM_SIZE:
      {
         // Check to see if we are losing our window...
         if (SIZE_MAXHIDE==wParam || SIZE_MINIMIZED==wParam)
         {
            g_bActive = FALSE;
         }
         else
         {
            g_bActive = TRUE;
         }

         return 0L;
      }
      case WM_DESTROY:
      {
         KillTimer(hWnd, TIMER_ID);
         ReleaseAllObjects(hWnd);
         PostQuitMessage(0);
         return 0L;
      }

    }

    return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

//////////////////////////////////////////////////////////////////////////////

static BOOL InitApp(HWND hWnd, HINSTANCE hInstance, int nCmdShow)
{
    WNDCLASS                    MyWndClass;
    HRESULT                     hRet;
    int                         cx, cy;

    // Set up and register window class
    MyWndClass.style = CS_HREDRAW | CS_VREDRAW;
    MyWndClass.lpfnWndProc = (WNDPROC) WindowProc;
    MyWndClass.cbClsExtra = 0;
    MyWndClass.cbWndExtra = sizeof(DWORD);
    MyWndClass.hInstance = hInstance;
    MyWndClass.hIcon = LoadIcon(hInstance, IDI_APPLICATION);
    MyWndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
    MyWndClass.hbrBackground = (HBRUSH) GetStockObject(BLACK_BRUSH);
    MyWndClass.lpszMenuName = MAKEINTRESOURCE(IDR_MENU);
    MyWndClass.lpszClassName = szClassName;

    if (!RegisterClass(&MyWndClass))
        return FALSE;

    switch (GetSystemMetrics(SM_CXSCREEN))
    {
       case 640:
       {
          window_w = 320;
          window_h = 240;
          scale=1;
          break;
       }
       case 800:
       case 848:
       {
          window_w = 640;
          window_h = 480;
          scale=2;
          break;
       }
       case 1024:
       case 1152:
       case 1280:
       {
          window_w = 960;
          window_h = 720;
          scale=3;
          break;
       }
       case 1600:
       {
          window_w = 1280;
          window_h = 960;
          scale=4;
          break;
       }
       case 1800:
       case 1856:
       {
          window_w = 1600;
          window_h = 1200;
          scale=5;
          break;
       }
       default:
       {
          window_w = 640;
          window_h = 480;
          scale=1;
          break;
       }
    }

    cx = window_w+GetSystemMetrics(SM_CXSIZEFRAME)*2;
    cy = window_h+(GetSystemMetrics(SM_CYSIZEFRAME)*2) + GetSystemMetrics(SM_CYMENU);
   
    // Create a window
    hWnd = CreateWindow(szClassName,        // class
                        szAppName,          // caption
                        WS_OVERLAPPEDWINDOW,// style 
                        CW_USEDEFAULT,      // x pos
                        CW_USEDEFAULT,      // y pos
                        cx,        // width
                        cy,       // height
                        NULL,               // parent window
                        NULL,               // menu 
                        hInstance,          // instance
                        NULL);              // parms

    if (!hWnd)
        return FALSE;

    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);

//    SendMessage(hWnd, TB_ENABLEBUTTON, IDM_SAVE, TRUE);

    GetWindowRect(hWnd, &g_rcWindow);

    hAccel = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDR_MAIN_ACCEL));

    // Create a timer for updating buffer
    if (!SetTimer(hWnd, TIMER_ID, 30, NULL))
    {
       DestroyWindow(hWnd);
       return FALSE;
    }

    hRet = DirectDrawCreateEx(NULL, (VOID **)&g_pDD, IID_IDirectDraw7, NULL);
    if (hRet != DD_OK)
    {
       InitFail(hWnd, hRet, "DirectDrawCreateEx FAILED. Reason: %s", GetErrorDescription(hRet));
    }

    hRet = InitSurfaces(hWnd, 320, 240, 32);
    if (hRet != DD_OK)
    {
       return FALSE;
    }

    g_bReady = TRUE;

    return TRUE;
}


//////////////////////////////////////////////////////////////////////////////

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine, int nCmdShow)
{
    MSG                         msg;
    HWND                        hWnd=NULL;
    FILE *fp2;
    DWORD type, size=256; 
    HKEY key;

    if (!InitApp(hWnd, hInstance, nCmdShow))
        return FALSE;

    memset(&rom_file, 0, sizeof(OPENFILENAME));
    rom_file.lStructSize = sizeof(OPENFILENAME);
    rom_file.hwndOwner = hWnd;
    rom_file.lpstrFilter = "All Files (*.*)\0*.*\0";
    rom_file.lpstrFile = gszOpenName;
    rom_file.nMaxFile = sizeof(gszOpenName);
    rom_file.Flags = OFN_HIDEREADONLY;

    memset(&plugin_file, 0, sizeof(OPENFILENAME));
    plugin_file.lStructSize = sizeof(OPENFILENAME);
    plugin_file.hwndOwner = hWnd;
    plugin_file.lpstrFilter = "Plugins (*.dll)\0*.dll\0All Files (*.*)\0*.*\0";
    plugin_file.lpstrFile = gszPluginOpenName;
    plugin_file.nMaxFile = sizeof(gszPluginOpenName);

    memset(&palette_file, 0, sizeof(OPENFILENAME));
    palette_file.lStructSize = sizeof(OPENFILENAME);
    palette_file.hwndOwner = hWnd;
    palette_file.lpstrFilter = "Palette Files (*.pal)\0*.pal\0All Files (*.*)\0*.*\0";
    palette_file.lpstrFile = gszPalOpenName;
    palette_file.nMaxFile = sizeof(gszPalOpenName);

    gszOpenName[0] = 0;
    gszPluginOpenName[0] = 0;

    // get the initial path from registry

    // Open the appropriate registry key
    LONG result = RegOpenKeyEx(HKEY_CURRENT_USER,
                               TEXT("Software\\CWX\\TNEDIT"),
                               0, KEY_READ, &key);

    if (ERROR_SUCCESS == result)
    {
       result = RegQueryValueEx(key, TEXT("RomFilePath"), NULL,
                                &type, (BYTE *)gszOpenName, &size);

       result = RegQueryValueEx(key, TEXT("PluginFilePath"), NULL,
                                &type, (BYTE *)gszPluginOpenName, &size);

       RegCloseKey(key);
    }

    g_hInstance = hInstance;

    while (GetMessage(&msg, NULL, NULL, NULL))
    {
       if (0 == TranslateAccelerator(hWnd, hAccel, &msg))
       {
          TranslateMessage(&msg);
          DispatchMessage(&msg);
       }
    }

    if (g_pDD)
        g_pDD->Release();

#ifdef DEBUG
    fp2 = fopen ("output.txt", "wb");
    ClientToScreen(hWnd, (POINT *)&g_rcScreen.top);
    fprintf(fp2, "Blt src coordinates: %d %d %d %d\n", g_rcScreen.left, g_rcScreen.right, g_rcScreen.top, g_rcScreen.bottom);
    fprintf(fp2, "Blt dest coordinates: %d %d %d %d\n", g_rcViewport.left, g_rcViewport.right, g_rcViewport.top, g_rcViewport.bottom);
    fprintf(fp2, "Window coordinates: %d %d %d %d\n", g_rcWindow.left, g_rcWindow.right, g_rcWindow.top, g_rcWindow.bottom);
    fprintf(fp2, "width = %d", window_h+GetSystemMetrics(SM_CYSIZEFRAME)*2 +GetSystemMetrics(SM_CYMENU));
    fprintf(fp2, "caption size = %d", GetSystemMetrics(SM_CYCAPTION));
    fclose (fp2);
#endif

    if (rom_buffer)
    {
       free(rom_buffer);
    }

    if (temp_buffer)
    {
       free(temp_buffer);
    }

    PluginShutdown((imp_func *)&imp_fnc);

    // If a plugin was loaded, unload it
    if (dllhandle)
    {
       FreeLibrary(dllhandle);
    }

    if (strcmp(gszOpenName, "") != 0)
    {

       LONG result = RegCreateKeyEx(HKEY_CURRENT_USER,
                                    TEXT("Software\\CWX\\TNEDIT"), 0, NULL,
                                    REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL,
                                    &key, NULL);

       if (result == ERROR_SUCCESS)
       {

          result = RegSetValueEx(key, TEXT("RomFilePath"), 0, REG_SZ,
                                 (BYTE *)gszOpenName, size);

          RegCloseKey(key);
       }
    }

    if (strcmp(gszPluginOpenName, "") != 0)
    {

       LONG result = RegCreateKeyEx(HKEY_CURRENT_USER,
                                    TEXT("Software\\CWX\\TNEDIT"), 0, NULL,
                                    REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL,
                                    &key, NULL);

       if (result == ERROR_SUCCESS)
       {

          result = RegSetValueEx(key, TEXT("PluginFilePath"), 0, REG_SZ,
                                 (BYTE *)gszPluginOpenName, size);

          RegCloseKey(key);
       }
    }

    return (msg.wParam);
}

LRESULT CALLBACK AboutDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam,
                              LPARAM lParam)
{
   switch (uMsg)
   {
      case WM_INITDIALOG:
      {
         return TRUE;
      }
      case WM_COMMAND:
      {
         switch (wParam)
         {
            case IDOK:
            {
               EndDialog(hDlg, TRUE);
               return TRUE;
            }
            default: break;
         }
         break;
      }
   }

   return FALSE;
}

LRESULT CALLBACK SettingsDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam,
                                 LPARAM lParam)
{
   switch (uMsg)
   {
      case WM_INITDIALOG:
      {
         return TRUE;
      }
      case WM_COMMAND:
      {
         switch (wParam)
         {
            case IDOK:
            {
               EndDialog(hDlg, TRUE);
               return TRUE;
            }
            default: break;
         }
         break;
      }
   }

   return FALSE;
}

