#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif

#include <stdio.h>
#include <windows.h>
#include <ddraw.h>

#include "ddutil.h"

DIB dib;

LPDIRECTDRAW7 g_pDD = NULL;                // DirectDraw Object
LPDIRECTDRAWSURFACE7 g_pDDSPrimary = NULL; // DirectDraw Primary surface
LPDIRECTDRAWSURFACE7 g_pDDSBack = NULL;    // DirectDraw Back surface
RECT g_rcWindow;                           // Saves Window Dimensions
RECT g_rcViewport;                         // Pos. & Size to blit from
RECT g_rcScreen;                           // Screen pos. for blit
BOOL g_bActive = FALSE;                    // Is App running/active
BOOL g_bReady = FALSE;                     // Is App ready for updates
unsigned char g_ucSurfaceDepth;     // Bit-depth of surface
DWORD red_mask, green_mask, blue_mask; // color bit masks
LONG g_lSurfacePitch;               // Pitch of surface
unsigned char *g_szSurface;         // Pointer to the actual surface

//////////////////////////////////////////////////////////////////////////////

ReleaseAllObjects(HWND hWnd)
{
   if (g_pDD != NULL)
   {
      g_pDD->SetCooperativeLevel(hWnd, DDSCL_NORMAL);
      if (g_pDDSBack != NULL)
      {
         g_pDDSBack->Release();
         g_pDDSBack = NULL;
      }
      if (g_pDDSPrimary != NULL)
      {
         g_pDDSPrimary->Release();
         g_pDDSPrimary = NULL;
      }
   }
   return DD_OK;
}

//////////////////////////////////////////////////////////////////////////////

char *GetErrorDescription(HRESULT hRet)
{
   switch (hRet)
   {
      case DDERR_ALREADYINITIALIZED:
         return "DDERR_ALREADYINITIALIZED: Object already Initialized";
      case DDERR_BLTFASTCANTCLIP:
         return "DDERR_BLTFASTCANTCLIP";
      case DDERR_CANNOTATTACHSURFACE:
         return "DDERR_CANNOTATTACHSURFACE: Cannot attach surface to another surface";
      case DDERR_CANNOTDETACHSURFACE:
         return "DDERR_CANNOTDETACHSURFACE: Cannot detach surface from another surface";
      case DDERR_CANTCREATEDC:
         return "DDERR_CANTCREATEDC";
      case DDERR_CANTDUPLICATE:
         return "DDERR_CANTDUPLICATE";
      case DDERR_CANTLOCKSURFACE:
         return "DDERR_CANTLOCKSURFACE";
      case DDERR_CANTPAGELOCK:
         return "DDERR_PAGELOCK";
      case DDERR_CANTPAGEUNLOCK:
         return "DDERR_CANTPAGEUNLOCK";
      case DDERR_CLIPPERISUSINGHWND:
         return "DDERR_CLIPPERISUSINGHWND";
      case DDERR_COLORKEYNOTSET:
         return "DDERR_COLORKEYNOTSET";
      case DDERR_CURRENTLYNOTAVAIL:
         return "DDERR_CURRENTLYNOTAVAIL";
      case DDERR_DDSCAPSCOMPLEXREQUIRED:
         return "DDERR_DDSCAPSCOMPLEXREQUIRED";
      case DDERR_DCALREADYCREATED:
         return "DDERR_DCALREADYCREATED";
      case DDERR_DEVICEDOESNTOWNSURFACE:
         return "DDERR_DEVICEDOESNTOWNSURFACE";
      case DDERR_DIRECTDRAWALREADYCREATED:
         return "DDERR_DIRECTDRAWALREADYCREATED";
      case DDERR_EXCEPTION:
         return "DDERR_EXCEPTION";
      case DDERR_EXCLUSIVEMODEALREADYSET:
         return "DDERR_EXCLUSIVEMODEALREADYSET";
      case DDERR_EXPIRED:
         return "DDERR_EXPIRED";
      case DDERR_GENERIC:
         return "DDERR_GENERIC";
      case DDERR_HEIGHTALIGN:
         return "DDERR_HEIGHTALIGN";
      case DDERR_HWNDALREADYSET:
         return "DDERR_HWNDALREADYSET";
      case DDERR_HWNDSUBCLASSED:
         return "DDERR_HWNDSUBCLASSED";
      case DDERR_IMPLICITLYCREATED:
         return "DDERR_IMPLICITLYCREATED";
      case DDERR_INCOMPATIBLEPRIMARY:
         return "DDERR_INCOMPATIBLEPRIMARY";
      case DDERR_INVALIDCAPS:
         return "DDERR_INVALIDCAPS";
      case DDERR_INVALIDCLIPLIST:
         return "DDERR_INVALIDCLIPLIST";
      case DDERR_INVALIDDIRECTDRAWGUID:
         return "DDERR_INVALIDDIRECTDRAWGUID";
      case DDERR_INVALIDMODE:
         return "DDERR_INVALIDMODE";
      case DDERR_INVALIDOBJECT:
         return "DDERR_INVALIDOBJECT";
      case DDERR_INVALIDPARAMS:
         return "DDERR_INVALIDPARAMS";
      case DDERR_INVALIDPIXELFORMAT:
         return "DDERR_INVALIDPIXELFORMAT";
      case DDERR_INVALIDPOSITION:
         return "DDERR_INVALIDPOSITION";
      case DDERR_INVALIDRECT:
         return "DDERR_INVALIDRECT";
      case DDERR_INVALIDSTREAM:
         return "DDERR_INVALIDSTREAM";
      case DDERR_INVALIDSURFACETYPE:
         return "DDERR_INVALIDSURFACETYPE";
      case DDERR_LOCKEDSURFACES:
         return "DDERR_LOCKEDSURFACES";
      case DDERR_MOREDATA:
         return "DDERR_MOREDATA";
      case DDERR_NEWMODE:
         return "DDERR_NEWMODE";
      case DDERR_NO3D:
         return "DDERR_NO3D";
      case DDERR_NOALPHAHW:
         return "DDERR_NOALPHAHW";
      case DDERR_NOBLTHW:
         return "DDERR_NOBLTHW";
      case DDERR_NOCLIPLIST:
         return "DDERR_NOCLIPLIST";
      case DDERR_NOCLIPPERATTACHED:
         return "DDERR_NOCLIPPERATTACHED";
      case DDERR_NOCOLORCONVHW:
         return "DDERR_NOCOLORCONVHW";
      case DDERR_NOCOLORKEY:
         return "DDERR_NOCOLORKEY";
      case DDERR_NOCOLORKEYHW:
         return "DDERR_NOCOLORKEYHW";
      case DDERR_NOCOOPERATIVELEVELSET:
         return "DDERR_NOCOOPERATIVELEVELSET";
      case DDERR_NODC:
         return "DDERR_NODC";
      case DDERR_NODDROPSHW:
         return "DDERR_NODDROPSHW";
      case DDERR_NODIRECTDRAWHW:
         return "DDERR_NODIRECTDRAWHW";
      case DDERR_NODIRECTDRAWSUPPORT:
         return "DDERR_NODIRECTDRAWSUPPORT";
      case DDERR_NODRIVERSUPPORT:
         return "DDERR_NODRIVERSUPPORT";
      case DDERR_NOEMULATION:
         return "DDERR_NOEMULATION";
      case DDERR_NOEXCLUSIVEMODE:
         return "DDERR_NOEXCLUSIVEMODE";
      case DDERR_NOFLIPHW:
         return "DDERR_NOFLIPHW";
      case DDERR_NOFOCUSWINDOW:
         return "DDERR_NOFOCUSWINDOW";
      case DDERR_NOGDI:
         return "DDERR_NOGDI";
      case DDERR_NOHWND:
         return "DDERR_NOHWND";
      case DDERR_NOMIPMAPHW:
         return "DDERR_NOMIPMAPHW";
      case DDERR_NOMIRRORHW:
         return "DDERR_NOMIRRORHW";
      case DDERR_NOMONITORINFORMATION:
         return "DDERR_NOMONITORINFORMATION";
      case DDERR_NONONLOCALVIDMEM:
         return "DDERR_NONONLOCALVIDMEM";
      case DDERR_NOOPTIMIZEHW:
         return "DDERR_NOOPTIMIZEHW";
      case DDERR_NOOVERLAYDEST:
         return "DDERR_NOOVERLAYDEST";
      case DDERR_NOOVERLAYHW:
         return "DDERR_NOOVERLAYHW";
      case DDERR_NOPALETTEATTACHED:
         return "DDERR_NOPALETTEATTACHED";
      case DDERR_NORASTEROPHW:
         return "DDERR_NORASTEROPHW";
      case DDERR_NOROTATIONHW:
         return "DDERR_NOROTATIONHW";
      case DDERR_NOSTEREOHARDWARE:
         return "DDERR_NOSTEREOHARDWARE";
      case DDERR_NOSTRETCHHW:
         return "DDERR_NOSTRETCHHW";
      case DDERR_NOSURFACELEFT:
         return "DDERR_NOSURFACELEFT";
      case DDERR_NOT4BITCOLOR:
         return "DDERR_NOT4BITCOLOR";
      case DDERR_NOT4BITCOLORINDEX:
         return "DDERR_NOT4BITCOLORINDEX";
      case DDERR_NOT8BITCOLOR:
         return "DDERR_NOT8BITCOLOR";
      case DDERR_NOTAOVERLAYSURFACE:
         return "DDERR_NOTAOVERLAYSURFACE";
      case DDERR_NOTEXTUREHW:
         return "DDERR_NOTEXTUREHW";
      case DDERR_NOTFLIPPABLE:
         return "DDERR_NOTFLIPPABLE";
      case DDERR_NOTFOUND:
         return "DDERR_NOTFOUND";
      case DDERR_NOTINITIALIZED:
         return "DDERR_NOTINITIALIZED";
      case DDERR_NOTLOADED:
         return "DDERR_NOTLOADED";
      case DDERR_NOTLOCKED:
         return "DDERR_NOTLOCKED";
      case DDERR_NOTPAGELOCKED:
         return "DDERR_NOTPAGELOCKED";
      case DDERR_NOTPALETTIZED:
         return "DDERR_NOTPALETTIZED";
      case DDERR_NOVSYNCHW:
         return "DDERR_NOVSYNCHW";
      case DDERR_NOZBUFFERHW:
         return "DDERR_NOZBUFFERHW";
      case DDERR_NOZOVERLAYHW:
         return "DDERR_NOZOVERLAYHW";
      case DDERR_OUTOFCAPS:
         return "DDERR_OUTOFCAPS";
      case DDERR_OUTOFMEMORY:
         return "DDERR_OUTOFMEMORY";
      case DDERR_OUTOFVIDEOMEMORY:
         return "DDERR_OUTOFVIDEOMEMORY";
      case DDERR_OVERLAPPINGRECTS:
         return "DDERR_OVERLAPPINGRECTS";
      case DDERR_OVERLAYCANTCLIP:
         return "DDERR_OVERLAYCANTCLIP";
      case DDERR_OVERLAYCOLORKEYONLYONEACTIVE:
         return "DDERR_OVERLAYCOLORKEYONLYONEACTIVE";
      case DDERR_OVERLAYNOTVISIBLE:
         return "DDERR_OVERLAYNOTVISIBLE";
      case DDERR_PALETTEBUSY:
         return "DDERR_PALETTEBUSY";
      case DDERR_PRIMARYSURFACEALREADYEXISTS:
         return "DDERR_PRIMARYSURFACEALREADYEXISTS";
      case DDERR_REGIONTOOSMALL:
         return "DDERR_REGIONTOOSMALL";
      case DDERR_SURFACEALREADYATTACHED:
         return "DDERR_SURFACEALREADYATTACHED";
      case DDERR_SURFACEALREADYDEPENDENT:
         return "DDERR_SURFACEALREADYDEPENDENT";
      case DDERR_SURFACEBUSY:
         return "DDERR_SURFACEBUSY";
      case DDERR_SURFACEISOBSCURED:
         return "DDERR_SURFACEISOBSCURED";
      case DDERR_SURFACELOST:
         return "DDERR_SURFACELOST";
      case DDERR_SURFACENOTATTACHED:
         return "DDERR_SURFACENOTATTACHED";
      case DDERR_TESTFINISHED:
         return "DDERR_TESTFINISHED";
      case DDERR_TOOBIGHEIGHT:
         return "DDERR_TOOBIGHEIGHT";
      case DDERR_TOOBIGSIZE:
         return "DDERR_TOOBIGSIZE";
      case DDERR_TOOBIGWIDTH:
         return "DDERR_TOOBIGWIDTH";
      case DDERR_UNSUPPORTED:
         return "DDERR_UNSUPPORTED";
      case DDERR_UNSUPPORTEDFORMAT:
         return "DDERR_UNSUPPORTEDFORMAT";
      case DDERR_UNSUPPORTEDMASK:
         return "DDERR_UNSUPPORTEDMASK";
      case DDERR_UNSUPPORTEDMODE:
         return "DDERR_UNSUPPORTEDMODE";
      case DDERR_VERTICALBLANKINPROGRESS:
         return "DDERR_VERTICALBLANKINPROGRESS";
      case DDERR_VIDEONOTACTIVE:
         return "DDERR_VIDEONOTACTIVE";
      case DDERR_WASSTILLDRAWING:
         return "DDERR_WASSTILLDRAWING";
      case DDERR_WRONGMODE:
         return "DDERR_WRONGMODE";
      case DDERR_XALIGN:
         return "DDERR_XALIGN";
      default: return "Unknown Error";
   }
}

//////////////////////////////////////////////////////////////////////////////

// In a case where something (DirectX-wise) fails to initialize. Should
// probably be called from within a main plugin or something. Then again,
// it's such a small function, who cares.

HRESULT InitFail(HWND hWnd, HRESULT hRet, LPCTSTR szError,...)
{
   char                        szBuff[128];
   va_list                     vl;

   va_start(vl, szError);
   vsprintf(szBuff, szError, vl);
   ReleaseAllObjects(hWnd);
   MessageBox(hWnd, szBuff, "Error", MB_OK);
   va_end(vl);
   return hRet;
}

//////////////////////////////////////////////////////////////////////////////

HRESULT InitSurfaces(HWND hWnd, int w, int h, unsigned char depth)
{
   HRESULT hRet;
   DDSURFACEDESC2 ddsd;
   DDSCAPS2 ddscaps;
   LPDIRECTDRAWCLIPPER pClipper; // Clipper for Windowed mode
   DDBLTFX ddbltfx;

   // Set our cooperative level
   hRet = g_pDD->SetCooperativeLevel(hWnd, DDSCL_NORMAL);
   if (hRet != DD_OK)
   {
      InitFail(hWnd, hRet, "SetCooperativeLevel FAILED. Reason: %s", GetErrorDescription(hRet));
      return FALSE;
   }

   g_rcViewport.left = 0;
   g_rcViewport.top = 0;
   g_rcViewport.right = w;
   g_rcViewport.bottom = h;

   GetClientRect(hWnd, &g_rcScreen);
   ClientToScreen(hWnd, (POINT *)&g_rcScreen.left);
   ClientToScreen(hWnd, (POINT *)&g_rcScreen.right);

   ZeroMemory(&ddsd, sizeof(ddsd));
   ddsd.dwSize = sizeof (ddsd);
   ddsd.dwFlags = DDSD_CAPS;
   ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
   hRet = g_pDD->CreateSurface(&ddsd, &g_pDDSPrimary, NULL);
   if (hRet != DD_OK)
   {
      InitFail(hWnd, hRet, "CreateSurface FAILED. Reason: %s", GetErrorDescription(hRet));
      return FALSE;
   }

   hRet = g_pDD->CreateClipper(0, &pClipper, NULL);
   if (hRet != DD_OK)
   {
      InitFail(hWnd, hRet, "CreateClipper FAILED. Reason: %s", GetErrorDescription(hRet));
      return FALSE;
   }

   // Associate the Clipper with the Window
   pClipper->SetHWnd(0, hWnd);
   g_pDDSPrimary->SetClipper(pClipper);
   pClipper->Release();
   pClipper = NULL;

   // Get the backbuffer.
   ddsd.dwFlags = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS;
   ddsd.dwWidth = w;
   ddsd.dwHeight = h;
   ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
   hRet = g_pDD->CreateSurface(&ddsd, &g_pDDSBack, NULL);
   if (hRet != DD_OK)
   {
      InitFail(hWnd, hRet, "CreateSurface Back-buffer FAILED. Reason: %s", GetErrorDescription(hRet));
      return FALSE;
   }

   ZeroMemory(&ddbltfx, sizeof(ddbltfx));
   ddbltfx.dwSize = sizeof(ddbltfx);
   ddbltfx.dwFillColor = 0;
   g_pDDSBack->Blt(NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx);

   return DD_OK;
}

//////////////////////////////////////////////////////////////////////////////

BOOL LockDDSurface (LPDIRECTDRAWSURFACE7 dds)
{
   HRESULT hRet;
   DDSURFACEDESC2 ddsd;

   if (dds->IsLost() == DDERR_SURFACELOST)
   {
      dds->Restore();
   }

   ZeroMemory(&ddsd, sizeof(ddsd));
   ddsd.dwSize = sizeof(ddsd);
   hRet = dds->Lock(NULL, &ddsd, DDLOCK_WAIT, NULL);

   if (hRet != DD_OK)
   {
      //InitFail(hWnd, hRet, "Surface Lock FAILED. Reason: %s", GetErrorDescription(hRet));
      return FALSE;
   }

   g_ucSurfaceDepth = ddsd.ddpfPixelFormat.dwRGBBitCount;
   red_mask = ddsd.ddpfPixelFormat.dwRBitMask;
   green_mask = ddsd.ddpfPixelFormat.dwGBitMask;
   blue_mask = ddsd.ddpfPixelFormat.dwBBitMask;
   g_lSurfacePitch = ddsd.lPitch;
   g_szSurface = (unsigned char *)ddsd.lpSurface;

   return TRUE;

}

//////////////////////////////////////////////////////////////////////////////

unsigned int CreateRGB(unsigned char r, unsigned char g, unsigned char b)
{
   unsigned int pixel;
   switch (g_ucSurfaceDepth)
   {
      case 8:
      {
         // unsupported. For now

         break;
      }
      case 16:
      {
         if (red_mask == 0x0000F800 && green_mask == 0x000007E0 &&
             blue_mask == 0x0000001F)
         {
            // RGB 565 16-bit format
            pixel = ((r / 8) << 11) | ((g / 4) << 5) | (b / 8);
         }
         else if (red_mask == 0x00007C00 && green_mask == 0x000003E0 &&
                  blue_mask == 0x0000001F)
         {
            // RGB 555 15/16-bit format
            pixel = ((r / 8) << 10) | ((g / 8) << 5) | (b / 8);
         }
         else
         {                 
            // some other undocumented 15/16-bit format
            pixel = 0;
         }

         break;
      }
      case 24:
      case 32:
      {
         if (red_mask == 0x00FF0000 && green_mask == 0x0000FF00 &&
             blue_mask == 0x000000FF)
         {
            // RGB 24/32-bit format
            pixel = (r<<16) | (g<<8) | (b);
         }
         else if (blue_mask == 0x00FF0000 && green_mask == 0x0000FF00 &&
                  red_mask == 0x000000FF)
         {
            // BGR 24/32-bit format
            pixel = (b<<16) | (g<<8) | (r);
         }
         else
         {
            // some other weird or undocumented 24/32-bit format
            pixel = 0;
         }

         break;
      }
      default:
         pixel = 0;
   }
   return pixel;
}

//////////////////////////////////////////////////////////////////////////////

void plot_pixel(int x, int y, int r, int g, int b)
{
   unsigned int pixel_color;
   int offset;

   pixel_color = CreateRGB(r,g,b);

   switch (g_ucSurfaceDepth)
   {
      case 8:
      {
        // Not functional since CreateRGB doesn't support 8-bit color
        //offset = (y*g_lSurfacePitch + x*1);
        //memcpy(g_szSurface + offset, &pixel_color, 1);
      }
      case 16:
      {
        // Defunct code
        offset = (y*g_lSurfacePitch + x*2);
        memcpy(g_szSurface + offset, &pixel_color, 2);
      }
      case 24:
      {
        offset = (y*g_lSurfacePitch + x*3);
        memcpy(g_szSurface + offset, &pixel_color, 3);

      }
      case 32:
      {
        offset = (y*g_lSurfacePitch + x*4);
        memcpy(g_szSurface + offset, &pixel_color, 4);

      }
   }
}

//////////////////////////////////////////////////////////////////////////////

void UnlockDDSurface (LPDIRECTDRAWSURFACE7 dds)
{
   dds->Unlock(NULL);

   g_ucSurfaceDepth = NULL;
   g_lSurfacePitch = NULL;

   red_mask = NULL;
   green_mask = NULL;
   blue_mask = NULL;
}

//////////////////////////////////////////////////////////////////////////////

void CreateSurface(LPDIRECTDRAWSURFACE7 *lpSource, int xs, int ys)
{
   DDSURFACEDESC2 ddsd;

   ZeroMemory(&ddsd, sizeof(ddsd));
   ddsd.dwSize = sizeof(ddsd);
   ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
   ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
   ddsd.dwWidth = xs;
   ddsd.dwHeight = ys;
   g_pDD->CreateSurface(&ddsd, lpSource, NULL);
}

//////////////////////////////////////////////////////////////////////////////

void LoadBmpToSurface(LPDIRECTDRAWSURFACE7 lpSurface, char *filename, int width, int height)
{
   HBITMAP hBitmap;
   HDC hdcImage;
   HDC hdc;
   BITMAP bm;

   // Load the bitmap file
   hBitmap = (HBITMAP)LoadImage(NULL, filename, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);

   if (lpSurface == NULL || hBitmap == NULL)
       return;
   
   lpSurface->Restore();

   hdcImage = CreateCompatibleDC(NULL);
   SelectObject(hdcImage, hBitmap);

   GetObject(hBitmap, sizeof(bm), &bm);
   width = width == 0 ? bm.bmWidth : width;
   height = height == 0 ? bm.bmHeight : height;

   lpSurface->GetDC(&hdc);
   BitBlt(hdc, 0, 0, width, height, hdcImage, 0, 0, SRCCOPY);
   lpSurface->ReleaseDC(hdc);
   DeleteDC(hdcImage);

   DeleteObject(hBitmap);
}

//////////////////////////////////////////////////////////////////////////////

void ClearSurface(LPDIRECTDRAWSURFACE7 dds)
{
   DDBLTFX ddbltfx;

   ZeroMemory(&ddbltfx, sizeof(ddbltfx));
   ddbltfx.dwSize = sizeof(ddbltfx);
   ddbltfx.dwFillColor = 0;
   dds->Blt(NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx);
}
