// 1BPP
#include <windows.h>
#include "sdk.h"

tilemode supp_modes[] = {
8, 8, 1,
12, 12, 1,  
8, 16, 1,
16, 16, 1,
8, 8, 1, // Byte-swapped/hi-byte first mode
12, 12, 1, // Byte-swapped/hi-byte first mode
16, 16, 1 // Byte-swapped/hi-byte first mode
};

unsigned char num_modes = 7;

imp_func import;

void CALLBACK PluginStartup(imp_func *impfnc)
{
   // Enter your startup code here

   import.WriteString = impfnc->WriteString;
   import.WriteStringF = impfnc->WriteStringF;
   import.curr_mode = impfnc->curr_mode;
}

void CALLBACK PluginShutdown(imp_func *impfnc)
{
   //Put your shutdown code here.
}

int CALLBACK PluginTilePack(unsigned char *dest,const unsigned char *src,int width,int height)
{
   int i;

   if (import.curr_mode[0] >= 4) // Byte swap mode
   {
      switch (width)
      {
         case 16:
         {
            for(i = 0; i < height; i++)
            {
               dest[(i * 2) + 1] = ((src[0] & 1) << 7) | ((src[1] & 1) << 6) |
                                   ((src[2] & 1) << 5) | ((src[3] & 1) << 4) |
                                   ((src[4] & 1) << 3) | ((src[5] & 1) << 2) |
                                   ((src[6] & 1) << 1) | ((src[7] & 1));
               src += 8;
               dest[i * 2] = ((src[0] & 1) << 7) | ((src[1] & 1) << 6) |
                             ((src[2] & 1) << 5) | ((src[3] & 1) << 4) |
                             ((src[4] & 1) << 3) | ((src[5] & 1) << 2) |
                             ((src[6] & 1) << 1) | ((src[7] & 1));
               src += 8;
            }
            break;
         }
      }
   }
   else if (width == 6)
   {
      for(i = 0; i < 9; i++) {
          dest[i] = ((src[0] & 1) << 7) | ((src[1] & 1) << 6) | ((src[2] & 1) << 5) | ((src[3] & 1) << 4) |
                ((src[4] & 1) << 3) | ((src[5] & 1) << 2) | ((src[6] & 1) << 1) | ((src[7] & 1));
         src += 8;
      }
   }
   else if (width == 12)
   {
      for(i = 0; i < (height + 6); i++) {
         dest[i] = ((src[0] & 1) << 7) | ((src[1] & 1) << 6) | ((src[2] & 1) << 5) | ((src[3] & 1) << 4) |
                ((src[4] & 1) << 3) | ((src[5] & 1) << 2) | ((src[6] & 1) << 1) | ((src[7] & 1));
         src += 8;
      }
   }
   else
   {
      for(i = 0; i < (height * (width / 8)); i++) {
         dest[i] = ((src[0] & 1) << 7) | ((src[1] & 1) << 6) | ((src[2] & 1) << 5) | ((src[3] & 1) << 4) |
                   ((src[4] & 1) << 3) | ((src[5] & 1) << 2) | ((src[6] & 1) << 1) | ((src[7] & 1));
         src += 8;
      }
   }

   return width*height;
}

int CALLBACK PluginTileUnpack(unsigned char *dest,const unsigned char *src, int width,int height)
{
   int i, j, pix;

   if (import.curr_mode[0] >= 4) // Byte swap mode
   {
      switch (width)
      {
         case 16:
         {
            for(i = 0; i < height; i++)
            {
               pix = src[i * 2];

               dest += 8;
               for(j = 0; j < 8; j++)
               {
                  dest[j] = (pix >> 7) & 1;
                  pix <<= 1;
               }
               dest -= 8;

               pix = src[(i * 2) + 1];

               for(j = 0; j < 8; j++)
               {
                  dest[j] = (pix >> 7) & 1;
                  pix <<= 1;
               }
               dest += 16;
            }
            break;
         }
         default: break;
      }
   }
   else if (width == 6)
   {
      for(i = 0; i < 9; i++)
      {
         pix = src[i];

         for(j = 0; j < 8; j++)
         {
            dest[j] = (pix >> 7) & 1;
            pix <<= 1;
         }
         dest += 8;
      }
   }
   else if (width == 12)
   {
      for(i = 0; i < (height + 6); i++)
      {
         pix = src[i];

         for(j = 0; j < 8; j++)
         {
            dest[j] = (pix >> 7) & 1;
            pix <<= 1;
         }
         dest += 8;
      }
   }      
   else
   {
      for(i = 0; i < (height * (width / 8)); i++)
      {
         pix = src[i];

         for(j = 0; j < 8; j++)
         {
            dest[j] = (pix >> 7) & 1;
            pix <<= 1;
         }
         dest += 8;
      }
   }

   return height*width/8;
}

int CALLBACK PluginUpdate(unsigned char *screen, void *data, long offset, int width, int height)
{
   return 0;
}

int CALLBACK PluginSave(unsigned char *data, int x, int y, int width, int height)
{
   return 0;
}

