// Lunar 2BPP
#include <windows.h>
#include "sdk.h"

tilemode supp_modes[] = {
8, 8, 2,
8, 16, 2,
12, 12, 2,
16, 16, 2,
};

unsigned char num_modes = 4;

imp_func import;

void CALLBACK PluginStartup(imp_func *impfnc)
{
   // Enter your startup code here

   import.WriteString = impfnc->WriteString;
   import.WriteStringF = impfnc->WriteStringF;
   import.curr_mode = impfnc->curr_mode;
}

void CALLBACK PluginShutdown(imp_func *impfnc)
{
   //Put your shutdown code here.
}

int CALLBACK PluginTilePack(unsigned char *dest,const unsigned char *src,int width,int height)
{
   int i, i2;

   for (i2 = 0; i2 < height; i2++)
   {
      for (i = 0; i < width / 4; i++)
      {
           dest[i] = (src[i * 4] << 6) + (src[(i * 4) + 1] << 4) +
                     (src[(i * 4) + 2] << 2) + src[(i * 4) + 3];
      }
      dest += width / 4;
      src += width;
   }


   return width * height;
}

int CALLBACK PluginTileUnpack(unsigned char *dest,const unsigned char *src, int width,int height)
{
   int i, i2;

   for (i2 = 0; i2 < height; i2++)
   {
      for (i = 0; i < width; i++)
      {
         if ((i % 4) == 0)
         {
            dest[i] = src[i / 4] >> 6;
         }
         else if ((i % 4) == 1)
         {
            dest[i] = src[i / 4] << 2;
            dest[i] >>= 6;
         }
         else if ((i % 4) == 2)
         {
            dest[i] = src[i / 4] << 4;
            dest[i] >>= 6;
         }
         else
         {
            dest[i] = src[i / 4] << 6;
            dest[i] >>= 6;
         }
         
      }
      dest += width;
      src += width / 4;
   }

   return width * height / 4;
}

int CALLBACK PluginUpdate(unsigned char *screen, void *data, long offset, int width, int height)
{
   return 0;
}

int CALLBACK PluginSave(unsigned char *data, int x, int y, int width, int height)
{
   return 0;
}

