#include <stdio.h>
#include <windows.h>
#include <ddraw.h>

#include "plugins\sdk.h"
#include "main.h"
#include "ddutil.h"

//int TileWidth=0;
//int supp_modes[curr_mode].h=0;
char TileRows=0;
char TileColumns=0;
//char TileBPP=0;

typedef struct
{
  unsigned char r;
  unsigned char g;
  unsigned char b;
} pal_conv;

pal_conv pal_table[256] = {
0, 0, 0,
0, 0, 168,
0, 168, 0,
0, 168, 168,
168, 0, 0,
168, 0, 168,
168, 84, 0,
168, 168, 168,
84, 84, 84,
84, 84, 252,
84, 252, 84,
84, 252, 252,
252, 84, 84,
252, 84, 252,
252, 252, 84,
252, 252, 252,
0, 0, 0,
20, 20, 20,
32, 32, 32,
44, 44, 44,
56, 56, 56,
68, 68, 68,
80, 80, 80,
96, 96, 96,
112, 112, 112,
128, 128, 128,
144, 144, 144,
160, 160, 160,
180, 180, 180,
200, 200, 200,
224, 224, 224,
252, 252, 252,
0, 0, 252,
64, 0, 252,
124, 0, 252,
188, 0, 252,
252, 0, 252,
252, 0, 188,
252, 0, 124,
252, 0, 64,
252, 0, 0,
252, 64, 0,
252, 124, 0,
252, 188, 0,
252, 252, 0,
188, 252, 0,
124, 252, 0,
64, 252, 0,
0, 252, 0,
0, 252, 64,
0, 252, 124,
0, 252, 188,
0, 252, 252,
0, 188, 252,
0, 124, 252,
0, 64, 252,
124, 124, 252,
156, 124, 252,
188, 124, 252,
220, 124, 252,
252, 124, 252,
252, 124, 220,
252, 124, 188,
252, 124, 156,
180, 180, 252,
196, 180, 252,
216, 180, 252,
232, 180, 252,
252, 180, 252,
252, 180, 232,
252, 180, 216,
252, 180, 196,
252, 180, 180,
252, 196, 180,
252, 216, 180,
252, 232, 180,
252, 252, 180,
232, 252, 180,
216, 252, 180,
196, 252, 180,
180, 252, 180,
180, 252, 196,
180, 252, 216,
180, 252, 232,
180, 252, 252,
180, 232, 252,
180, 215, 252,
180, 196, 252,
0, 0, 112,
28, 0, 112,
56, 0, 112,
84, 0, 112,
112, 0, 112,
112, 0, 84,
112, 0, 56,
112, 0, 28,
112, 0, 0,
112, 28, 0,
112, 56, 0,
112, 84, 0,
112, 112, 0,
84, 112, 0,
56, 112, 0,
28, 112, 0,
0, 112, 0,
0, 112, 28,
0, 112, 56,
0, 112, 84,
0, 112, 112,
0, 84, 112,
0, 56, 112,
0, 28, 112,
56, 56, 112,
68, 56, 112,
84, 56, 112,
96, 56, 112,
112, 56, 112,
112, 56, 112,
112, 56, 84,
112, 56, 68,
112, 56, 56,
112, 68, 56,
112, 84, 56,
112, 96, 56,
112, 112, 56,
96, 112, 56,
84, 112, 56,
68, 112, 56,
56, 112, 56,
56, 112, 68,
56, 112, 84,
56, 112, 96,
56, 112, 112,
56, 96, 112,
56, 84, 112,
56, 68, 112,
80, 80, 112,
88, 80, 112,
96, 80, 112,
104, 80, 112,
112, 80, 112,
112, 80, 104,
112, 80, 96,
112, 80, 88,
112, 80, 80,
112, 88, 80,
112, 96, 80,
112, 104, 80,
112, 112, 80,
104, 112, 80,
96, 112, 80,
88, 112, 80,
80, 112, 80,
80, 112, 88,
80, 112, 96,
80, 112, 104,
80, 112, 112,
80, 104, 112,
80, 96, 112,
80, 88, 112,
0, 0, 64,
16, 0, 64,
32, 0, 64,
48, 0, 64,
64, 0, 64,
64, 0, 48,
64, 0, 32,
64, 0, 16,
64, 0, 0,
64, 16, 0,
64, 32, 0,
64, 48, 0,
64, 64, 0,
48, 64, 0,
32, 64, 0,
16, 64, 0,
0, 64, 0,
0, 64, 16,
0, 64, 32,
0, 64, 48,
0, 64, 64,
0, 48, 64,
0, 32, 64,
0, 16, 64,
32, 32, 64,
40, 32, 64,
48, 32, 64,
56, 32, 64,
64, 32, 64,
64, 32, 56,
64, 32, 48,
64, 32, 40,
64, 32, 32,
64, 40, 32,
64, 48, 32,
64, 56, 32,
64, 64, 32,
56, 64, 32,
48, 64, 32,
40, 64, 32,
32, 64, 32,
32, 64, 40,
32, 64, 48,
32, 64, 56,
32, 64, 64,
32, 56, 64,
32, 48, 64,
32, 40, 64,
44, 44, 64,
48, 44, 64,
52, 44, 64,
60, 44, 64,
64, 44, 64,
64, 44, 60,
64, 44, 52,
64, 44, 48,
64, 44, 44,
64, 48, 44,
64, 52, 44,
64, 60, 44,
64, 64, 44,
60, 64, 44,
52, 64, 44,
48, 64, 44,
44, 64, 44,
44, 64, 48,
44, 64, 52,
44, 64, 60,
44, 64, 64,
44, 60, 64,
44, 52, 64,
44, 48, 64,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0
};

/*
pal_conv pal_table[256] = {
255, 0, 255,
208, 184, 160,
128, 120, 112,
144, 32, 40,
112, 96, 80,
136, 0, 24,
72, 56, 40,
8, 8, 8,
32, 32, 24,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
0, 0, 0,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255,
255,255,255
};

*/

int LoadPalette(char *filename)
{
   FILE *fp;
   int i;

   fp = fopen(filename, "rb");

   if (fp == NULL)
   {
      return FALSE;
   }

   for (i=0; i < 256; i++)
   {
     if (fread(&pal_table[i].r, 1, 1, fp) != 1) { fclose (fp); return FALSE; }
     if (fread(&pal_table[i].g, 1, 1, fp) != 1) { fclose (fp); return FALSE; }
     if (fread(&pal_table[i].b, 1, 1, fp) != 1) { fclose (fp); return FALSE; }
   }

   fclose (fp);
   return TRUE;
}


int DrawTile(int x, int y, unsigned char *src,
                        unsigned char *dst)
{
   int ret=0;
   int i, i2;

   ret = PluginTileUnpack (dst, src, supp_modes[curr_mode].w, supp_modes[curr_mode].h);

   for (i2 = 0 ; i2 < supp_modes[curr_mode].h; i2++)
   {
      for (i = 0; i < supp_modes[curr_mode].w; i++)
      {

         if (supp_modes[curr_mode].bpp == 16)
         {
//            plot_pixel(x + i, y +i2, dst[(supp_modes[curr_mode].h * i2 + i) * 2],
//                       dst[(supp_modes[curr_mode].h * i2 + i) * 2],
//                       dst[(supp_modes[curr_mode].h * i2 + i) * 2]
         }
         else
         {
            plot_pixel(x + i, y + i2, pal_table[dst[supp_modes[curr_mode].h * i2 + i]].r,
                       pal_table[dst[supp_modes[curr_mode].h * i2 + i]].g,
                      pal_table[dst[supp_modes[curr_mode].h * i2 + i]].b);
         }
      }
   }

   return ret;
}

void DrawTiles (long offset, int x, int y, char columns, char rows, 
                unsigned char *src, unsigned char *dst)
{
      int i, i2;
      int ret;
      src += offset;
      

      for (i2 = 0; i2 < rows; i2++)
      {
         for (i = 0; i < columns; i++)
         {
            ret = DrawTile(x + (i * supp_modes[curr_mode].w), y + (i2 * supp_modes[curr_mode].h), src, dst);
            src += ret;
            dst += supp_modes[curr_mode].w * supp_modes[curr_mode].h;
         }
      }
}


void CheckEditArea ()
{
}

int ExportBMP(char *filename, char *buffer, long offset, long length)
{
   FILE *fp;
   long counter;
   int padding=0; 

   fp = fopen(filename, "wb");

   if (fp == NULL) return FALSE;

   fputs("BM", fp);

   switch (supp_modes[curr_mode].bpp)
   {
      case 1:
      {
      }
      case 2:
      {
      }
      case 4:
      {
      }
      case 8:
      {         
      }
      case 16:
      {
      }
      case 24:
      {
      }
      default: break;
   }


   return TRUE;
}
