/*******************************************************************************
  ENCRSA - Arcturus RSA encoder

  (c) Copyright 2003 Theo Berkau(cwx@softhome.net)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*******************************************************************************/

// Program that encodes an rsa file from a text script

#include <windows.h>
#include <stdio.h>
#include "stringhelper.h"

#define PROG_NAME "ENCRSA"
#define VER_NAME "1.0"
#define COPYRIGHT_YEAR "2003"

FILE *fp;
unsigned char *buffer;
unsigned char *linebuffer;
unsigned char tempstr[256];
static unsigned long num_sections=0;
static unsigned long num_events=0;

//////////////////////////////////////////////////////////////////////////////

void ProgramUsage()
{
   printf("%s v%s - by Cyber Warrior X (c)%s\n", PROG_NAME, VER_NAME, COPYRIGHT_YEAR);
   printf("usage: %s <script filename> <output filename>\n", strlwr(PROG_NAME));
   exit (1);
}

//////////////////////////////////////////////////////////////////////////////

void cleanup()
{
   if (fp) fclose(fp);
   if (buffer) free(buffer);
   if (linebuffer) free(linebuffer);
}

//////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
   char *filename;
   char *output_filename;
   unsigned long f_size=0;
   unsigned long counter=0;
   unsigned long counter2=0;
   unsigned long line_counter=0;
   unsigned long line_length=0;
   unsigned long number=0;
   unsigned long num_size=0;
   unsigned long ret=0;
   unsigned long i=0;
   unsigned long i2=0;

   if (argc < 3)
   {
      ProgramUsage();
   }

   printf("%s v%s - by Cyber Warrior X (c)%s\n", PROG_NAME, VER_NAME, COPYRIGHT_YEAR);

   filename = argv[1];
   output_filename = argv[2];

   if ((fp = fopen(filename, "rb")) == NULL)
   {
      printf("Unable to open %s\n", filename);
      exit(1);
   }

   fseek(fp, 0, SEEK_END);
   f_size = ftell(fp);
   fseek(fp, 0, SEEK_SET);

   if ((buffer = (unsigned char *)malloc(f_size)) == NULL)
   {
      printf("Unable to allocate buffer\n");
      cleanup();
      exit(1);
   }

   fread((void *)buffer, 1, f_size, fp);
   fclose(fp);

   // START OF GRSC LINE

   // Now that we've read in the file, make sure it's a script file
   if ((linebuffer = GrabLine(buffer + counter, f_size - counter, &line_length)) == NULL)
   {
      printf("Error on Line %d\n", line_counter + 1);
      cleanup();
      exit(1);
   }
   else
   {
   
      counter += (nextline(buffer + counter + line_length) + line_length);
      counter2=0;
   }

   if (memcmp(linebuffer, "GRSC", 4) != 0 || line_length < 8)
   {
      printf("Not a script file\n");
      cleanup();
      exit(1);
   }

   // write to output file
   if ((fp = fopen(output_filename, "wb")) == NULL)
   {
      printf("Unable to open %s for writing\n", output_filename);
      cleanup();
      exit(1);
   }

   fwrite((void *)linebuffer, 1, 4, fp);
   counter2 += 4;

   // grab the two variables after GRSC
   number = (unsigned long)GrabLong(linebuffer + counter2, line_length - counter2, &num_size);
   counter2 += num_size;

   if (num_size == 0)
   {
      printf("Error reading numbers on Line %d - offset %x\n", line_counter + 1, counter);
      cleanup();
      exit(1);
   }

   fwrite((void *)&number, 1, 1, fp);

   number = (unsigned long)GrabLong(linebuffer + counter2, line_length - counter2, &num_size);

   if (num_size == 0)
   {
      printf("Error reading numbers on Line %d - offset %x\n", line_counter + 1, counter);
      cleanup();
      exit(1);
   }

   fwrite((void *)&number, 1, 1, fp);
   line_counter++;

   free(linebuffer);
   // END OF GRSC LINE

   // START OF NUMBER OF EVENT SECTIONS LINE
   number = (unsigned long)GrabLong(buffer + counter, f_size - counter, &num_size);
   num_sections = number;

   if (num_size == 0)
   {
      printf("Error reading numbers on Line %d - offset %x\n", line_counter + 1, counter);
      cleanup();
      exit(1);
   }

   fwrite((void *)&number, 1, 4, fp);
   line_counter++;

   counter += nextline(buffer + counter);
   // END OF NUMBER OF EVENT SECTIONS LINE

   // START OF NUMBER OF UNKNOWN NUMBER LINE
   number = (unsigned long)GrabLong(buffer + counter, f_size - counter, &num_size);

   if (num_size == 0)
   {
      printf("Error reading numbers on Line %d - offset %x\n", line_counter + 1, counter);
      cleanup();
      exit(1);
   }

   fwrite((void *)&number, 1, 4, fp);
   line_counter++;

   counter += nextline(buffer + counter);
   // END OF NUMBER OF UNKNOWN NUMBER LINE

   // START OF SECTION DATA (horray!)
   for (i = 0; i < num_sections; i++)
   {
      unsigned char *identifier;
  
      line_counter++;

      if ((identifier = GrabWord(buffer + counter, f_size - counter, &line_length)) == NULL)
      {
         printf("Error on Line %d, offset = %x\n", line_counter + 1, counter);
         cleanup();
         exit(1);
      }
      else
      {
         counter += line_length;
      }

      memcpy(tempstr, identifier, line_length);
      free(identifier);
      fwrite((void *)tempstr, 1, 80, fp);

      // START OF TWO UNKNOWN VALUES
      number = (unsigned long)GrabLong(buffer + counter, f_size - counter, &num_size);

      if (num_size == 0)
      {
         printf("Error reading numbers on Line %d - offset %x\n", line_counter + 1, counter);
         cleanup();
         exit(1);
      }

      fwrite((void *)&number, 1, 4, fp);
      counter += num_size;

      number = (unsigned long)GrabLong(buffer + counter, f_size - counter, &num_size);

      if (num_size == 0)
      {
         printf("Error reading numbers on Line %d - offset %x\n", line_counter + 1, counter);
         cleanup();
         exit(1);
      }

      fwrite((void *)&number, 1, 4, fp);
      counter += num_size;
      // END OF TWO UNKNOWN VALUES

      // START OF SECOND IDENTIFIER

      // There's no guarentee this actually exists. Need to implement some
      // kind of detection
      counter += nextnonspace((buffer + counter));

      if (buffer[counter] != 0x0A && buffer[counter] != 0x0D)
      {
         // assume that it exists
         if ((identifier = GrabWord(buffer + counter, f_size - counter, &line_length)) == NULL)
         {
            printf("Error on Line %d\n", line_counter + 1);
            cleanup();
            exit(1);
         }
         else
         {
            counter += nextline(buffer + counter);
         }

         memcpy(tempstr, identifier, line_length);
         free(identifier);
         fwrite((void *)tempstr, 1, 80, fp);
      }
      else
      {
         memset((void *)tempstr, 0, 256);
         fwrite((void *)tempstr, 1, 80, fp);
         counter += nextline(buffer + counter);
      }

      line_counter++;

      // END OF SECOND IDENTIFIER

      // START OF NUMBER OF EVENTS
      number = (unsigned long)GrabLong(buffer + counter, f_size - counter, &num_size);
      num_events = number;

      if (num_size == 0)
      {
         printf("Error reading numbers on Line %d - offset %x\n", line_counter + 1, counter);
         cleanup();
         exit(1);
      }

      fwrite((void *)&number, 1, 4, fp);

      counter += nextline(buffer + counter);

      line_counter++;
      // END OF NUMBER OF EVENTS

      for (i2 = 0; i2 < num_events; i2++)
      {
         // START OF UNKNOWN 1 & 2
         number = (unsigned long)GrabLong(buffer + counter, f_size - counter, &num_size);

         if (num_size == 0)
         {
            printf("Error reading numbers on Line %d - offset %x\n", line_counter + 1, counter);
            cleanup();
            exit(1);
         }

         fwrite((void *)&number, 1, 4, fp);

         counter += num_size;

         number = (unsigned long)GrabLong(buffer + counter, f_size - counter, &num_size);

         if (num_size == 0)
         {
            printf("Error reading numbers on Line %d - offset %x\n", line_counter + 1, counter);
            cleanup();
            exit(1);
         }

         fwrite((void *)&number, 1, 4, fp);

         counter += nextline(buffer + counter);

         line_counter++;
         // END OF UNKNOWN 1 & 2

         // START OF EVENT COMMAND
         // Now that we've read in the file, make sure it's a script file
         if ((linebuffer = GrabLine(buffer + counter, f_size - counter, &line_length)) == NULL || line_length == 0)
         {
            printf("Error on Line %d, offset = %x\n", line_counter + 1, counter);
            cleanup();
            exit(1);
         }
         else
         {
         
            counter += (nextline(buffer + counter + line_length) + line_length);
         }

         line_length += 1;
         fwrite((void *)&line_length, 1, 4, fp);
         fwrite((void *)linebuffer, 1, line_length, fp);
         free(linebuffer);

         line_counter++;
         // END OF EVENT COMMAND
      }
   }
   // END OF SECTION DATA

   cleanup ();

   printf("done\n");

   return 0;
}

//////////////////////////////////////////////////////////////////////////////

