// All sorts of annoying functions that make my life easier
#include <windows.h>
#include <stdio.h>
#include "util.h"

#define SLASH_STR "\\"
#define SLASH_CHAR '\\'

//////////////////////////////////////////////////////////////////////////////

void _makepath (char *path, const char *drive, const char *dir,
		const char *fname, const char *ext)
{
    if (drive && *drive)
    {
	*path = *drive;
	*(path + 1) = ':';
	*(path + 2) = 0;
    }
    else
	*path = 0;
	
    if (dir && *dir)
    {
	strcat (path, dir);
        if (strlen (dir) != 1 || *dir != '\\')
            strcat (path, SLASH_STR);
    }
	
    strcat (path, fname);
    if (ext && *ext)
    {
        strcat (path, ".");
        strcat (path, ext);
    }
}

//////////////////////////////////////////////////////////////////////////////

void _splitpath (const char *path, char *drive, char *dir, char *fname,
		 char *ext)
{
    if (*path && *(path + 1) == ':')
    {
	*drive = toupper (*path);
	path += 2;
    }
    else
	*drive = 0;

    char *slash = strrchr (path, SLASH_CHAR);
    if (!slash)
	slash = strrchr (path, '/');
    char *dot = strrchr (path, '.');
    if (dot && slash && dot < slash)
	dot = NULL;

    if (!slash)
    {
        if (*drive)
            strcpy (dir, "\\");
        else
            strcpy (dir, "");
	strcpy (fname, path);
        if (dot)
        {
	    *(fname + (dot - path)) = 0;
	    strcpy (ext, dot + 1);
        }
	else
	    strcpy (ext, "");
    }
    else
    {
        if (*drive && *path != '\\')
        {
            strcpy (dir, "\\");
            strcat (dir, path);
            *(dir + (slash - path) + 1) = 0;
        }
        else
        {
            strcpy (dir, path);
            if (slash - path == 0)
                *(dir + 1) = 0;
            else
                *(dir + (slash - path)) = 0;
        }

	strcpy (fname, slash + 1);
        if (dot)
	{
	    *(fname + (dot - slash) - 1) = 0;
    	    strcpy (ext, dot + 1);
	}
	else
	    strcpy (ext, "");
    }
}

//////////////////////////////////////////////////////////////////////////////

int round(float x)
{
   if (x - ((int)x) <  0.5)
   {
      return((int)x);
   }
   else
   {
      return ((int)(x+1));
   }
}

//////////////////////////////////////////////////////////////////////////////

unsigned short WordSwap(unsigned short data)
{
   return (((data & 0xFF00) >> 8) + ((data & 0x00FF) << 8));
}

//////////////////////////////////////////////////////////////////////////////

unsigned long DoubleWordSwap(unsigned long data)
{
   return (((data & 0xFF000000) >> 24) +
          ((data & 0x00FF0000) >> 8) +
          ((data & 0x0000FF00) << 8) + 
          ((data & 0x000000FF) << 24));
}

//////////////////////////////////////////////////////////////////////////////
