/*******************************************************************************
  DECRSA - Arcturus RSA decoder

  (c) Copyright 2003 Theo Berkau(cwx@softhome.net)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*******************************************************************************/

#include <windows.h>
#include <stdio.h>
#include "util.h"

#define PROG_NAME "DECRSA"
#define VER_NAME "1.0"
#define COPYRIGHT_YEAR "2003"

FILE *fp;
unsigned char *buffer;
char outpath[MAXPATH];
char outdrive[MAXDRIVE];
char outdir[MAXDIR];
char outfile[MAXFILE];
char outext[MAXEXT];
char tempstr[256];

//////////////////////////////////////////////////////////////////////////////

void ProgramUsage()
{
   printf("%s v%s - by Cyber Warrior X (c)%s\n", PROG_NAME, VER_NAME, COPYRIGHT_YEAR);
   printf("usage: %s <rsa filename>\n", strlwr(PROG_NAME));
   exit (1);
}

//////////////////////////////////////////////////////////////////////////////

void cleanup()
{
   if (fp) fclose(fp);
   if (buffer) free(buffer);
}

//////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
   char *filename;
   unsigned long f_size=0;
   unsigned long counter=0;
   unsigned long *temp_pointer;
   unsigned long num_events;
   unsigned long num_commands;
   unsigned long i, i2;

   if (argc < 2)
   {
      ProgramUsage();
   }

   printf("%s v%s - by Cyber Warrior X(c)%s\n", PROG_NAME, VER_NAME, COPYRIGHT_YEAR);

   filename = argv[1];

   if ((fp = fopen(filename, "rb")) == NULL)
   {
      printf("Unable to open %s\n", filename);
      exit(1);
   }

   fseek(fp, 0, SEEK_END);
   f_size = ftell(fp);
   fseek(fp, 0, SEEK_SET);

   if ((buffer = (unsigned char *)malloc(f_size)) == NULL)
   {
      printf("Unable to allocate buffer\n");
      cleanup();
      exit(1);
   }

   fread((void *)buffer, 1, f_size, fp);
   fclose(fp);

   // Now that we've read in the file, let's grab the header and make sure
   // it's an rsa file

   if (memcmp(buffer, "GRSC", 4) != 0)
   {
      printf("Not an RSA file\n");
      cleanup();
      exit (1);
   }

   // now let's generate our script file
   _splitpath (filename, outdrive, outdir, outfile, outext);
   _makepath (outpath, "", "", outfile, "txt");

   if ((fp = fopen(outpath, "wb")) == NULL)
   {
      printf("Unable to open %s for writing\n", outpath);
      cleanup();
      exit (1);
   }

   // write GRSC
   fwrite((void *)(buffer + counter), 1, 4, fp);
   counter += 4;

   // write the two unknown numbers(byte sized) after GRSC
   fprintf(fp, " %d %d\n", buffer[counter], buffer[counter + 1]);
   counter += 2;

   // Number of events(long value)
   temp_pointer = (unsigned long *)(buffer + counter);
   fprintf(fp, "%d\n", temp_pointer[0]);
   num_events = temp_pointer[0];
   counter += 4;

   // Another unknown single number(long value)
   temp_pointer = (unsigned long *)(buffer + counter);
   fprintf(fp, "%d\n", temp_pointer[0]);
   counter += 4;

   // now do the events
   for (i2 = 0; i2 < num_events; i2++)
   {
      fprintf(fp, "\n");

      // write the first 80 bytes(seems to be an identifier)
      memset(tempstr, 0, 256);
      memcpy(tempstr, (buffer + counter), 80);
      fprintf(fp, "%s ", tempstr);
      counter += 80;

      // grab the two numbers that appear after the identifier
      temp_pointer = (unsigned long *)(buffer + counter);
      fprintf(fp, "%d %d ", temp_pointer[0], temp_pointer[1]);
      counter += 8;

      // write the last 80 bytes(seems to be a second identifier)
      memset(tempstr, 0, 256);
      memcpy(tempstr, (buffer + counter), 80);
      if (tempstr[0] != 0x00)
         fprintf(fp, "%s", tempstr);
      fprintf(fp, "\n", tempstr);
      counter += 80;

      // do the number of commands
      temp_pointer = (unsigned long *)(buffer + counter);
      fprintf(fp, "%d\n", temp_pointer[0]);
      num_commands = temp_pointer[0];
      counter += 4;

      for (i = 0; i < num_commands; i++)
      {
         unsigned long command_size=0;

         // first the two unknown values(coordinates or delay?)
         temp_pointer = (unsigned long *)(buffer + counter);
         fprintf(fp, "%d %d\n", temp_pointer[0], temp_pointer[1]);

         // grab the command size
         command_size = temp_pointer[2];
         counter += 12;

         // now do the actual command
         fprintf(fp, "%s\n", (buffer + counter));
         counter += command_size;
      }
   }

   cleanup();

   printf("done.\n");

   return 0;
}

//////////////////////////////////////////////////////////////////////////////



