#include <windows.h>
#include <stdio.h>
#include "stringhelper.h"

//////////////////////////////////////////////////////////////////////////////

unsigned long linelen(unsigned char *buf)
{
   char searchstring[3];

   searchstring[0] = 0x0D;
   searchstring[1] = 0x0A;
   searchstring[2] = 0x00;

   return (unsigned long)(strcspn((char *)buf, searchstring));
}

//////////////////////////////////////////////////////////////////////////////

unsigned long nextline(unsigned char *buf)
{
   char searchstring[3];
   unsigned long temp_long=0;

   searchstring[0] = 0x0D;
   searchstring[1] = 0x0A;
   searchstring[2] = 0x00;

   if (buf[0] != 0x0D || buf[0] != 0x0A)
   {
       temp_long = strcspn((char *)buf, searchstring);
   }

   return (unsigned long)(strspn((char *)buf + temp_long, searchstring) + temp_long);
}

//////////////////////////////////////////////////////////////////////////////

unsigned long wordlen(unsigned char *buf)
{
   char searchstring[4];

   searchstring[0] = 0x20;
   searchstring[1] = 0x0D;
   searchstring[2] = 0x0A;
   searchstring[3] = 0x00;

   return (unsigned long)(strcspn((char *)buf, searchstring));
}


//////////////////////////////////////////////////////////////////////////////

unsigned long nextnumber(unsigned char *buf)
{
   char searchstring[4];

   searchstring[0] = 0x20;
   searchstring[1] = 0x0D;
   searchstring[2] = 0x0A;
   searchstring[3] = 0x00;

   return (unsigned long)(strspn((char *)buf, searchstring));
}

//////////////////////////////////////////////////////////////////////////////

unsigned long numberlen(unsigned char *buf)
{
   char searchstring[2];

   searchstring[0] = 0x20;
   searchstring[1] = 0x00;

   return (unsigned long)(strcspn((char *)buf, searchstring));
}

//////////////////////////////////////////////////////////////////////////////

unsigned long nextnonspace(unsigned char *buf)
{
   char searchstring[2];

   searchstring[0] = 0x20;
   searchstring[1] = 0x00;

   return (unsigned long)(strspn((char *)buf, searchstring));
}

//////////////////////////////////////////////////////////////////////////////

unsigned char *GrabLine(unsigned char *buf, unsigned long buf_size, unsigned long *linebuf_size)
{
   unsigned long line_length=0;
   unsigned long counter=0;
   unsigned char *linebuf;

   // find the line length
   if ((line_length = linelen(buf)) > (buf_size))
   {
      // EOF error
      linebuf_size[0] = 0;
      return NULL;
   }

#ifdef DEBUG
   printf("line length = %d\n", line_length);
#endif

   // allocate line buffer
   if ((linebuf = (unsigned char *)malloc(line_length + 1)) == NULL)
   {
      // allocation error
      linebuf_size[0] = 0;
      return NULL;
   }

   // copy the string to it
   memset(linebuf, 0, line_length + 1);
   memcpy(linebuf, buf, line_length);

   // set linebuf_size to it's size
   linebuf_size[0] = line_length;

   // find the start of the next line
   if ((counter = nextline(buf + counter + line_length) + line_length) > buf_size)
   {
      // EOF error
      linebuf_size[0] = 0;
      return NULL;
   }

#ifdef DEBUG
   printf("start of second line at offset %x\n", counter);
#endif

   return linebuf;
}

//////////////////////////////////////////////////////////////////////////////

long GrabLong(unsigned char *buf, unsigned long buf_size, unsigned long *number_size)
{
   unsigned long number_length=0;
   unsigned long counter=0;
   char *numbuf;
   long ret;

   // find the number start
   if ((counter = nextnumber(buf)) > (buf_size))
   {
      // EOB error
      number_size[0] = 0;
      return 0;
   }   

#ifdef DEBUG
   printf("number start = %x\n", counter);
#endif

   // find the number length
   if ((number_length = numberlen(buf + counter)) > (buf_size))
   {
      // EOB error
      number_size[0] = 0;
      return 0;
   }   

#ifdef DEBUG
   printf("number length = %d\n", number_length);
#endif

   // allocate number buffer
   if ((numbuf = (char *)malloc(number_length + 1)) == NULL)
   {
      // allocation error
      number_size[0] = 0;
      return NULL;
   }

   // copy the string to it
   memset(numbuf, 0, number_length + 1);
   memcpy(numbuf, (buf + counter), number_length);

   // set linebuf_size to it's size
   counter += number_length;
   number_size[0] = counter;

   ret = atoi (numbuf);

//   printf("counter = %d\n", counter);
//   printf("number string = %s\n", numbuf);
#ifdef DEBUG
   printf("number = %d\n", ret);
#endif

   free (numbuf);

   return (ret);
}

//////////////////////////////////////////////////////////////////////////////

unsigned char *GrabWord(unsigned char *buf, unsigned long buf_size, unsigned long *wordbuf_size)
{
   unsigned long word_length=0;
   unsigned long counter=0;
   unsigned char *wordbuf;

   // find the word length
   if ((word_length = wordlen(buf)) > (buf_size))
   {
      // EOF error
      wordbuf_size[0] = 0;
      return NULL;
   }

#ifdef DEBUG
   printf("word length = %d\n", word_length);
#endif

   // allocate line buffer
   if ((wordbuf = (unsigned char *)malloc(word_length + 1)) == NULL)
   {
      // allocation error
      wordbuf_size[0] = 0;
      return NULL;
   }

   // copy the string to it
   memset(wordbuf, 0, word_length + 1);
   memcpy(wordbuf, buf, word_length);

   // find next non-space
   counter = nextnumber(buf + word_length) + word_length;

   // set wordbuf_size to it's size
   wordbuf_size[0] = counter;

   return wordbuf;
}

//////////////////////////////////////////////////////////////////////////////

