// SCR file inserter
#include <stdio.h>

typedef struct
{
    unsigned long offset; // in new data
    unsigned long new_offset;
    unsigned long orig_pointer;
    unsigned long new_pointer;
} pointers;

pointers point_list[99];

unsigned char num_pointers=0;

int main(int argc, char *argv[])
{
   FILE *fp;
   FILE *fp2;
   FILE *output_fp;
   unsigned char *buffer;
   unsigned char *buffer2;
   unsigned char buffer3[200000];
   unsigned char temp_buffer[255];
   unsigned long counter=0, counter2=0, counter3=0;
   unsigned long f_size=0, f_size2=0;
   unsigned char bleh2[4] = { 0x07, 0x84, 0x03, 0x01};
   unsigned char bleh3[3] = { 0x00, 0x00, 0x00};
   int i;

   if (argc < 4)
   {
      printf("usage: encode <input filename original> <input filename translated> <output filename>\n");
      exit (1);
   }

   // load original script

   fp = fopen (argv[1], "rb");

   if (fp == NULL)
   {
      printf("Couldn't open %s\n", argv[1]);
      exit (1);
   }

   fseek(fp, 0, SEEK_END);
   f_size = ftell(fp) + 1;
   fseek(fp, 0, SEEK_SET);

   buffer = (unsigned char *)malloc(f_size);

   if (buffer == NULL)
   {
      printf("Couldn't create buffers\n");
      fclose(fp);

      if (buffer) free (buffer);

      exit (1);
   }

   fread ((void *)buffer, f_size, 1, fp);
   fclose (fp);

   // open translated text

   fp2 = fopen (argv[2], "rb");

   if (fp2 == NULL)
   {
      printf("Couldn't open %s\n", argv[2]);

      free (buffer);

      exit (1);
   }

   fseek(fp2, 0, SEEK_END);
   f_size2 = ftell(fp2) + 1;
   fseek(fp2, 0, SEEK_SET);

   buffer2 = (unsigned char *)malloc(f_size2);

   if (buffer2 == NULL)
   {
      printf("Couldn't create buffers\n");

      fclose(fp2);
      free (buffer);

      if (buffer) free (buffer);

      exit (1);
   }

   fread ((void *)buffer2, f_size2, 1, fp2);
   fclose (fp2);

   output_fp = fopen (argv[3], "wb");

   if (output_fp == NULL)
   {
      printf("Couldn't open %s\n", argv[3]);

      free (buffer);
      free (buffer2);

      exit (1);
   }

   while (counter < (f_size - 1))
   {
      if(num_pointers > 0)
      {
         for (i = 0; i < num_pointers; i++)
         {
            if (point_list[i].orig_pointer == counter)
            {
               point_list[i].new_pointer = counter3;
//               printf("Match for pointer #%x at: %x %x\n", i, counter, counter3);
            }
         }
      }

      if (buffer[counter] == 0x07)
      {
         if (buffer[counter + 1] == 0x84)
         {
            // Figure out the length of the original's dialogue so we won't
            // overwrite anything else

            // We're dealing with dialogue text
            unsigned char length=0;
            unsigned long diag_counter=0;
            unsigned char diag_size=0;
//            unsigned short endline=0x0A0D;

            length = buffer[counter + 4];

//            printf("%02x %02x %02x %02x - ", buffer[counter + 1], buffer[counter + 2], buffer[counter + 3], buffer[counter + 4]);
//            printf("%02x\n", length);

            // Now make sure original dialogue and translated text match
            // in placement


//            printf("%02x %02x %02x %02x %02x %02x %02x = %02x %02x %02x %02x %02x %02x %02x - %02x",
//                   buffer[counter + 8], buffer[counter + 9], buffer[counter + 10],
//                   buffer[counter + 11], buffer[counter + 12], buffer[counter + 13],
//                   buffer[counter + 14],
//                   buffer2[counter2], buffer2[counter2 + 1], buffer2[counter2 + 2],
//                   buffer2[counter2 + 3], buffer2[counter2 + 4],
//                   buffer2[counter2 + 5], buffer2[counter2 + 6],
//                   counter);


            if (buffer[counter + 8] == buffer2[counter2] &&
                buffer[counter + 9] == buffer2[counter2 + 1] &&
                buffer[counter + 10] == buffer2[counter2 + 2] &&
                buffer[counter + 11] == buffer2[counter2 + 3] &&
                buffer[counter + 12] == buffer2[counter2 + 4] &&
                buffer[counter + 13] == buffer2[counter2 + 5] &&
                buffer[counter + 14] == buffer2[counter2 + 6])
            {
               unsigned char temp_char=0xFF;

               // Ok! We're good to go!

               // Calculate the length of the new text

               for (;;)
               {
                  // do \n checking here

                  if (buffer2[counter2 + diag_counter] == '\\' &&
                      buffer2[counter2 + diag_counter + 1] == 'n')
                  {
                     temp_buffer[diag_size] = buffer2[counter2 + diag_counter];
                     temp_buffer[diag_size + 1] = buffer2[counter2 + diag_counter + 1];

                     diag_counter += 1;
                     diag_size += 2;
                  }
                  else if (buffer2[counter2 + diag_counter] == '<' &&
                           buffer2[counter2 + diag_counter + 1] == '$' &&
                           buffer2[counter2 + diag_counter + 2] == '5' &&
                           buffer2[counter2 + diag_counter + 3] == 'C' &&
                           buffer2[counter2 + diag_counter + 4] == '6' &&
                           buffer2[counter2 + diag_counter + 5] == 'E' &&
                           buffer2[counter2 + diag_counter + 6] == '>')
                  {
                     temp_buffer[diag_size] = '\\';
                     temp_buffer[diag_size + 1] = 'n';

                     diag_counter += 6;
                     diag_size += 2;
                  }
                  else if (buffer2[counter2 + diag_counter] == 0x0D ||
                           buffer2[counter2 + diag_counter] == 0x0A)
                  {
                     break;
                  }
                  else
                  {
                     temp_buffer[diag_size] = buffer2[counter2 + diag_counter];
                     diag_size++;
                  }

                  diag_counter++;
                  if ((diag_counter + counter2) > f_size2) break;
               }
            
//               printf(" - %02x %02x %02x %02x - %02x %02x\n", diag_counter, counter2, counter2 + diag_counter + 2, diag_size, counter, 8 + length);

               // Now that we've done that, it's basically time to write
               // our new dialogue!

               // header part one
               memcpy(buffer3 + counter3, (void *)&bleh2, 4);
               counter3 += 4;

               // now the dialogue size
               buffer3[counter3] = diag_size;
               counter3 += 1;

               // padding(that I know of!)
               memcpy(buffer3 + counter3, (void *)&bleh3, 3);
               counter3 += 3;

               // write the dialogue
               memcpy(buffer3 + counter3, temp_buffer, diag_size);
               counter3 += diag_size;

               // write 0xFF for good measure
               buffer3[counter3] = 0xFF;
               counter3 += 1;
            }

            counter += 8 + length;
            counter2 += diag_counter + 2;
         }
         else
         {
            buffer3[counter3] = buffer[counter];
            counter3 += 1;
         }
      }
      else if (buffer[counter] == 0x02)
      {
         if (buffer[counter + 1] == 0x13 || buffer[counter + 1] == 0x12 ||
             buffer[counter + 1] == 0x0F)
         {
            // We're dealing with a pointer

            num_pointers +=1;

            point_list[num_pointers - 1].offset = counter + 3;
            point_list[num_pointers - 1].new_offset = counter3 + 3;
            point_list[num_pointers - 1].orig_pointer =
                     buffer[counter + 3] +  (buffer[counter + 4] << 8) +
                    (buffer[counter + 5] << 16) + (buffer[counter + 6] << 24);

            // see if the pointed address is lower than the location of the
            // pointer. If it is, we have to scan through the whole file
            // again just to find it.

            if (point_list[num_pointers - 1].offset >
                point_list[num_pointers - 1].orig_pointer)
            {
               unsigned long counter4=0;
               int nomatch=0;

               while (!nomatch && counter4 < counter3)
               {
                  // try to match up to 12 bytes(that -should- be good enough)
                  if (buffer3[counter4] == buffer[point_list[num_pointers - 1].orig_pointer] &&
                      buffer3[counter4 + 1] == buffer[point_list[num_pointers - 1].orig_pointer + 1] &&
                      buffer3[counter4 + 2] == buffer[point_list[num_pointers - 1].orig_pointer + 2] &&
                      buffer3[counter4 + 3] == buffer[point_list[num_pointers - 1].orig_pointer + 3] &&
                      buffer3[counter4 + 4] == buffer[point_list[num_pointers - 1].orig_pointer + 4] &&
                      buffer3[counter4 + 5] == buffer[point_list[num_pointers - 1].orig_pointer + 5])
//                      buffer3[counter4 + 6] == buffer[counter + 6] &&
//                      buffer3[counter4 + 7] == buffer[counter + 7] &&
//                      buffer3[counter4 + 8] == buffer[counter + 8] &&
//                      buffer3[counter4 + 9] == buffer[counter + 9] &&
//                      buffer3[counter4 + 10] == buffer[counter + 10] &&
//                      buffer3[counter4 + 11] == buffer[counter + 11])
                  {
                     nomatch = 1;
                  }

                  counter4++;
               }


               point_list[num_pointers - 1].new_pointer = counter4 - 1;
            }

            // write the header(automatically writes the rest)

            memcpy(buffer3 + counter3, buffer + counter, 2);
            counter += 1;
            counter3 += 2;
         }
         else
         {
            buffer3[counter3] = buffer[counter];
            counter3 += 1;
         }
      }
      else
      {
         buffer3[counter3] = buffer[counter];
         counter3 += 1;
      }

      counter++;
   }

   if(num_pointers > 0)
   {
      for (i = 0; i < num_pointers; i++)
      {
         memcpy(buffer3 + point_list[i].new_offset, (void *)&point_list[i].new_pointer, 4);
//         printf("old offset: %x new offset: %x old pointer: %x new pointer: %x\n", point_list[i].offset, point_list[i].new_offset, point_list[i].orig_pointer, point_list[i].new_pointer);
      }
   }

   fwrite((void *)buffer3, counter3, 1, output_fp);

   fclose (output_fp);
   free (buffer);
   free (buffer2);
}
