#include <stdio.h>

char char_id[9];
char filename[16];
unsigned long offset;
long offset2; // value that everything after inserted file has to be
              // offset by
unsigned long endoffset;
unsigned long num_files;
unsigned long orig_size;
unsigned long new_size;

unsigned long offset_list[0x0540 + 1];

int main(int argc, char *argv[])
{
   FILE *fp;
   FILE *insert_fp;
   FILE *output_fp;
   unsigned long counter;
   unsigned char *buffer;
   unsigned long whichfile;
   unsigned long i;
   char done=0;

   if (argc < 4)
   {
      printf("usage: pacencode <input pac filename> <output pac filename> <file to insert>\n");
      exit (1);
   }

   fp = fopen(argv[1], "rb");

   if (fp == NULL)
   {
      printf("Cannot find file: %s\n", argv[1]);
      fclose (fp);
   }

   fread((void *)char_id, 1, 9, fp);

   if (strcmp(char_id, "PAC_FILE") != 0)
   {
     printf("not a pac file\n");
     fclose (fp);
     exit (1);
   }

   fread((void *)&num_files, 4, 1, fp);

   counter = ftell(fp);

   while (!done)
   {
      fread((void *)filename, 1, 16, fp);

      if (strcmp(filename, argv[3]) != 0)
      {
         if (counter < (num_files * 20) + 0xD)
         {
            counter += 20;
            fseek(fp, counter, SEEK_SET);
         }
         else
         {
            printf("Couldn't find file in %s\n", argv[1]);
            exit (1);
         }
      }
      else
      {
         printf("match at: %x\n", counter);
         done=1;
      }
   }

   fread((void *)&offset, 4, 1, fp);
   offset+=4;
   printf("start offset: %x\n", offset);

   whichfile = (counter - 13) / 20;

   printf("file num = %x\n", whichfile);

   if (whichfile ==  num_files -1)
   {
      unsigned long temp_long;

      temp_long = ftell(fp);

      fseek(fp, 0, SEEK_END);
      endoffset = ftell(fp);

      fseek(fp, temp_long, SEEK_SET);
   }
   else
   {
      fseek(fp, 16, SEEK_CUR);
      fread((void *)&endoffset, 4, 1, fp);
      endoffset += 4;
   }

   printf("end offset: %x\n", endoffset);

   orig_size = endoffset - offset;
   printf("Original file size: %x\n", orig_size);

   insert_fp = fopen(argv[3], "rb");

   if (insert_fp == NULL)
   {
      printf("Unable to open file: %s\n", argv[3]);
      fclose(fp);
      exit(1);
   }

   fseek(insert_fp, 0, SEEK_END);
   new_size = ftell(insert_fp);
   fseek(insert_fp, 0, SEEK_SET);

   printf("New file size: %x\n", new_size);
   offset2 = new_size - orig_size;
   printf("Offset everything after by: %x\n", offset2);

   // open file to write to

   output_fp = fopen(argv[2], "wb");

   if (output_fp == NULL)
   {
      printf("Unable to open file \"%s\" to write\n", argv[2]);
      fclose(fp);
      fclose(insert_fp);
      exit(1);
   }

   buffer = (unsigned char *)malloc(1000000);

   if (buffer == NULL)
   {
      printf("Not enough memory to perform actions\n");
      fclose(fp);
      fclose(insert_fp);
      fclose(output_fp);

      exit(1);
   }

   memset(buffer, 0, 1000000);
   memset(offset_list, 0, num_files + 1);

   fseek(fp, 0, SEEK_SET);
   fread((void *)buffer, 1, 13 + (num_files * 20), fp);

   fwrite((void *)buffer, 1, 13, output_fp);

   for (i = 0; i < whichfile + 1; i++)
   {
      offset_list[i] = buffer[(i * 20) + 13 + 16] +
                      (buffer[(i * 20) + 13 + 17] << 8) +
                      (buffer[(i * 20) + 13 + 18] << 16) + 
                      (buffer[(i * 20) + 13 + 19] << 24);

      fwrite((void *)buffer + 13 + (i * 20), 1, 20, output_fp);
   }

   for (i = whichfile + 1; i < num_files + 1; i++)
   {
      unsigned long temp_long;

      offset_list[i] = buffer[13 + (i * 20) + 16] +
                      (buffer[13 + (i * 20) + 17] << 8) +
                      (buffer[13 + (i * 20) + 18] << 16) + 
                      (buffer[13 + (i * 20) + 19] << 24);

      temp_long = offset_list[i];
      temp_long += offset2;
      offset_list[i] += 4;

      fwrite((void *)buffer + 13 + (i * 20), 1, 16, output_fp);
      fwrite((void *)&temp_long, 4, 1, output_fp);
   }

   fseek(output_fp, -20, SEEK_CUR);

   fseek(fp, 0, SEEK_END);
   offset_list[num_files] = ftell(fp);
   fseek(fp, 0, SEEK_SET);

   for(i = 0; i < whichfile; i++)
   {
      fseek(fp, offset_list[i] + 4, SEEK_SET);
      fread((void *)buffer, 1, offset_list[i + 1] - offset_list[i], fp);
//      printf("offset %x offset2 %x\n", offset_list[i], offset_list[i + 1]);
      fwrite((void *)buffer, 1, offset_list[i + 1] - offset_list[i], output_fp);
   }

   // write insert file

   fread((void *)buffer, 1, new_size, insert_fp);
   fwrite((void *)buffer, 1, new_size, output_fp);

   for (i = whichfile + 1; i < num_files; i++)
   {
      fseek(fp, offset_list[i], SEEK_SET);
      fread((void *)buffer, 1, offset_list[i + 1] - offset_list[i], fp);
      fwrite((void *)buffer, 1, offset_list[i + 1] - offset_list[i], output_fp);
   }   

   free (buffer);
   free (offset_list);

   fclose (fp);
   fclose (insert_fp);
   fclose (output_fp);

   return 0;
}
