// pac file parser (essentially does a search through the pac file
//                  the same way the real fsym.exe program does, though
//                  it instead writes it to the specified file)

// start tracing at 44714b

#include <stdio.h>

void decompress_data(unsigned char *buffer, unsigned char *output_buffer,
                     unsigned long size1, unsigned long size2);

char char_id[9];
char filename[16];
unsigned long offset;
unsigned long endoffset;
unsigned long num_files;
unsigned long comp_size;
unsigned long uncomp_size;
char iel1[4];

int main(int argc, char *argv[])
{
   FILE *fp;
   FILE *output_fp;
   unsigned long counter;
   unsigned char *buffer;
   unsigned char *output_buffer;
   char done=0;

   if (argc < 3)
   {
      printf("usage: pacparse <pac filename> <file to extract>\n");
      exit (1);
   }

   fp = fopen(argv[1], "rb");

   if (fp == NULL)
   {
      printf("Cannot find file: %s\n", argv[1]);
      fclose (fp);
   }

   fread((void *)char_id, 1, 9, fp);

   if (strcmp(char_id, "PAC_FILE") != 0)
   {
     printf("not a pac file\n");
     fclose (fp);
     exit (1);
   }

   fread((void *)&num_files, 4, 1, fp);

   counter = ftell(fp);

   while (!done)
   {
      fread((void *)filename, 1, 16, fp);

      if (strcmp(filename, argv[2]) != 0)
      {
         if (counter < (num_files * 20) + 0xD)
         {
            counter += 20;
            fseek(fp, counter, SEEK_SET);
         }
         else
         {
            printf("Couldn't find file\n");
            exit (1);
         }
      }
      else
      {
         printf("match at: %x\n", counter);
         done=1;
      }
   }

   fread((void *)&offset, 4, 1, fp);
   offset+=4;
   printf("start offset: %x\n", offset);

   if (((counter - 13) / 20 ) ==  num_files -1)
   {
      unsigned long temp_long;

      temp_long = ftell(fp);

      fseek(fp, 0, SEEK_END);
      endoffset = ftell(fp);

      fseek(fp, temp_long, SEEK_SET);
   }
   else
   {
      fseek(fp, 16, SEEK_CUR);
      fread((void *)&endoffset, 4, 1, fp);
      endoffset += 4;
   }

   printf("end offset: %x\n", endoffset);

   // find out if "IEL1" is present in the file

   fseek(fp, offset, SEEK_SET);
   fread((void *)iel1, 1, 4, fp);

   if (strcmp(iel1, "IEL1") != 0)
   {
      printf("not compressed\n");
      fclose (fp);
      exit (1);
   }
   else
   {
      // IEL1 seems to be a compression tag. Next 4 bytes is the uncompressed
      // file's size. Afterwards is the compressed data

      fread((void *)&uncomp_size, 4, 1, fp);

      output_buffer = (unsigned char *)malloc(uncomp_size);

      if (output_buffer == NULL)
      {
         printf("Error: Unable to create memory buffers\n");
         fclose(fp);
         exit (1);
      }

      // figure out the compressed data's size

      comp_size = endoffset - offset - 8;

      // create a buffer to store compressed data

      buffer = (unsigned char *)malloc(comp_size);

      if (buffer == NULL)
      {
         printf("Error: Unable to create memory buffers\n");
         free(output_buffer);
         fclose(fp);
         exit (1);
      }

      // copy over data
      fread((void *)buffer, 1, comp_size, fp);

      // close original file
      fclose (fp);

      // decompress data
      decompress_data(buffer, output_buffer, comp_size - 1, uncomp_size);

      output_fp = fopen(argv[2], "wb");
      fwrite((void *)output_buffer, 1, uncomp_size, output_fp);
      fclose(output_fp);
      free(output_buffer);
      free(buffer);
   }

   return 0;
}

void decompress_data(unsigned char *buffer, unsigned char *output_buffer,
                     unsigned long size1, unsigned long size2)
{
   unsigned long control_data=0;
   unsigned long temp_data2=0;
   unsigned long temp_data3=0;

   unsigned long cmp1=0;
   unsigned long cmp2=0;
   unsigned long cmp3=0;

   unsigned long counter=0, counter2=0, counter3=0xFEE;
   int done=0;
   unsigned char temp_buffer[0xFFF];

   memset(temp_buffer, 0, 0xFFF);

   while(!done)
   {
      if (!(control_data & 256))
      {
         // read in initial control byte
         control_data = buffer[counter];
         control_data |= 0xFF00; // setup counter 
         counter++;
      }

      // do decoding here
      temp_data2 = buffer[counter];

      counter++;

      if (counter > size1) done = 1;

      if (control_data & 1) // raw uncompressed data
      {
//         printf("offset: %x raw data: %x\n", counter2, temp_data2);

         output_buffer[counter2] = temp_data2;
         counter2++;

         temp_buffer[counter3 & 0xFFF] = temp_data2;
         counter3++;

         control_data >>= 1;
      }
      else // compressed..
      {
         temp_data3 = buffer[counter];
         counter++;

         if (counter > size1) done = 1;

//         printf("temp_data3 = %x\n", temp_data3);

         cmp1 = temp_data3;

         temp_data3 &= 0xF;
         cmp1 &= 0xF0;

         cmp1 <<= 4;

         temp_data2 |= cmp1;

         temp_data3 += 2;

         // jump if signed? If what is signed?

         temp_data3 += 1;

         while (temp_data3 != 0) // copy over <cmp1> amount of bytes
         {
            // get data from 0x4A4578 and copy it to the next byte(what is
            // 0x4a4578?) Just add 0 for now

            temp_buffer[counter3 & 0xFFF] = temp_buffer[temp_data2 & 0xFFF];
            output_buffer[counter2] = temp_buffer[temp_data2 & 0xFFF];

            counter2 += 1;
            counter3 += 1;
            temp_data2 += 1;

            temp_data3 -= 1;
    
//            printf("temp_data2(eax) = %x\n", temp_data2);
//            printf("temp_data3(ecx) = %x\n", temp_data3);
//            printf("cmp1(edi) = %x\n", cmp1);
         }

         control_data >>= 1;
      }   
   }
}

