// Font compression

#include <stdio.h>

unsigned char buffer[1000000]; // uncompressed tiles
unsigned char buffer2[100000]; // compressed data
unsigned char buffer3[0xBC0]; // compressed data pointers

unsigned long EncodeChar(unsigned short char_num, unsigned char * in_buffer, unsigned buffer2_offset);

#define VER_NAME "0.1"

void ProgramUsage();

///////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
   FILE *fp;
   FILE *output_fp;
   char *filename;
   unsigned long f_size;
   int i;
   unsigned long comp_size=0;

   if (argc != 2)
   {
      ProgramUsage();
      exit (1);
   }

   printf ("GRFNTENC v%s - by Cyber Warrior X (c)2002\n", VER_NAME);

   filename = argv[1];

   fp = fopen (filename, "rb");

   if (fp == NULL)
   {
      printf("unable to open file\n");
      exit (1);
   }

   // grab the file size
   fseek(fp, 0, SEEK_END);
   f_size = ftell(fp);
   fseek(fp, 0, SEEK_SET);

   if (f_size != 192512)
   {
      printf("Error: File size is not equal to 192,512. Calculated size = %d\n", f_size);
      fclose (fp);
      exit (1);
   }

   // copy file to buffer
   fread((void *)buffer, 1, f_size, fp);
   fclose(fp);

   printf("compressing font...\n");

   for (i = 0; i < (0xBC0 / 2); i++)
   {
      buffer3[(i * 2)] = ((comp_size + 0xBC0) & 0xFF00) >> 8;
      buffer3[(i * 2) + 1] = ((comp_size + 0xBC0) & 0x00FF);

      comp_size += EncodeChar(i, buffer + (16 * 16 / 2) * i, comp_size);
   }

   output_fp = fopen("test.out", "wb");

   if (output_fp == NULL)
   {
      printf("unable to open file for writing\n");
      exit (1);
   }

   fwrite((void *)buffer3, 1, 0xBC0, output_fp);
   fwrite((void *)buffer2, 1, comp_size, output_fp);
   fclose(output_fp);

   printf("done.");
}

///////////////////////////////////////////////////////////////////////////////

unsigned long EncodeChar(unsigned short char_num, unsigned char *in_buffer, unsigned buffer2_offset)
{
   unsigned long old_line_data=0;
   unsigned long line_data=0;
   unsigned short comp_data=0;
   unsigned long comp_size=0;
   unsigned long comp_size2=0;
   int i, i2;
   unsigned char xor_byte=0;

   comp_size += 4;

   // first half
   for (i = 0; i < 16; i++)
   {
      line_data = (in_buffer[i * 4] << 24) +
                  (in_buffer[i * 4 + 1] << 16) +
                  (in_buffer[i * 4 + 2] << 8) +
                  (in_buffer[i * 4 + 3]);

      // may have to change this
      if (i == 15)
      {
         old_line_data = 0x00000000;
         xor_byte = 0x00;
      }

      if (i == 0)
      {
         if (line_data != 0)
         {
            unsigned char temp_byte=0;

            comp_data |= 0x1;

            for (i2 = 0; i2 < 8; i2++)
            {
               if ((line_data & (0xF << (i2 * 4))) >> (i2 * 4) == 0xF)
               {
                  temp_byte |= 0x80;
               }

               if (i2 != (8 - 1))
                  temp_byte >>= 1;
            }

            xor_byte ^= temp_byte;

            buffer2[buffer2_offset + comp_size] = xor_byte;

            xor_byte = temp_byte;

            comp_size += 1;
         }
      }
      else
      {
         if (line_data != old_line_data)
         {
            unsigned char temp_byte=0;

            comp_data |= 0x1;

            for (i2 = 0; i2 < 8; i2++)
            {
               if ((line_data & (0xF << (i2 * 4))) >> (i2 * 4) == 0xF)
               {
                  temp_byte |= 0x80;
               }

               if (i2 != (8 - 1))
                  temp_byte >>= 1;
            }

            xor_byte ^= temp_byte;

            buffer2[buffer2_offset + comp_size] = xor_byte;

            xor_byte = temp_byte;

            comp_size += 1;
         }
      }

      if (i != 16 - 1)
        comp_data <<= 1;

      old_line_data = line_data;
   }

   // copy data to header buffer
   buffer2[buffer2_offset] = (comp_data & 0xFF00) >> 8;
   buffer2[buffer2_offset + 1] =  comp_data & 0x00FF;

   // second half

   // clear variables
   comp_data = 0x0000;
   xor_byte = 0x00;
   line_data = 0x00000000;
   old_line_data = 0x00000000;

   for (i = 0; i < 16; i++)
   {
      line_data = (in_buffer[((8 * 16) / 2) + (i * 4)] << 24) +
                  (in_buffer[((8 * 16) / 2) + (i * 4) + 1] << 16) +
                  (in_buffer[((8 * 16) / 2) + (i * 4) + 2] << 8) +
                   in_buffer[((8 * 16) / 2) + (i * 4) + 3];

      // may have to change this
      if (i == 15)
      {
         old_line_data = 0x00000000;
         xor_byte = 0x00;
      }

      if (i == 0)
      {
         if (line_data != 0)
         {
            unsigned char temp_byte=0;

            comp_data |= 0x1;

            for (i2 = 0; i2 < 8; i2++)
            {
               if ((line_data & (0xF << (i2 * 4))) >> (i2 * 4) == 0xF)
               {
                  temp_byte |= 0x80;
               }

               if (i2 != (8 - 1))
                  temp_byte >>= 1;
            }

            xor_byte ^= temp_byte;

            buffer2[buffer2_offset + comp_size + comp_size2] = xor_byte;

            xor_byte = temp_byte;

            comp_size2 += 1;
         }
      }
      else
      {
         if (line_data != old_line_data)
         {
            unsigned char temp_byte=0;

            comp_data |= 0x1;

            for (i2 = 0; i2 < 8; i2++)
            {
               if ((line_data & (0xF << (i2 * 4))) >> (i2 * 4) == 0xF)
               {
                  temp_byte |= 0x80;
               }

               if (i2 != (8 - 1))
                  temp_byte >>= 1;
            }

            xor_byte ^= temp_byte;

            buffer2[buffer2_offset + comp_size + comp_size2] = xor_byte;

            xor_byte = temp_byte;

            comp_size2 += 1;
         }
      }

      if (i != 16 - 1)
         comp_data <<= 1;

      old_line_data = line_data;
   }

   buffer2[buffer2_offset + 2] = (comp_data & 0xFF00) >> 8;
   buffer2[buffer2_offset + 3] =  comp_data & 0x00FF;

   return (comp_size + comp_size2);
}

///////////////////////////////////////////////////////////////////////////////

void ProgramUsage()
{
   printf ("GRFNTDMP v%s - by Cyber Warrior X (c)2002\n", VER_NAME);
   printf ("usage: grfntdmp [filename].ext\n");
}

///////////////////////////////////////////////////////////////////////////////

