// Font decompression(reverse engineered from asm)

#include <stdio.h>

unsigned char buffer[100000];
unsigned char buffer2[1000000];

void DecodeChar(unsigned short char_num, unsigned char *out_buffer);
unsigned long DecodeByte(unsigned long value);

#define VER_NAME "1.0"

void ProgramUsage();

///////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
   FILE *fp;
   FILE *output_fp;
   char *filename;
   unsigned long f_size;
   int i;

   if (argc != 2)
   {
      ProgramUsage();
      exit (1);
   }

   printf ("GRFNTDMP v%s - by Cyber Warrior X (c)2002\n", VER_NAME);

   filename = argv[1];

   fp = fopen (filename, "rb");

   if (fp == NULL)
   {
      printf("unable to open file\n");
      exit (1);
   }

   // grab the file size
   fseek(fp, 0, SEEK_END);
   f_size = ftell(fp) - 1;
   fseek(fp, 0, SEEK_SET);

   // copy file to buffer
   fread((void *)buffer, 1, f_size, fp);
   fclose(fp);

   printf("decompressing font...\n");

   for (i = 0; i < (0xBC0 / 2); i++)
   {
      DecodeChar(0x20 + i, buffer2 + (16 * 16 / 2) * i);
   }

   output_fp = fopen("test.out", "wb");

   if (output_fp == NULL)
   {
      printf("unable to open file for writing\n");
      exit (1);
   }

   fwrite((void *)buffer2, 1, (16 * 16 / 2) * (0xBC0 / 2), output_fp);
   fclose(output_fp);

   printf("done.");
}

///////////////////////////////////////////////////////////////////////////////

void DecodeChar(unsigned short char_num, unsigned char *out_buffer) // 0x0601DBFE
{
   int done=0;
   unsigned long offset1=0;
   unsigned long offset2=0;
   unsigned long cmp_hdr=0;
   unsigned char counter=0;
   unsigned long decomp_out=0;
   unsigned long dec_byte=0;
   unsigned long temp_long=0;

   offset1 = (buffer[(0xA00 + ((char_num - 0x20) << 1))] << 8) +
              buffer[(0xA00 + ((char_num - 0x20) << 1)) + 1];
   offset1 += 0xA00;


   cmp_hdr = (buffer[offset1] << 24) +
             (buffer[offset1 + 1] << 16) +
             (buffer[offset1 + 2] << 8) +
              buffer[offset1 + 3];

   dec_byte = buffer[offset1 + 3];

   offset1 += 4;

   counter = 0xF;

   while (!done)
   {
      if (0x7 == (0x7 & counter))
      {
         temp_long = 0;
      }

      if (cmp_hdr & 0x80000000)
      {
         // grab another byte
         dec_byte = buffer[offset1];
         offset1++;

         temp_long = dec_byte ^ temp_long;
      }

      cmp_hdr <<= 1;

      decomp_out = DecodeByte(temp_long);

      out_buffer[offset2] = (decomp_out & 0xFF000000) >> 24;
      out_buffer[offset2 + 1] = (decomp_out & 0x00FF0000) >> 16;
      out_buffer[offset2 + 2] = (decomp_out & 0x0000FF00) >> 8;
      out_buffer[offset2 + 3] = (decomp_out & 0x000000FF);
      offset2 += 4;

      if ((0x7 & (counter & 0x0000FFFF)) == 0)
      {
         temp_long = 0;
      }


      if (cmp_hdr & 0x80000000)
      {
         // grab another byte
         dec_byte = buffer[offset1];
         offset1++;

         temp_long = dec_byte ^ temp_long;
      }

      cmp_hdr <<= 1;

      decomp_out = DecodeByte(temp_long);
     
      out_buffer[offset2] = (decomp_out & 0xFF000000) >> 24;
      out_buffer[offset2 + 1] = (decomp_out & 0x00FF0000) >> 16;
      out_buffer[offset2 + 2] = (decomp_out & 0x0000FF00) >> 8;
      out_buffer[offset2 + 3] = (decomp_out & 0x000000FF);
      offset2 += 4;

      if (counter != 0)
      {
         counter -= 1;
      }
      else
      {
         done = 1;
      }
   }
}

///////////////////////////////////////////////////////////////////////////////

unsigned long DecodeByte(unsigned long value) // 0x0601DD56
{
   unsigned long counter=0;
   unsigned long dec_long=0;
   unsigned long temp_long2=0;
   unsigned long work_long=0;

   work_long = value;

   for (;;)
   {
      dec_long <<= 2;
      dec_long <<= 2;

      if (0x80 & (work_long & 0xFF))
      {
         temp_long2 = 0xF0;

         temp_long2 >>= 2;
         temp_long2 >>= 2;
      }
      else
      {
         temp_long2 = 0xF0;
      }

      temp_long2 = 0xF & temp_long2;
      dec_long = temp_long2 | dec_long;

      work_long <<= 1;

      counter++;

      dec_long <<= 2;
      dec_long <<= 2;

      if (0x80 & (work_long & 0xFF))
      {
         temp_long2 = 0xF0;

         temp_long2 >>= 2;
         temp_long2 >>= 2;
      }
      else
      {
         temp_long2 = 0xF0;
      }

      temp_long2 = 0xF & temp_long2;
      dec_long = temp_long2 | dec_long;

      work_long <<= 1;

      counter++;

      dec_long <<= 2;
      dec_long <<= 2;

      if (0x80 & (work_long & 0xFF))
      {
         temp_long2 = 0xF0;

         temp_long2 >>= 2;
         temp_long2 >>= 2;
      }
      else
      {
         temp_long2 = 0xF0;
      }

      temp_long2 = 0xF & temp_long2;
      dec_long = temp_long2 | dec_long;

      work_long <<= 1;

      counter++;

      dec_long <<= 2;
      dec_long <<= 2;

      if (0x80 & (work_long & 0xFF))
      {
         temp_long2 = 0xF0;

         temp_long2 >>= 2;
         temp_long2 >>= 2;
      }
      else
      {
         temp_long2 = 0xF0;
      }

      temp_long2 = 0xF & temp_long2;
      dec_long = temp_long2 | dec_long;

      work_long <<= 1;

      counter++;

      if (8 > counter)
      {
         continue;
      }
      else
      {
         break;
      }
   }

   return dec_long;

}

///////////////////////////////////////////////////////////////////////////////

void ProgramUsage()
{
   printf ("GRFNTDMP v%s - by Cyber Warrior X (c)2002\n", VER_NAME);
   printf ("usage: grfntdmp [filename].ext\n");
}

///////////////////////////////////////////////////////////////////////////////

