#include <stdio.h>

#define MAX_SCRIPTS 20
#undef DEBUG

unsigned long entries = 0;

typedef struct
{
   unsigned char *value;
   unsigned char size;
} dict_struct;

dict_struct dictionary[0xA000];

int FreeDictionary ()
{
   int i;

   for (i = 0; i < 0xA000; i++)
   {
      if (dictionary[i].value)
          free(dictionary[i].value);
   }
}

void DumpChunk(FILE *input_fp, FILE *output_fp, unsigned long start, unsigned long end);

int LoadDictionary (FILE *fp, long offset1, long offset2)
{
   int i;
   int done=0;
   unsigned char temp_byte;
   unsigned char size;

   fseek(fp, offset2, SEEK_SET);

   for (i = 0x400; i < 0x4EF; i++)
   {
      while(!done)
      {
         fread ((void *)&temp_byte, 1, 1, fp);

         if (temp_byte == 0x00)
         {
            done = 1;
         }
         else
         {
            size++;
         }
      }

      dictionary[i].value = (unsigned char *)malloc(size);
      if (dictionary[i].value == NULL)
      {
         return -1;
      }
      dictionary[i].size = size;

      fseek(fp, -(size + 1), SEEK_CUR);
      fread ((void *)dictionary[i].value, size, 1, fp);
      fseek (fp, 1, SEEK_CUR);

      size = 0;
      done = 0;
   }

   fseek(fp, offset1, SEEK_SET);

   for (i = 0x900; i < 0x9EF; i++)
   {
      while(!done)
      {
         fread ((void *)&temp_byte, 1, 1, fp);

         if (temp_byte == 0x00)
         {
            done = 1;
         }
         else
         {
            size++;
         }
      }

      dictionary[i].value = (unsigned char *)malloc(size);
      if (dictionary[i].value == NULL)
      {
         return -1;
      }
      dictionary[i].size = size;

      fseek(fp, -(size + 1), SEEK_CUR);
      fread ((void *)dictionary[i].value, size, 1, fp);
      fseek (fp, 1, SEEK_CUR);

      size = 0;
      done = 0;
   }

   return 0;
}     


void printuse()
{
        printf("Use: dump1 <ScriptNum> InputFileName OutputFileName\n");
        printf("  Script number must be a valid positive integer from [0-%d]\n", MAX_SCRIPTS);
        printf("  Ex: dump1 1 data.bin script.sjs\n");
	exit(1);
}

int main(int argc, char *argv[])
{
   unsigned long start=0, end=0;
   char *input_filename;
   char *output_filename;
   FILE *input_fp;
   FILE *output_fp;
   int last = 0;
   int begin = 1;
   char script_num=-1;
   unsigned char *temp_chunk;
   unsigned long chunk_offset=0;
   unsigned long offset1=0;
   unsigned long offset2=0;
   unsigned char temp_offset[4];

   if(argc < 4)                                                     
   printuse();
   script_num = atoi(argv[1]);
   input_filename = argv[2];
   output_filename = argv[3];

   if (script_num < 0 || script_num > MAX_SCRIPTS)
   {
      printf("Invalid script number\n");
      exit (1);
   }

   // Main program

   input_fp = fopen(input_filename, "rb");
   if(!input_fp)
   {
      printf("Could not open input file\n");

      exit(1);
   }

   output_fp = fopen(output_filename, "wb");
   if(!output_fp)
   {
      printf ("Could not open output file\n");

      fclose (input_fp);
      exit(1);
   }

   // Figure out the starting offsets of the dictionaries

   fseek(input_fp, script_num * 4, SEEK_SET);
   fread((void *)temp_offset, 1, 4, input_fp);
   chunk_offset = (temp_offset[0] << 24) + (temp_offset[1] << 16) +
             (temp_offset[2] << 8) + temp_offset[3];

#ifdef DEBUG
   printf("main pointer =%08x\n", chunk_offset);
#endif

   fseek(input_fp, chunk_offset + 8, SEEK_SET);
   fread((void *)temp_offset, 1, 4, input_fp);
   offset1 = (temp_offset[0] << 24) + (temp_offset[1] << 16) +
             (temp_offset[2] << 8) + temp_offset[3];

   // Dictionary 0x900-0x9EF
   fseek(input_fp, chunk_offset + offset1 + 4, SEEK_SET);
   fread((void *)temp_offset, 1, 4, input_fp);
   chunk_offset += offset1;
   offset1 = (temp_offset[0] << 24) + (temp_offset[1] << 16) +
             (temp_offset[2] << 8) + temp_offset[3];
   offset1 += chunk_offset + 1;

   // Dictionary 0x400-0x4EF

   fseek(input_fp, chunk_offset + 16, SEEK_SET);
   fread((void *)temp_offset, 1, 4, input_fp);
   offset2 = (temp_offset[0] << 24) + (temp_offset[1] << 16) +
             (temp_offset[2] << 8) + temp_offset[3];
   offset2 += chunk_offset - 17;

   LoadDictionary(input_fp, offset1, offset2);

   if(fseek(input_fp, sizeof(char)*start, SEEK_SET) != 0)
   {
      printf("Could not set start offset");

      fclose(output_fp);
      fclose(input_fp);
      exit(1);
   }

   fprintf(output_fp, "Langrisser DE(Lang1) dumper\n\n");
   fprintf(output_fp, "Cyber Warrior X\n");
   fprintf(output_fp, "\n");

   // Dump Menu's, etc. with the script

   // Figure out start address
   fseek(input_fp, chunk_offset, SEEK_SET);
   fread((void *)temp_offset, 1, 4, input_fp);
   start = (temp_offset[0] << 24) + (temp_offset[1] << 16) +
             (temp_offset[2] << 8) + temp_offset[3];
   start += chunk_offset;

   // Figure out end address

   fseek(input_fp, chunk_offset + 4, SEEK_SET);
   fread((void *)temp_offset, 1, 4, input_fp);
   end = (temp_offset[0] << 24) + (temp_offset[1] << 16) +
             (temp_offset[2] << 8) + temp_offset[3];
   end += chunk_offset - 1;

   // Dump it
   DumpChunk(input_fp, output_fp, start, end);

#ifdef DEBUG
   printf("start = %08x\n", start);
   printf("end = %08x\n", end);
#endif

   // Dump misc. 

   // Figure out start address
   fseek(input_fp, chunk_offset + 8, SEEK_SET);
   fread((void *)temp_offset, 1, 4, input_fp);
   start = (temp_offset[0] << 24) + (temp_offset[1] << 16) +
             (temp_offset[2] << 8) + temp_offset[3];
   start += chunk_offset;

   // Figure out end address

   fseek(input_fp, chunk_offset + 16, SEEK_SET);
   fread((void *)temp_offset, 1, 4, input_fp);
   end = (temp_offset[0] << 24) + (temp_offset[1] << 16) +
             (temp_offset[2] << 8) + temp_offset[3];
   end += chunk_offset - 1;

   // Dump it
   DumpChunk(input_fp, output_fp, start, end);

#ifdef DEBUG
   printf("start = %08x\n", start);
   printf("end = %08x\n", end);
#endif

   // Now figure out the script start offset

   fseek(input_fp, chunk_offset + 20, SEEK_SET);
   fread((void *)temp_offset, 1, 4, input_fp);
   start = (temp_offset[0] << 24) + (temp_offset[1] << 16) +
             (temp_offset[2] << 8) + temp_offset[3];
   start += chunk_offset;

   // Now figure out the script end offset

   if (script_num != 20)
   {
      fseek(input_fp, chunk_offset + 32, SEEK_SET);
      fread((void *)temp_offset, 1, 4, input_fp);
      end = (temp_offset[0] << 24) + (temp_offset[1] << 16) +
                (temp_offset[2] << 8) + temp_offset[3];
      end += chunk_offset - 1;
   }
   else
   {      
      fseek(input_fp, chunk_offset + 28, SEEK_SET);
      fread((void *)temp_offset, 1, 4, input_fp);
      end = (temp_offset[0] << 24) + (temp_offset[1] << 16) +
                (temp_offset[2] << 8) + temp_offset[3];
      end += chunk_offset - 1;
   }

#ifdef DEBUG
   printf("chunk_offset = %08x\n", chunk_offset);
   printf("offset1 = %08x\n", offset1);
   printf("offset2 = %08x\n", offset2);
   printf("start = %08x\n", start);
   printf("end = %08x\n", end);
#endif

   // dump actual script
   DumpChunk(input_fp, output_fp, start, end);

   fclose(input_fp);
   fclose(output_fp);

   FreeDictionary ();

   return 0;
}

void DumpChunk(FILE *input_fp, FILE *output_fp, unsigned long start, unsigned long end)
{
   fprintf(output_fp, "[0x%x to 0x%x]\n", start, end);

   fseek (input_fp, start, SEEK_SET);

   while(end >= ftell(input_fp))
   {
       int i;
       unsigned short temp_short, temp_short2;

       fread((void *)&temp_short, 2, 1, input_fp);

       temp_short2 = temp_short << 8;
       temp_short2 >>= 8;

       if (temp_short2 == 0x81 || temp_short2 == 0x82 ||
           temp_short2 == 0x83 || temp_short2 == 0x84 ||
           temp_short2 == 0x88 || temp_short2 == 0x89 ||
           temp_short2 == 0x8A || temp_short2 == 0x8B ||
           temp_short2 == 0x8C || temp_short2 == 0x8D ||
           temp_short2 == 0x8E || temp_short2 == 0x8F ||
           temp_short2 == 0x90 || temp_short2 == 0x91 ||
           temp_short2 == 0x92 || temp_short2 == 0x93 ||
           temp_short2 == 0x94 || temp_short2 == 0x95 ||
           temp_short2 == 0x96 || temp_short2 == 0x97 ||
           temp_short2 == 0x98 || temp_short2 == 0x99 ||
           temp_short2 == 0x9A || temp_short2 == 0x9B ||
           temp_short2 == 0x9C || temp_short2 == 0x9D ||
           temp_short2 == 0x9E || temp_short2 == 0x9F ||
           temp_short2 == 0xE0 || temp_short2 == 0xE1 ||
           temp_short2 == 0xE2 || temp_short2 == 0xE3 ||
           temp_short2 == 0xE4 || temp_short2 == 0xE5 ||
           temp_short2 == 0xE6 || temp_short2 == 0xE7 ||
           temp_short2 == 0xE8 || temp_short2 == 0xE9 ||
           temp_short2 == 0xEA)
       {
          fwrite((void *)&temp_short, 2, 1, output_fp);
       }
       else if(temp_short2 == 0x00)
       {
          fprintf(output_fp, "<$00>\n");
          fseek(input_fp, -1, SEEK_CUR);
       }
       else if(temp_short2 == 0x02)
       {
          fputc(0x83, output_fp);
          fputc(0x8C, output_fp);

          fputc(0x83, output_fp);
          fputc(0x66, output_fp);

          fputc(0x83, output_fp);
          fputc(0x42, output_fp);

          fputc(0x83, output_fp);
          fputc(0x93, output_fp);

          fseek(input_fp, -1, SEEK_CUR);
       }
       else if(temp_short2 == 0x03) // scenario number
       {
          fprintf(output_fp, "<$03>");
          fseek(input_fp, -1, SEEK_CUR);
       }
       else if(temp_short2 == 0x05) // indent/space command
       {
          fputc(0x81, output_fp);
          fputc(0x40, output_fp);

          fseek(input_fp, -1, SEEK_CUR);
       }
       else if(temp_short2 == 0x06)
       {
          fprintf(output_fp, "<$06>");
          fseek(input_fp, -1, SEEK_CUR);
       }
       else if(temp_short2 == 0x07)
       {
          fprintf(output_fp, "<$07>\n");
          fseek(input_fp, -1, SEEK_CUR);
       }
       else if(temp_short2 == 0x08)
       {
          fprintf(output_fp, "<$08>\n");
          fseek(input_fp, -1, SEEK_CUR);
       }
       else
       {
          unsigned short temp_blah=0;

          temp_blah = (temp_short << 8) + (temp_short >> 8);

          if (temp_blah >= 0x400 && temp_blah <= 0x4EF)
          {
             unsigned char counter=0;

             while (counter < dictionary[temp_blah].size)
             {
                if (dictionary[temp_blah].value[counter] == 0x05)
                {
                   fputc(0x81, output_fp);
                   fputc(0x40, output_fp);
                   counter += 1;
                }
                else
                {
                   fwrite((void *)dictionary[temp_blah].value + counter,
                          2, 1, output_fp);
                   counter += 2;
                }
             }

          }
          else if (temp_blah >= 0x900 && temp_blah <= 0x9EF)
          {
             unsigned char counter=0;

             while (counter < dictionary[temp_blah].size)
             {
                if (dictionary[temp_blah].value[counter] == 0x05)
                {
                   fputc(0x81, output_fp);
                   fputc(0x40, output_fp);
                   counter += 1;
                }
                else
                {
                   fwrite((void *)dictionary[temp_blah].value + counter,
                          2, 1, output_fp);
                   counter += 2;
                }
             }

          }
          else
          {
            // Unknown dictionary word
            fprintf(output_fp, "<$%x>", temp_blah);
          }
       }
   }

   fprintf(output_fp, "\n");
}
