#include <stdio.h>
#include <dir.h>

//////////////////////////////////////////////////////////////////////////////

#define SLASH_STR "\\"
#define SLASH_CHAR '\\'

#define TYPE_BG    0 // bg.dat
#define TYPE_UNKNOWN 255

typedef struct
{
   unsigned long FileSize;
   unsigned long Reserved;
   unsigned long DataOffset;
} bmp_header;

typedef struct
{
unsigned long size;
unsigned long width;
unsigned long height;
unsigned short planes;
unsigned short bpp;
unsigned long compression;
unsigned long ImageSize;
unsigned long XppM;
unsigned long YppM;
unsigned long colorsused;
unsigned long colorsimportant;
} info_header;

bmp_header header;
info_header header2;

unsigned long ColorTable[256];

char output_fn[30];
unsigned char num_files=0;
unsigned short image_size=0;
unsigned long image_size2=0;
unsigned short image_width = 0;
unsigned short image_height = 0;
unsigned char temp_buffer[500000];
unsigned char temp_buffer2[500000];


int round(float x);
void CreateFileName(char *orig_filename, unsigned char number);
void GeneratePalette (FILE *fp);

//////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
   char *input_filename;
   char *output_filename;
   FILE *input_fp;
   FILE *output_fp;
   int i, i2, i3;
   unsigned short map_data;
   unsigned long temp_long;
   unsigned char file_type=255;
   int done=0;
   unsigned long file_offset=0;
   unsigned long f_size=0;
   unsigned short pal=0;
   unsigned char r, g, b;

   if (argc < 2)
   {
      printf ("dumpbg [filename.ext]\n");
      exit (1);
   }

   input_filename = argv[1];

   input_fp = fopen (input_filename, "rb");

   if (input_fp == NULL)
   {
      printf("Could not open image file: %s\n", input_filename);
      exit (1);
   }

   fseek (input_fp, 0, SEEK_END);
   f_size = ftell(input_fp);
   fseek (input_fp, 0, SEEK_SET);

   while (!done)
   {
      unsigned short temp_short=0;

      fseek(input_fp, num_files * 4, SEEK_SET);
      fread((void *)&file_offset, 4, 1, input_fp);

      file_offset = ((file_offset & 0xFF000000) >> 24) +
                    ((file_offset & 0x00FF0000) >> 8) +
                    ((file_offset & 0x0000FF00) << 8) +
                    ((file_offset & 0x000000FF) << 24);

      printf("offset: %x\n", file_offset);

      if (file_offset >= f_size)
      {
         done = 1;
      }
      else
      {
         CreateFileName(input_filename, num_files);
         num_files++;

         // go to position and start converting!

         fseek(input_fp, file_offset, SEEK_SET);
         fread((void *)&temp_short, 2, 1, input_fp);
         temp_short = (temp_short << 8) + (temp_short >> 8);

         if (temp_short == 0)
         {
//            printf("temp_short = %d at offset: %x\n", temp_short, ftell(input_fp) - 2);

            fread((void *)&image_height, 2, 1, input_fp);
            image_height = (image_height << 8) + (image_height >> 8);


            if (image_height == 8)
            {
               image_width = 16;
               image_height = 32;
            }
            else if (image_height == 100)
            {
               image_width = image_height = 80;
            }
            else if (image_height == 32)
            {
               image_width = 128;
               image_height = 16;
            }
            else if (image_height == 72)
            {
               image_width = 48;
               image_height = 48;
            }
            else if (image_height == 40)
            {
               image_width = 160;
               image_height = 16;
            }
            else
            {
               image_width = image_height;
            }

            output_fp = fopen (output_fn, "wb");

            if (output_fp == NULL)
            {
               printf("Could not open output file: %s\n", output_filename);

               fclose (input_fp);
               exit (1);
            }

            printf("Writing %s...\n", output_fn);

            header.FileSize = 1078 + (image_width * image_height);
            header.Reserved = 0;
            header.DataOffset = 0x436;

            header2.size = 40;
            header2.width = image_width;
            header2.height = image_height;
            header2.planes = 1;
            header2.bpp = 8;
            header2.compression = 0;
            header2.ImageSize = image_width * image_height;
            header2.XppM = 0;
            header2.YppM = 0;
            header2.colorsused = 0;
            header2.colorsimportant = 0;


            fputc('B', output_fp);
            fputc('M', output_fp);

            fwrite((bmp_header *)&header, sizeof(bmp_header), 1, output_fp);
            fwrite((info_header *)&header2, sizeof(info_header), 1, output_fp);
            fwrite((void *)ColorTable, 256, 4, output_fp);

            fread((void *)temp_buffer, image_width * image_height, 1, input_fp);

            for (i = 0; i < image_height; i++)
            {
               fwrite((void *)temp_buffer + (image_width * image_height) - (i * image_width + (image_width * 1)), image_width, 1, output_fp);
            }

            fclose (output_fp);

         }
         else if (temp_short == 160 || temp_short == 320)
         {
            image_width = temp_short;

            fread((void *)&image_height, 2, 1, input_fp);
            image_height = (image_height << 8) + (image_height >> 8);

            output_fp = fopen (output_fn, "wb");

            if (output_fp == NULL)
            {
               printf("Could not open output file: %s\n", output_filename);

               fclose (input_fp);
               exit (1);
            }

            printf("Writing %s...\n", output_fn);

            header.FileSize = ((image_width * image_height * 2) * 4) + 0x36;
            header.Reserved = 0;
            header.DataOffset = 0x36;

            header2.size = 40;
            header2.width = image_width;
            header2.height = image_height;
            header2.planes = 1;
            header2.bpp = 32;
            header2.compression = 0;
            header2.ImageSize = 0;
            header2.XppM = 0;
            header2.YppM = 0;
            header2.colorsused = 0;
            header2.colorsimportant = 0;

            fputc('B', output_fp);
            fputc('M', output_fp);

            fwrite((bmp_header *)&header, sizeof(bmp_header), 1, output_fp);
            fwrite((info_header *)&header2, sizeof(info_header), 1, output_fp);

            fread((void *)temp_buffer, 143360, 1, input_fp);

            for (i2 = 0; i2 < image_height; i2++)
            {
               for (i = 0; i < image_width; i++)
               {
                  pal = (temp_buffer[((image_width * image_height * 2) - 2 - ((i2 + 1) * (image_width * 2))) + (i * 2)] << 8) +
                         temp_buffer[((image_width * image_height * 2) - 2 - ((i2 + 1) * (image_width * 2))) + (i * 2) + 1];

                  pal &= ~0x8000;
 
                  b = pal << 3;
                  g = pal >> 5;
                  g <<= 3;
                  r = pal >> 10;
                  r <<= 3;

                  r >>= 3;
                  g >>= 3;
                  b >>= 3;

                  r = round(r * 8.2); 
                  g = round(g * 8.2);
                  b = round(b * 8.2);

                  temp_buffer2[((i2 * image_width + i) * 4)] = r;
                  temp_buffer2[((i2 * image_width + i) * 4) + 1] = g;
                  temp_buffer2[((i2 * image_width + i) * 4) + 2] = b;
                  temp_buffer2[((i2 * image_width + i) * 4) + 3] = 0x00;
               }
            }

            fwrite((void *)temp_buffer2, (image_width * image_height) * 4, 1, output_fp);
            fclose(output_fp);
         }
         else if (temp_short == 32768)
         {
            printf("temp_short = %d at offset: %x\n", temp_short, ftell(input_fp) - 2);
         }
         else if (temp_short == 0x10)
         {
            output_fp = fopen (output_fn, "wb");

            if (output_fp == NULL)
            {
               printf("Could not open output file: %s\n", output_filename);

               fclose (input_fp);
               exit (1);
            }

            printf("Writing %s...\n", output_fn);

            GeneratePalette (input_fp);

            // grab the size
            fread((void *)&image_size, 2, 1, input_fp);
            image_size = (image_size << 8) + (image_size >> 8);

            if ((image_size << 6) != 71680)
            {
               printf("Not a 320x224 image - Size = %d\n", image_size);

               if (image_size == 400)
               {
                  image_width = 160;
                  image_height = 160;
               }
               else if (image_size == 512)
               {
                  image_width = 256;
                  image_height = 128;
               }
               else if (image_size == 100)
               {
                  image_width = 80;
                  image_height = 80;
               }
               else
               {
                  image_width = 320;
                  image_height = 224;
               }
            }
            else
            {
               image_width = 320;
               image_height = 224;
            }


            header.FileSize = 1078 + (image_width * image_height);
            header.Reserved = 0;
            header.DataOffset = 0x436;

            header2.size = 40;
            header2.width = image_width;
            header2.height = image_height;
            header2.planes = 1;
            header2.bpp = 8;
            header2.compression = 0;
            header2.ImageSize = image_width * image_height;
            header2.XppM = 0;
            header2.YppM = 0;
            header2.colorsused = 0;
            header2.colorsimportant = 0;


            fputc('B', output_fp);
            fputc('M', output_fp);

            fwrite((bmp_header *)&header, sizeof(bmp_header), 1, output_fp);
            fwrite((info_header *)&header2, sizeof(info_header), 1, output_fp);
            fwrite((void *)ColorTable, 256, 4, output_fp);

            fread((void *)temp_buffer, image_width * image_height, 1, input_fp);

            for (i = 0; i < 224; i++)
            {
               fwrite((void *)temp_buffer + (image_width * image_height) - (i * image_width + (image_width * 1)), image_width, 1, output_fp);
            }

            fclose (output_fp);
         }
      }
   }

   printf("done.\n");
   fclose (input_fp);
}

//////////////////////////////////////////////////////////////////////////////

void _makepath (char *path, const char *drive, const char *dir,
		const char *fname, const char *ext)
{
    if (drive && *drive)
    {
	*path = *drive;
	*(path + 1) = ':';
	*(path + 2) = 0;
    }
    else
	*path = 0;
	
    if (dir && *dir)
    {
	strcat (path, dir);
        if (strlen (dir) != 1 || *dir != '\\')
            strcat (path, SLASH_STR);
    }
	
    strcat (path, fname);
    if (ext && *ext)
    {
        strcat (path, ".");
        strcat (path, ext);
    }
}

//////////////////////////////////////////////////////////////////////////////

void _splitpath (const char *path, char *drive, char *dir, char *fname,
		 char *ext)
{
    if (*path && *(path + 1) == ':')
    {
	*drive = toupper (*path);
	path += 2;
    }
    else
	*drive = 0;

    char *slash = strrchr (path, SLASH_CHAR);
    if (!slash)
	slash = strrchr (path, '/');
    char *dot = strrchr (path, '.');
    if (dot && slash && dot < slash)
	dot = NULL;

    if (!slash)
    {
        if (*drive)
            strcpy (dir, "\\");
        else
            strcpy (dir, "");
	strcpy (fname, path);
        if (dot)
        {
	    *(fname + (dot - path)) = 0;
	    strcpy (ext, dot + 1);
        }
	else
	    strcpy (ext, "");
    }
    else
    {
        if (*drive && *path != '\\')
        {
            strcpy (dir, "\\");
            strcat (dir, path);
            *(dir + (slash - path) + 1) = 0;
        }
        else
        {
            strcpy (dir, path);
            if (slash - path == 0)
                *(dir + 1) = 0;
            else
                *(dir + (slash - path)) = 0;
        }

	strcpy (fname, slash + 1);
        if (dot)
	{
	    *(fname + (dot - slash) - 1) = 0;
    	    strcpy (ext, dot + 1);
	}
	else
	    strcpy (ext, "");
    }
}

//////////////////////////////////////////////////////////////////////////////

void CreateFileName(char *orig_filename, unsigned char number)
{
   char drive[MAXDRIVE];
   char path[MAXDIR];
   char file[MAXFILE];
   char ext[MAXEXT];

   _splitpath(orig_filename, drive, path, file, ext);
   sprintf(file, "%s%04d.bmp", file, number);
   _makepath(output_fn, "", "", file, "");
}

//////////////////////////////////////////////////////////////////////////////

int round(float x)
{
   if (x - ((int)x) <  0.5)
   {
      return((int)x);
   }
   else
   {
      return ((int)(x+1));
   }
}

//////////////////////////////////////////////////////////////////////////////

//void GeneratePalette (FILE *fp)
//{
//   unsigned char r, g, b;
//   unsigned short pal;
//   int i;
//
//   for (i = 0; i < 256; i++)
//   {
//      fread((void *)&pal, 2, 1, fp);
//
//      pal = (pal << 8) + (pal >> 8);
//
//      r = pal << 3;
//      g = pal >> 5;
//      g <<= 3;
//      b = pal >> 10;
//      b <<= 3;
//
//
//      r >>= 3;
//      g >>= 3;
//      b >>= 3;
//
//      r = round(r * 8.2); 
//      g = round(g * 8.2);
//      b = round(b * 8.2);
//
//      ColorTable[i] = (r << 16) + (g << 8) + b;
//   }
//}

//////////////////////////////////////////////////////////////////////////////

//void GeneratePalette2 (FILE *fp) // Generates a palette using the old method
//{
//   unsigned char r, g, b;
//   unsigned short pal;
//   int i;
//
//   for (i = 0; i < 256; i++)
//   {
//      fread((void *)&pal, 2, 1, fp);
//
//      pal = (pal << 8) + (pal >> 8);
//
//      r = pal << 3;
//      g = pal >> 5;
//      g <<= 3;
//      b = pal >> 10;
//      b <<= 3;
//
//
//
//      ColorTable[i] = (r << 16) + (g << 8) + b;
//   }
//}

//////////////////////////////////////////////////////////////////////////////

void GeneratePalette (FILE *fp) // Generates a palette using PNG's method
{
   unsigned char r, g, b;
   unsigned short pal;
   int i;

   for (i = 0; i < 256; i++)
   {
      fread((void *)&pal, 2, 1, fp);

      pal = (pal << 8) + (pal >> 8);

      r = pal << 3;
      g = pal >> 5;
      g <<= 3;
      b = pal >> 10;
      b <<= 3;

      r = (r >> 5) + r;
      g = (g >> 5) + g;
      b = (b >> 5) + b;

      ColorTable[i] = (r << 16) + (g << 8) + b;
   }
}

//////////////////////////////////////////////////////////////////////////////

