#include <stdio.h>
#include <dir.h>

//////////////////////////////////////////////////////////////////////////////

#define SLASH_STR "\\"
#define SLASH_CHAR '\\'

typedef struct
{
   unsigned long FileSize;
   unsigned long Reserved;
   unsigned long DataOffset;
} bmp_header;

typedef struct
{
unsigned long size;
unsigned long width;
unsigned long height;
unsigned short planes;
unsigned short bpp;
unsigned long compression;
unsigned long ImageSize;
unsigned long XppM;
unsigned long YppM;
unsigned long colorsused;
unsigned long colorsimportant;
} info_header;

typedef struct
{
   unsigned long unknown_offset;
   unsigned short width;
   unsigned short height;
   unsigned short width2;
   unsigned short height2;
   unsigned char unknown2[6];
   unsigned char bpp;
   unsigned char unknown3[3];
   unsigned short map_offset;
   unsigned char unknown4[8];
} section_header_type;


bmp_header header;
info_header header2;
section_header_type section_header;

unsigned long ColorTable[256];

char output_fn[30];
char *output_filename;
FILE *input_fp;
FILE *input_fp2;
unsigned char num_files=0;
unsigned long max_files=0;
unsigned short image_size=0;
unsigned long image_size2=0;
unsigned short image_width = 0;
unsigned short image_height = 0;
unsigned char temp_buffer[1000000];
unsigned char temp_buffer2[1000000];
//unsigned char temp_buffer3[1000000];

void _makepath (char *path, const char *drive, const char *dir,
                const char *fname, const char *ext);
void _splitpath (const char *path, char *drive, char *dir, char *fname,
                 char *ext);
int round(float x);
void CreateFileName(char *orig_filename, unsigned char number);
void GeneratePalette (FILE *fp);
void blit8x8(unsigned char *src, unsigned char *dst, unsigned short tile_num, unsigned short x, unsigned short y);
void blit16x16(unsigned char *src, unsigned char *dst, unsigned short tile_num, unsigned short x, unsigned short y);
void ReverseY8(unsigned char *src, unsigned char *dst);
void ReverseY16(unsigned char *src, unsigned char *dst);
void GenerateBMP(unsigned char *buffer, unsigned char bpp);

//////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
   char *input_filename;
   int i, i2, i3;
   unsigned short map_data;
   unsigned long temp_long;
   unsigned char file_type=255;
   int done=0;
   unsigned long file_offset=0;
   unsigned long file_offset2=0;
   unsigned long f_size=0;
   unsigned long f_size2=0;
   unsigned long section_size=0;
   unsigned long section_size2=0;
   unsigned short pal=0;
   unsigned char r, g, b;
   char drive[MAXDRIVE];
   char path[MAXDIR];
   char file[MAXFILE];
   char ext[MAXEXT];
   char bleh[512];

   if (argc < 2)
   {
      printf ("dumpmap [filename.ext]\n");
      exit (1);
   }

   input_filename = argv[1];

   _splitpath(input_filename, drive, path, file, ext);
   sprintf(file, "map_c.dat");
   _makepath(bleh, drive, path, file, "");

   input_fp = fopen (input_filename, "rb");
   input_fp2 = fopen (bleh, "rb");


   if (input_fp == NULL || input_fp2 == NULL)
   {
      printf("Could not open image file: %s\n", input_filename);

      if (input_fp) fclose(input_fp);
      else fclose(input_fp2);
      exit (1);
   }



   fseek (input_fp, 0, SEEK_END);
   f_size = ftell(input_fp);
   fseek (input_fp, 0, SEEK_SET);

   fseek (input_fp2, 0, SEEK_END);
   f_size2 = ftell(input_fp2);
   fseek (input_fp2, 0, SEEK_SET);

   fread((void *)&max_files, 4, 1, input_fp);

   max_files = ((max_files & 0xFF000000) >> 24) +
               ((max_files & 0x00FF0000) >> 8) +
               ((max_files & 0x0000FF00) << 8) +
               ((max_files & 0x000000FF) << 24);

   while (!done)
   {
      unsigned short temp_short=0;

      fseek(input_fp, (num_files * 8) + 4, SEEK_SET);
      fseek(input_fp2, (num_files * 8) + 4, SEEK_SET);
      fread((void *)&file_offset, 4, 1, input_fp);
      fread((void *)&file_offset2, 4, 1, input_fp2);

      file_offset = ((file_offset & 0xFF000000) >> 24) +
                    ((file_offset & 0x00FF0000) >> 8) +
                    ((file_offset & 0x0000FF00) << 8) +
                    ((file_offset & 0x000000FF) << 24);

      file_offset2 = ((file_offset2 & 0xFF000000) >> 24) +
                     ((file_offset2 & 0x00FF0000) >> 8) +
                     ((file_offset2 & 0x0000FF00) << 8) +
                     ((file_offset2 & 0x000000FF) << 24);

      file_offset *= 0x800;
      file_offset2 *= 0x800;

      fread((void *)&section_size, 4, 1, input_fp);
      fread((void *)&section_size2, 4, 1, input_fp2);

      section_size = ((section_size & 0xFF000000) >> 24) +
                     ((section_size & 0x00FF0000) >> 8) +
                     ((section_size & 0x0000FF00) << 8) +
                     ((section_size & 0x000000FF) << 24);

      section_size2 = ((section_size2 & 0xFF000000) >> 24) +
                      ((section_size2 & 0x00FF0000) >> 8) +
                      ((section_size2 & 0x0000FF00) << 8) +
                      ((section_size2 & 0x000000FF) << 24);

      if (num_files > (max_files - 1))
      {
//         printf("num_files = %02x max_files = %02x", num_files, (max_files - 1));
         done = 1;
      }
      else
      {
         CreateFileName(input_filename, num_files);
         num_files++;

         // go to position and start converting!
         fseek(input_fp, file_offset, SEEK_SET);
         fseek(input_fp2, file_offset, SEEK_SET);

         // grab the section header
         fread((void *)&section_header.unknown_offset, 4, 1, input_fp);
         section_header.unknown_offset = ((section_header.unknown_offset & 0xFF000000) >> 24) +
                                         ((section_header.unknown_offset & 0x00FF0000) >> 8) +
                                         ((section_header.unknown_offset & 0x0000FF00) << 8) +
                                         ((section_header.unknown_offset & 0x000000FF) << 24);

         fread((void *)&section_header.width, 2, 1, input_fp);
         section_header.width = (section_header.width << 8) + (section_header.width >> 8);

         fread((void *)&section_header.height, 2, 1, input_fp);
         section_header.height = (section_header.height << 8) + (section_header.height >> 8);

         fread((void *)&section_header.width2, 2, 1, input_fp);
         section_header.width2 = (section_header.width2 << 8) + (section_header.width2 >> 8);

         fread((void *)&section_header.height2, 2, 1, input_fp);
         section_header.height2 = (section_header.height2 << 8) + (section_header.height2 >> 8);

         fseek(input_fp, 0x6, SEEK_CUR);

         fread((void *)&section_header.bpp, 1, 1, input_fp);
         section_header.bpp <<= 3;

         fseek(input_fp, 0x3, SEEK_CUR);

         fread((void *)&section_header.map_offset, 2, 1, input_fp);
         section_header.map_offset = (section_header.map_offset << 8) + (section_header.map_offset >> 8);

         fseek(input_fp, 0x8, SEEK_CUR);

/*
         if(section_header.bpp == 8)
         {
            printf("Section #%02x offset: %08x Section size: %08x current offset = %08x unknown_offset = %08x\n", num_files, file_offset, section_size, ftell(input_fp), section_header.unknown_offset);

            if (section_header.width2 != 0 && section_header.height2 != 0)
            {
               printf("Multi-layer detected\n");
            }

            printf("Writing %s...\n", output_fn);

            GeneratePalette (input_fp);

            fseek(input_fp, file_offset + section_header.unknown_offset + 0x30, SEEK_SET);
            fread((void *)&temp_long, 4, 1, input_fp);
            temp_long = ((temp_long & 0xFF000000) >> 24) +
                        ((temp_long & 0x00FF0000) >> 8) +
                        ((temp_long & 0x0000FF00) << 8) +
                        ((temp_long & 0x000000FF) << 24);

            fseek(input_fp, file_offset + section_header.unknown_offset + temp_long, SEEK_SET);

            fread((void *)temp_buffer, 1, (file_offset + section_size) - ftell(input_fp), input_fp);

            image_width = section_header.width << 3;
            image_height = section_header.height << 3;

            fseek(input_fp, file_offset + section_header.map_offset, SEEK_SET);

            for (i2 = 0; i2 < (image_height / 8); i2++)
            for (i = 0; i < (image_width / 8); i++)
            {
               fread((void *)&temp_short, 2, 1, input_fp);   
               temp_short = (temp_short << 8) + (temp_short >> 8);
               blit8x8(temp_buffer, temp_buffer2, temp_short, i * 8, i2 * 8);
            }

            ReverseY8(temp_buffer2, temp_buffer);

            // open file and write to it

            GenerateBMP(temp_buffer, 8);
         }
*/

         if (section_header.bpp == 16)
         {
            printf("Section #%02x offset: %08x Section size: %08x current offset = %08x unknown_offset = %08x\n", num_files, file_offset, section_size, ftell(input_fp), section_header.unknown_offset);

            if (section_header.width2 != 0 && section_header.height2 != 0)
            {
               printf("Multi-layer detected\n");
            }

            printf("Writing %s...\n", output_fn);

            GeneratePalette (input_fp);

//            for (i = 0; i < 256; i++)
//            {
//               ColorTable[i] = (i << 16) + (i << 8) + i;
//            }

//            fseek(input_fp, file_offset + section_header.unknown_offset + 0x30, SEEK_SET);
//            fread((void *)&temp_long, 4, 1, input_fp);
//            temp_long = ((temp_long & 0xFF000000) >> 24) +
//                        ((temp_long & 0x00FF0000) >> 8) +
//                        ((temp_long & 0x0000FF00) << 8) +
//                        ((temp_long & 0x000000FF) << 24);

//            fseek(input_fp, file_offset + section_header.unknown_offset + temp_long, SEEK_SET);

            fseek(input_fp2, file_offset2, SEEK_SET);
            fread((void *)temp_buffer, 1, (file_offset2 + section_size2) - ftell(input_fp2), input_fp2);

            image_width = section_header.width << 3;
            image_height = section_header.height << 3;

            fseek(input_fp, file_offset + section_header.map_offset, SEEK_SET);

            for (i2 = 0; i2 < (image_height / 8); i2++)
            for (i = 0; i < (image_width / 8); i++)
            {
               fread((void *)&temp_short, 2, 1, input_fp);   
               temp_short = (temp_short << 8) + (temp_short >> 8);
               blit8x8(temp_buffer, temp_buffer2, temp_short, i * 8, i2 * 8);
            }

            ReverseY8(temp_buffer2, temp_buffer);

            // open file and write to it

            GenerateBMP(temp_buffer, 8);

         }
         else
         {
         }
      }
   }

   printf("done.\n");
   fclose (input_fp);
   fclose (input_fp2);
}

//////////////////////////////////////////////////////////////////////////////

void _makepath (char *path, const char *drive, const char *dir,
		const char *fname, const char *ext)
{
    if (drive && *drive)
    {
	*path = *drive;
	*(path + 1) = ':';
	*(path + 2) = 0;
    }
    else
	*path = 0;
	
    if (dir && *dir)
    {
	strcat (path, dir);
        if (strlen (dir) != 1 || *dir != '\\')
            strcat (path, SLASH_STR);
    }
	
    strcat (path, fname);
    if (ext && *ext)
    {
        strcat (path, ".");
        strcat (path, ext);
    }
}

//////////////////////////////////////////////////////////////////////////////

void _splitpath (const char *path, char *drive, char *dir, char *fname,
		 char *ext)
{
    if (*path && *(path + 1) == ':')
    {
	*drive = toupper (*path);
	path += 2;
    }
    else
	*drive = 0;

    char *slash = strrchr (path, SLASH_CHAR);
    if (!slash)
	slash = strrchr (path, '/');
    char *dot = strrchr (path, '.');
    if (dot && slash && dot < slash)
	dot = NULL;

    if (!slash)
    {
        if (*drive)
            strcpy (dir, "\\");
        else
            strcpy (dir, "");
	strcpy (fname, path);
        if (dot)
        {
	    *(fname + (dot - path)) = 0;
	    strcpy (ext, dot + 1);
        }
	else
	    strcpy (ext, "");
    }
    else
    {
        if (*drive && *path != '\\')
        {
            strcpy (dir, "\\");
            strcat (dir, path);
            *(dir + (slash - path) + 1) = 0;
        }
        else
        {
            strcpy (dir, path);
            if (slash - path == 0)
                *(dir + 1) = 0;
            else
                *(dir + (slash - path)) = 0;
        }

	strcpy (fname, slash + 1);
        if (dot)
	{
	    *(fname + (dot - slash) - 1) = 0;
    	    strcpy (ext, dot + 1);
	}
	else
	    strcpy (ext, "");
    }
}

//////////////////////////////////////////////////////////////////////////////

void CreateFileName(char *orig_filename, unsigned char number)
{
   char drive[MAXDRIVE];
   char path[MAXDIR];
   char file[MAXFILE];
   char ext[MAXEXT];

   _splitpath(orig_filename, drive, path, file, ext);
   sprintf(file, "%s%04d.bmp", file, number);
   _makepath(output_fn, "", "", file, "");
}

//////////////////////////////////////////////////////////////////////////////

int round(float x)
{
   if (x - ((int)x) <  0.5)
   {
      return((int)x);
   }
   else
   {
      return ((int)(x+1));
   }
}

//////////////////////////////////////////////////////////////////////////////

//void GeneratePalette (FILE *fp)
//{
//   unsigned char r, g, b;
//   unsigned short pal;
//   int i;
//
//   for (i = 0; i < 256; i++)
//   {
//      fread((void *)&pal, 2, 1, fp);
//
//      pal = (pal << 8) + (pal >> 8);
//
//      r = pal << 3;
//      g = pal >> 5;
//      g <<= 3;
//      b = pal >> 10;
//      b <<= 3;
//
//
//      r >>= 3;
//      g >>= 3;
//      b >>= 3;
//
//      r = round(r * 8.2); 
//      g = round(g * 8.2);
//      b = round(b * 8.2);
//
//      ColorTable[i] = (r << 16) + (g << 8) + b;
//   }
//}

//////////////////////////////////////////////////////////////////////////////

//void GeneratePalette2 (FILE *fp) // Generates a palette using the old method
//{
//   unsigned char r, g, b;
//   unsigned short pal;
//   int i;
//
//   for (i = 0; i < 256; i++)
//   {
//      fread((void *)&pal, 2, 1, fp);
//
//      pal = (pal << 8) + (pal >> 8);
//
//      r = pal << 3;
//      g = pal >> 5;
//      g <<= 3;
//      b = pal >> 10;
//      b <<= 3;
//
//
//
//      ColorTable[i] = (r << 16) + (g << 8) + b;
//   }
//}

//////////////////////////////////////////////////////////////////////////////

void GeneratePalette (FILE *fp) // Generates a palette using PNG's method
{
   unsigned char r, g, b;
   unsigned short pal;
   int i;

   for (i = 0; i < 256; i++)
   {
      fread((void *)&pal, 2, 1, fp);

      pal = (pal << 8) + (pal >> 8);

      r = pal << 3;
      g = pal >> 5;
      g <<= 3;
      b = pal >> 10;
      b <<= 3;

      r = (r >> 5) + r;
      g = (g >> 5) + g;
      b = (b >> 5) + b;

      ColorTable[i] = (r << 16) + (g << 8) + b;
   }
}

//////////////////////////////////////////////////////////////////////////////

void blit8x8(unsigned char *src, unsigned char *dst, unsigned short tile_num, unsigned short x, unsigned short y)
{
   int i, i2;
   unsigned char hflip=0;
   unsigned char vflip=0;

   if (tile_num & 0x4000)
   {
      hflip = 1;
   }
   if (tile_num & 0x8000)
   {
      vflip = 1;
   }

   tile_num = tile_num & 0x0FFF;

   for (i = 0; i < 8; i++)
   {
      if (hflip == 1 && vflip == 1)
      {
         for (i2 = 0; i2 < 8; i2++)
         {
            dst[(y * image_width) + x + (i * image_width) + i2] = src[(tile_num * 8 * 8) + ((8 * 8) - 8 - i * 8) + 7 - i2];
         }
      }
      else if (hflip)
      {
         for (i2 = 0; i2 < 8; i2++)
         {
            dst[(y * image_width) + x + (i * image_width) + i2] = src[(tile_num * 8 * 8) + (i * 8) + 7 - i2];
         }
      }
      else if (vflip)
      {
         memcpy(dst + (y * image_width) + x + (i * image_width), src + (tile_num * 8 * 8) + ((8 * 8) - 8 - i * 8), 8);
      }
      else
      {
         memcpy(dst + (y * image_width) + x + (i * image_width), src + (tile_num * 8 * 8) + (i * 8), 8);
      }
   }
}

//////////////////////////////////////////////////////////////////////////////

void blit16x16(unsigned char *src, unsigned char *dst, unsigned short tile_num, unsigned short x, unsigned short y)
{
   int i, i2;

   // for now ignore the highest 4 bits
   tile_num = tile_num & 0x0FFF;

   for (i = 0; i < 16; i++)
   {
      memcpy(dst + (y * image_width) + x + (i * image_width), src + (tile_num * 16 * 16) + (i * 16), 16);
   }
}

//////////////////////////////////////////////////////////////////////////////

void ReverseY8(unsigned char *src, unsigned char *dst)
{
   int i;
   
   for (i = 0; i < image_height; i++)
   {
      memcpy(dst + (i * image_width), src + (image_width * image_height) - image_width - (i * image_width), image_width);
   }
}

//////////////////////////////////////////////////////////////////////////////

void ReverseY16(unsigned char *src, unsigned char *dst)
{
   int i;
}

//////////////////////////////////////////////////////////////////////////////

void GenerateBMP(unsigned char *buffer, unsigned char bpp)
{
   FILE *output_fp;

   output_fp = fopen (output_fn, "wb");

   if (output_fp == NULL)
   {
      printf("Could not open output file: %s\n", output_filename);

      fclose (input_fp);
      fclose (input_fp2);
      exit (1);
   }

   header.FileSize = 1078 + ((image_width * image_height) * bpp / 8);
   header.Reserved = 0;

   if (bpp == 8)
   {
      header.DataOffset = 0x436;
   }
   else
   {
      header.DataOffset = 0x36;
   }

   header2.size = 40;
   header2.width = image_width;
   header2.height = image_height;
   header2.planes = 1;
   header2.bpp = bpp;
   header2.compression = 0;
   header2.ImageSize = image_width * image_height;
   header2.XppM = 0;
   header2.YppM = 0;
   header2.colorsused = 0;
   header2.colorsimportant = 0;

   fputc('B', output_fp);
   fputc('M', output_fp);

   fwrite((bmp_header *)&header, sizeof(bmp_header), 1, output_fp);
   fwrite((info_header *)&header2, sizeof(info_header), 1, output_fp);

   if (bpp == 8)
   {
      fwrite((void *)ColorTable, 256, 4, output_fp);
   }

   fwrite((void *)temp_buffer, 1, image_width * image_height, output_fp);

   fclose (output_fp);
}
