// Extracts files from Lunar: SSSC mpeg version .dat files.

#include <stdio.h>

int main(int argc, char *argv[])
{
   char filename[256];
   char filename_out[13];
   char *filebuffer;
   FILE *fp;
   FILE *fp_out;
   unsigned long offset=0;
   unsigned long f_start=0;
   unsigned long f_length=0;
   unsigned char f_temp[4];
   //unsigned char num_files;
   unsigned short counter=0;
   unsigned short counter_limit=0;

   if (argc < 3)
   {
      printf("usage: extract [num] [filename]\n");
      printf("where [num] is the number of files in the .dat file\n");
      exit (1);
   }

   strcpy(filename, argv[2]);

   fp = fopen (filename, "rb");

   if (fp == NULL)
   {
      printf("cannot find file\n");
      free (filename_out);
      exit (1);
   }

   counter_limit = atoi(argv[1]);

   while(counter < counter_limit)
   {
//      memset(filename_out, 13, 0);

      fseek (fp, offset, SEEK_SET);
      fread(filename_out, 1, 13, fp);

      printf("%s\n", filename_out);

      fp_out = fopen(filename_out, "wb");
 
      if (fp_out == NULL)
      {
        printf ("Couldn't write file %s\n", filename_out);
        fclose (fp);

        exit(1);
      }

      fseek(fp, offset + 0xC, SEEK_SET);
      fread(&f_temp, 1, 4, fp);
      f_start = (f_temp[0] << 24) + (f_temp[1] << 16) + (f_temp[2] << 8) + f_temp[3];

      fseek(fp, offset + 0x14, SEEK_SET);
      fread(&f_temp, 1, 4, fp);
      f_length = (f_temp[0] << 24) + (f_temp[1] << 16) + (f_temp[2] << 8) + f_temp[3];

      f_start *= 0x800;

      printf("f_start = %x\nf_length = %x\n\n", f_start, f_length);

      filebuffer = (char *)malloc (f_length);

      if (filebuffer == NULL)
      {
         printf ("Couldn't write file %s - not enough memory for buffer\n", filename_out);
         fclose (fp);
         fclose (fp_out);
         free (filename_out);

         exit(1);
      }

      fseek(fp, f_start, SEEK_SET);
      fread(filebuffer, 1, f_length, fp);
      fwrite(filebuffer, 1, f_length, fp_out);

      fclose (fp_out);

      free (filebuffer);

      counter += 1;
      offset += 0x18;
   }

   fclose (fp);
}
