#include <stdio.h>

typedef struct
{
   unsigned long FileSize;
   unsigned long Reserved;
   unsigned long DataOffset;
} bmp_header;

typedef struct
{
unsigned long size;
unsigned long width;
unsigned long height;
unsigned short planes;
unsigned short bpp;
unsigned long compression;
unsigned long ImageSize;
unsigned long XppM;
unsigned long YppM;
unsigned long colorsused;
unsigned long colorsimportant;
unsigned long ColorTable[256];
} info_header;

bmp_header header;

info_header header2;

int round(float x)
{
   if (x - ((int)x) <  0.5)
   {
      return((int)x);
   }
   else
   {
      return ((int)(x+1));
   }
}

int main(int argc, char *argv[])
{
   char *input_filename;
   char *output_filename;
   char *temp_buffer;
   char *temp_buffer2;
   char *temp_buffer3;
   FILE *input_fp;
   FILE *output_fp;
   int i, i2, i3, i4;
   unsigned char r, g, b;
   unsigned short pal;
   unsigned short map_data;
   unsigned long temp_long;

   if (argc < 4)
   {
      printf ("macdecode [filename].bin -o [filename].bmp\n");
      exit (1);
   }
   if (strcmp (argv[argc - 2], "-o") == NULL)
   {
      output_filename = argv[argc - 1];
   }
   else
   {
      printf ("no filename specified\n");
      exit (1);
   }

   input_filename = argv[1];

   input_fp = fopen (input_filename, "rb");

   if (input_fp == NULL)
   {
      printf("Could not open macross image file: %s\n", input_filename);
      exit (1);
   }

   output_fp = fopen (output_filename, "wb");

   if (output_fp == NULL)
   {
      printf("Could not open output file: %s\n", output_filename);

      fclose (input_fp);
      exit (1);
   }

   fseek(input_fp, 0, SEEK_SET);

      temp_buffer = (char *)malloc (sizeof(char) * 71680);

      if (temp_buffer == NULL)
      {
         printf("Could not create buffer\n");

         fclose (input_fp);
         fclose (output_fp);
         exit (1);
      }

      temp_buffer2 = (char *)malloc (sizeof(char) * 71680);
  
      if (temp_buffer2 == NULL)
      {
         printf("Could not create buffer\n");

         free (temp_buffer);
         fclose (input_fp);
         fclose (output_fp);
         exit (1);
      }

      temp_buffer3 = (char *)malloc (sizeof(char) * 71680);
  
      if (temp_buffer3 == NULL)
      {
         printf("Could not create buffer\n");

         free (temp_buffer);
         free (temp_buffer2);
         fclose (input_fp);
         fclose (output_fp);
         exit (1);
      }

      header.FileSize = 72758;
      header.Reserved = 0;
      header.DataOffset = 0x436;

      header2.size = 40;
      header2.width = 320;
      header2.height = 224;
      header2.planes = 1;
      header2.bpp = 8;
      header2.compression = 0;
      header2.ImageSize = 0x11800;
      header2.XppM = 0;
      header2.YppM = 0;
      header2.colorsused = 0;
      header2.colorsimportant = 0;

      for (i = 0; i < 256; i++)
      {
         fread((void *)&pal, 2, 1, input_fp);

         pal = (pal << 8) + (pal >> 8);
         pal &= ~0x8000;

         r = pal << 3;
         g = pal >> 5;
         g <<= 3;
         b = pal >> 10;
         b <<= 3;

         r >>= 3;
         g >>= 3;
         b >>= 3;

         r = round(r * 8.2); 
         g = round(g * 8.2);
         b = round(b * 8.2);

         header2.ColorTable[i] = (r << 16) + (g << 8) + b;
      }

      fputc('B', output_fp);
      fputc('M', output_fp);

      fwrite((bmp_header *)&header, sizeof(bmp_header), 1, output_fp);
      fwrite((info_header *)&header2, sizeof(info_header), 1, output_fp);

      fseek(input_fp, 0xB00, SEEK_SET);

      fread((void *)temp_buffer, 71680, 1, input_fp);

      for (i3 = 0; i3 < (224 / 16); i3++)
      {
         for (i2 = 0; i2 < (320 / 16); i2++)
         {
            for (i = 0; i < 8; i++)
            {
               memcpy(temp_buffer2 + (((i3 * 20) + i2) * 256) + (i * 16), temp_buffer + ((i3 * 16) * 320) + (i2 * 256) + (i * 8), 8);
               memcpy(temp_buffer2 + (((i3 * 20) + i2) * 256) + (i * 16) + 8, temp_buffer + ((i3 * 16) * 320) + (i2 * 256) + (i * 8) + 64, 8);
               memcpy(temp_buffer2 + (((i3 * 20) + i2) * 256) + (i * 16) + 128, temp_buffer + ((i3 * 16) * 320) + (i2 * 256) + (i * 8) + 128, 8);
               memcpy(temp_buffer2 + (((i3 * 20) + i2) * 256) + (i * 16) + 128 + 8, temp_buffer + ((i3 * 16) * 320) + (i2 * 256) + (i * 8) + 192, 8);
            }
         }
      }

      fseek(input_fp, 0x200, SEEK_SET);

      for (i3 = 0; i3 < (224 / 16); i3++)
      {
         for (i2 = 0; i2 < (320 / 16); i2++)
         {
            fread((void *)&map_data, 2, 1, input_fp);
            map_data = (map_data << 8) + (map_data >> 8);

            for (i = 0; i < 16; i++)
            {
               memcpy(temp_buffer3 + (320 * 224) - (((i3 + 1) * 16) * 320) + (i2 * 16) + (i * 320),
                      temp_buffer2 + (((map_data / 2) - 1) * 256) + ((15 - i) * 16), 16);

            }
         }

         fseek(input_fp, 24, SEEK_CUR);
      }

  fwrite((void *)temp_buffer3, 71680, 1, output_fp);

  printf("done.\n");

  fclose (output_fp);
  fclose (input_fp);
  free (temp_buffer);
  free (temp_buffer2);
}
