#include <stdio.h>

typedef struct
{
   unsigned long FileSize;
   unsigned long Reserved;
   unsigned long DataOffset;
} bmp_header;

typedef struct
{
unsigned long size;
unsigned long width;
unsigned long height;
unsigned short planes;
unsigned short bpp;
unsigned long compression;
unsigned long ImageSize;
unsigned long XppM;
unsigned long YppM;
unsigned long colorsused;
unsigned long colorsimportant;
} info_header;

bmp_header header;

info_header header2;

int round(float x)
{
   if (x - ((int)x) <  0.5)
   {
      return((int)x);
   }
   else
   {
      return ((int)(x+1));
   }
}

int main(int argc, char *argv[])
{
   char *input_filename;
   char *output_filename;
   unsigned char *temp_buffer;
   unsigned char *temp_buffer2;
   FILE *input_fp;
   FILE *output_fp;
   int i, i2, i3, i4;
   unsigned char r, g, b;
   unsigned short pal;
   unsigned long temp_long;

   if (argc < 4)
   {
      printf ("tmdecode [filename].bin -o [filename].bmp\n");
      exit (1);
   }
   if (strcmp (argv[argc - 2], "-o") == NULL)
   {
      output_filename = argv[argc - 1];
   }
   else
   {
      printf ("no filename specified\n");
      exit (1);
   }

   input_filename = argv[1];

   input_fp = fopen (input_filename, "rb");

   if (input_fp == NULL)
   {
      printf("Could not open tm image file: %s\n", input_filename);
      exit (1);
   }

   output_fp = fopen (output_filename, "wb");

   if (output_fp == NULL)
   {
      printf("Could not open output file: %s\n", output_filename);

      fclose (input_fp);
      exit (1);
   }

   fseek(input_fp, 0, SEEK_SET);

   temp_buffer = (unsigned char *)malloc (sizeof(char) * 143360);

   if (temp_buffer == NULL)
   {
      printf("Could not create buffer\n");

      fclose (input_fp);
      fclose (output_fp);
      exit (1);
   }

   temp_buffer2 = (unsigned char *)malloc (sizeof(char) * 143360 * 4);
  
   if (temp_buffer2 == NULL)
   {
      printf("Could not create buffer\n");

      free (temp_buffer);
      fclose (input_fp);
      fclose (output_fp);
      exit (1);
   }

   header.FileSize = (143360 * 4) + 0x36;
   header.Reserved = 0;
   header.DataOffset = 0x36;

   header2.size = 40;
   header2.width = 320;
   header2.height = 224;
   header2.planes = 1;
   header2.bpp = 32;
   header2.compression = 0;
   header2.ImageSize = 0;
   header2.XppM = 0;
   header2.YppM = 0;
   header2.colorsused = 0;
   header2.colorsimportant = 0;

   fputc('B', output_fp);
   fputc('M', output_fp);

   fwrite((bmp_header *)&header, sizeof(bmp_header), 1, output_fp);
   fwrite((info_header *)&header2, sizeof(info_header), 1, output_fp);

   fseek(input_fp, 0x0, SEEK_SET);
   fread((void *)temp_buffer, 143360, 1, input_fp);

   for (i2 = 0; i2 < 224; i2++)
   {
      for (i = 0; i < 320; i++)
      {
         pal = (temp_buffer[((320 * 224 * 2) - 2 - ((i2 + 1) * 640)) + (i * 2)] << 8) +
               temp_buffer[((320 * 224 * 2) - 2 - ((i2 + 1) * 640)) + (i * 2) + 1];

         pal &= ~0x8000;

         b = pal << 3;
         g = pal >> 5;
         g <<= 3;
         r = pal >> 10;
         r <<= 3;

         r >>= 3;
         g >>= 3;
         b >>= 3;

         r = round(r * 8.2); 
         g = round(g * 8.2);
         b = round(b * 8.2);

         temp_buffer2[((i2 * 320 + i) * 4)] = r;
         temp_buffer2[((i2 * 320 + i) * 4) + 1] = g;
         temp_buffer2[((i2 * 320 + i) * 4) + 2] = b;
         temp_buffer2[((i2 * 320 + i) * 4) + 3] = 0x00;
      }
   }

   fwrite((void *)temp_buffer2, (143360 * 4), 1, output_fp);

   printf("done.\n");

   fclose (output_fp);
   fclose (input_fp);
   free (temp_buffer);
   free (temp_buffer2);
}
