#include <stdio.h>

typedef struct
{
   unsigned long FileSize;
   unsigned long Reserved;
   unsigned long DataOffset;
} bmp_header;

typedef struct
{
unsigned long size;
unsigned long width;
unsigned long height;
unsigned short planes;
unsigned short bpp;
unsigned long compression;
unsigned long ImageSize;
unsigned long XppM;
unsigned long YppM;
unsigned long colorsused;
unsigned long colorsimportant;
} info_header;

bmp_header header;

info_header header2;

int round(float x)
{
   if (x - ((int)x) <  0.5)
   {
      return((int)x);
   }
   else
   {
      return ((int)(x+1));
   }
}

int main(int argc, char *argv[])
{
   char *input_filename;
   char *output_filename;
   unsigned char *temp_buffer;
   unsigned char *temp_buffer2;
   FILE *input_fp;
   FILE *output_fp;
   int i, i2, i3, i4;
   unsigned char r, g, b;
   unsigned short pal;
   unsigned long temp_long;
   unsigned short temp_short;

   if (argc < 4)
   {
      printf ("tmencode [filename].bmp -o [filename].bin\n");
      exit (1);
   }
   if (strcmp (argv[argc - 2], "-o") == NULL)
   {
      output_filename = argv[argc - 1];
   }
   else
   {
      printf ("no filename specified\n");
      exit (1);
   }

   input_filename = argv[1];

   input_fp = fopen (input_filename, "rb");

   if (input_fp == NULL)
   {
      printf("Could not open image file: %s\n", input_filename);
      exit (1);
   }

   output_fp = fopen (output_filename, "wb");

   if (output_fp == NULL)
   {
      printf("Could not open output file: %s\n", output_filename);

      fclose (input_fp);
      exit (1);
   }

   fseek(input_fp, 0, SEEK_SET);

   fread ((void *)&temp_short, 2, 1, input_fp);

   if (temp_short != 0x4D42)
   {
      printf("Not a BMP file\n");

//      free (temp_buffer);
//      free (temp_buffer2);
      fclose (input_fp);
      fclose (output_fp);
      exit (1);
   }

   fread((void *)&header.FileSize, 1, 4, input_fp);
   fread((void *)&header.Reserved, 1, 4, input_fp);
   fread((void *)&header.DataOffset, 1, 4, input_fp);


   fread((void *)&header2.size, 1, 4, input_fp);
   fread((void *)&header2.width, 1, 4, input_fp);
   fread((void *)&header2.height, 1, 4, input_fp);
   fread((void *)&header2.planes, 1, 2, input_fp);
   fread((void *)&header2.bpp, 1, 2, input_fp);
   fread((void *)&header2.compression, 1, 4, input_fp);
   fread((void *)&header2.ImageSize, 1, 4, input_fp);
   fread((void *)&header2.XppM, 1, 4, input_fp);
   fread((void *)&header2.YppM, 1, 4, input_fp);
   fread((void *)&header2.colorsused, 1, 4, input_fp);
   fread((void *)&header2.colorsimportant, 1, 4, input_fp);

   if (header2.width != 320 || header2.height != 224 ||
       header2.planes != 1 || header2.bpp != 32 ||
       header2.compression != 0)
   {
      printf("unsupported bitmap format\n");

      fclose (input_fp);
      fclose (output_fp);
      exit (1);
   }

   fseek(input_fp, header.DataOffset, SEEK_SET);

   temp_buffer = (unsigned char *)malloc (sizeof(char) * 143360 * 4);

   if (temp_buffer == NULL)
   {
      printf("Could not create buffer\n");

      fclose (input_fp);
      fclose (output_fp);
      exit (1);
   }

   temp_buffer2 = (unsigned char *)malloc (sizeof(char) * 143360);
  
   if (temp_buffer2 == NULL)
   {
      printf("Could not create buffer\n");

      free (temp_buffer);
      fclose (input_fp);
      fclose (output_fp);
      exit (1);
   }

   fread((void *)temp_buffer, 143360 * 4, 1, input_fp);

   for (i2 = 0; i2 < 224; i2++)
   {
      for (i = 0; i < 320; i++)
      {
         r = temp_buffer[((i2 * 320 + i) * 4)];
         g = temp_buffer[((i2 * 320 + i) * 4) + 1];
         b = temp_buffer[((i2 * 320 + i) * 4) + 2];

//         printf("r = %02x g = %02x b = %02x \n", r, g, b);

         r = round(r / 8.2);
         g = round(g / 8.2);
         b = round(b / 8.2);

//         printf("(rounded)r = %02x g = %02x b = %02x \n", r, g, b);

         pal = (r << 10) + (g << 5) + b;
         pal |= 0x8000;

//         printf("pal = %04x \n", pal);

         temp_buffer2[((320 * 224 * 2) - 2 - ((i2 + 1) * 640)) + (i * 2)] = pal >> 8;
         temp_buffer2[((320 * 224 * 2) - 2 - ((i2 + 1) * 640)) + (i * 2) + 1] = pal;
      }
   }

   fwrite((void *)temp_buffer2, 143360, 1, output_fp);

   printf("done.\n");

   fclose (output_fp);
   fclose (input_fp);
   free (temp_buffer);
   free (temp_buffer2);
}
