/*******************************************************************************
  DEC - Text decoder test program

  (c) Copyright 2004 Theo Berkau(cwx@softhome.net)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <string.h>

#define PROG_NAME "DEC"
#define VER_NAME "1.00"
#define COPYRIGHT_YEAR "2004"

FILE *fp;
FILE *outfp;
unsigned char *buffer;
unsigned char *outbuffer;

#define MAX_PATH 512
char outfilename[MAX_PATH];

#define TRUE    1
#define FALSE   0

#undef DEBUG
//#define DEBUG 1

unsigned long dword_60396A4=1;
unsigned char byte_60396A8=0;
unsigned char *off_60396AC;
unsigned char byte_60396B0=0x80;
unsigned char *cmp_text_buffer;
unsigned char *cmp_text_buffer2;

unsigned short Decode_character();
void FindDecPos(long R4);
unsigned char Decode_byte();

unsigned long GrabLong(unsigned char *buf);
int ParseX5(unsigned char *buf);

//////////////////////////////////////////////////////////////////////////////

void ProgramUsage()
{
   printf("%s v%s - by Cyber Warrior X (c)%s\n", PROG_NAME, VER_NAME, COPYRIGHT_YEAR);
   printf("usage: %s <filename> [switches]\n", strlwr(PROG_NAME));
   exit (1);
}

//////////////////////////////////////////////////////////////////////////////

void cleanup()
{
   if (fp) fclose(fp);
   if (outfp) fclose(outfp);
   if (buffer) free(buffer);
   if (outbuffer) free(outbuffer);
}

//////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
   char *filename;
   unsigned long f_size;
   unsigned long i;
   unsigned short decchar;

   atexit(cleanup);

   if (argc != 2)
   {
      ProgramUsage();
   }

   filename = argv[1];

   printf("%s v%s - by Cyber Warrior X(c)%s\n", PROG_NAME, VER_NAME, COPYRIGHT_YEAR);

   if ((fp = fopen(filename, "rb")) == NULL)
   {
      printf("Unable to open file: %s\n", filename);
      exit (1);
   }

   // grab the file size
   f_size = filelength(fileno(fp));

   // allocate buffer
   if ((buffer = (unsigned char *)malloc(f_size)) == NULL)
   {
      printf("Unable to allocate buffer\n");
      exit(1);
   }

   // allocate decoding buffer
   if ((outbuffer = (unsigned char *)malloc(0x100000)) == NULL)
   {
      printf("Unable to allocate buffer\n");
      exit(1);
   }

   // copy file to buffer
   fread((void *)buffer, 1, f_size, fp);
   fclose(fp);

   ParseX5(buffer);
//   cmp_text_buffer = buffer + 0xC;

   for (i = 0; i < 634; i++)
   {
      FindDecPos((i * 2) - 120);
//      FindDecPos(0);

      // decode the string
      for (;;)
      {
         decchar = Decode_character();

         if (decchar < 0x001F)
         {
            if (decchar == 0x0006 || decchar == 0x0002 || decchar == 0x0000)
               break;
            else if (decchar == 0x0003)
               printf("\n");
            else
               printf("<$%04X>", decchar);
         }
         else if (decchar < 0x0080)
         {
            // if decoded character is > 0x001E && < 0x0080, assume it's ascii
            printf("%c", decchar & 0xFF);
         }
         else
         {
            printf("<$%04X>", decchar);
         }
      }
      printf("\n");
   }

   return 0;
}

//////////////////////////////////////////////////////////////////////////////

unsigned long DoubleWordSwap(unsigned long data)
{
   return (((data & 0xFF000000) >> 24) +
          ((data & 0x00FF0000) >> 8) +
          ((data & 0x0000FF00) << 8) + 
          ((data & 0x000000FF) << 24));
}

//////////////////////////////////////////////////////////////////////////////

unsigned short Decode_character()
{
   return (unsigned short)((Decode_byte() << 8) + Decode_byte());
}

//////////////////////////////////////////////////////////////////////////////
// sub_6037108

void FindDecPos(long R4)
{
   unsigned long *tempvar0;
   unsigned char *tempvar1;
   unsigned long tempvar2;
   long i;

   dword_60396A4 = 1;
   byte_60396A8 = 0;
   byte_60396B0 = 0x80;

   if (R4 < 0)
      R4 += 255;

   tempvar0 = (unsigned long *)cmp_text_buffer2;
   tempvar2 = R4 >> 8;

#ifdef DEBUG
   printf("0603713C: R3 = %08x\n", DoubleWordSwap(tempvar0[tempvar2]));
#endif
   tempvar1 = (unsigned char *)(buffer + (DoubleWordSwap(tempvar0[tempvar2]) & 0xFFFFF));

   for (i = 0; i < R4; i++)
   {
      // 0603713C
      unsigned char tempvar3;

      tempvar3 = tempvar1[0] + 1;
//      printf("tempvar3 = %x\n", tempvar3);
      tempvar1 += tempvar3;
   }

   // 0603714A

   off_60396AC = tempvar1 + 1;
#ifdef DEBUG
   printf("06037150: R1 = %08x\n", (unsigned long)(tempvar1 + 1 - buffer) + 0x00200000);
#endif
}

// sub_6037174

unsigned char Decode_byte()
{
   unsigned char *tempvar0; // + 0x0
   unsigned char tempvar1; // + 0x4
   unsigned char *tempvar2; // + 0x8 
   unsigned char tempvar3; // + 0xC
   unsigned long *tempvar4;
   unsigned char tempvar5;
   unsigned char *tempvar6;
   long i, i2; // R8, R6;

   tempvar1 = 0x80;

   tempvar2 = off_60396AC;
   tempvar3 = byte_60396B0;

   tempvar4 = (unsigned long *)(cmp_text_buffer + (byte_60396A8 << 3));

#ifdef DEBUG
   printf("buffer = %08x tempvar4 = %08x @cmp_text_buffer = %08x\n", buffer, tempvar4, cmp_text_buffer - buffer);
#endif

   tempvar6 = (unsigned char *)(buffer + (DoubleWordSwap(tempvar4[0]) & 0xFFFFF));
   tempvar0 = (unsigned char *)(buffer + (DoubleWordSwap(tempvar4[1]) & 0xFFFFF));

#ifdef DEBUG
   printf("tempvar6 = %08x tempvar0 = %08x\n\n", tempvar6, tempvar0);
#endif

   i = 0;

   for (;;)
   {
      // 060371B0
      if (tempvar0[0] & tempvar1)
         tempvar5 = 1;
      else
         tempvar5 = 0;

      tempvar1 >>= 1;

      // 060371C8
      if (tempvar1 == 0)
      {
         tempvar0++;
         tempvar1 = 0x80;
      }


      // R6 = R15;
      // 060371D6
      if (tempvar5 == 1)
      {
         // is this actually correct?
         break;
      }

      if (tempvar2[0] & tempvar3)
         tempvar5 = 1;
      else
         tempvar5 = 0;

      tempvar3 >>= 1;

      // 060371F8
      if (tempvar3 == 0)
      {
         tempvar2++;
         tempvar3 = 0x80;
      }

      // R6 = @R15
      //06037206
      if (tempvar5 != 1) continue;

      // 0603720C
      i2 = 0;
      for(;;)
      {
         // 0603721C
         if (tempvar0[0] & tempvar1)
            tempvar5 = 1;
         else
            tempvar5 = 0;

         tempvar1 >>= 1;

         if (tempvar1 == 0)
         {
            tempvar0++;
            tempvar1 = 0x80;
         }

         // 0603723A
         if (tempvar5 == 0)
         {
            i2++;
         }
         else
         {
            i++;
            i2--;
         }

         if (i2 < 0)
            break;
      }
   }

   // 06037250
   byte_60396A8 = tempvar6[i];
   off_60396AC = tempvar2;
   byte_60396B0 = tempvar3;

   return tempvar6[i];
}

//////////////////////////////////////////////////////////////////////////////

unsigned long GrabLong(unsigned char *buf)
{
   return ((buf[0] << 24) | (buf[1] << 16) | (buf[2] << 8) | buf[3]);
}

//////////////////////////////////////////////////////////////////////////////

int ParseX5(unsigned char *buf)
{
   unsigned long header_size=0;
   unsigned char num_entries=0;
   unsigned long *x5_offset;
   int i;

   // Grab first 4 bytes and figure out the size of the header
   header_size = GrabLong(buf) & 0xFFFFF;
   num_entries = header_size / 0xC;

   // allocate a structure to hold all the offsets
   if ((x5_offset = (unsigned long *)malloc(sizeof(unsigned long) * num_entries)) == NULL)
      return -1;

   // Grab all offsets
   for (i = 0; i < num_entries; i++)
      x5_offset[i] = GrabLong(buf + (i * 0xC)) & 0xFFFFF;

   // The first offset points to ???
   // The second(only in jap) offset points to ???
   // The second last offset points to the compressed text data
   // The last offset points to ???

   cmp_text_buffer = (unsigned char *)(buf + x5_offset[num_entries - 2]);
   cmp_text_buffer2 = (unsigned char *)(buf + x5_offset[num_entries - 1]);

//   printf("buf = %08x\n", buf);
//   printf("cmp_text_buffer = %08x\n", cmp_text_buffer);
//   printf("cmp_text_buffer2 = %08x\n", cmp_text_buffer2);

   free(x5_offset);

   return 0;
}

//////////////////////////////////////////////////////////////////////////////

